﻿// Copyright (C) 2010, 2011, 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: PtSimConfig.cs 442 2013-03-04 11:56:25Z panacoran $

using System;
using System.IO;

namespace Protra.Lib.Config
{
    /// <summary>
    /// PtSimの設定を読み書きするクラス。
    /// </summary>
    public class PtSimConfig : ConfigBase
    {
        /// <summary>
        /// システムの実行モードの設定を取得または設定する。
        /// </summary>
        public int Mode { get; set; }

        /// <summary>
        /// 銘柄リストの名前の設定を取得または設定する。
        /// </summary>
        public string BrandListName { get; set; }

        /// <summary>
        /// 設定ファイルの名前を取得する。
        /// </summary>
        protected override string ConfigName
        {
            get { return "ptsim"; }
        }

        /// <summary>
        /// 古い設定ファイルを読み込む。
        /// </summary>
        protected override void ReadOldConfig()
        {
            try
            {
                var ptsim = new ConfigFile("ptsim");
                ptsim.Read();
                Mode = int.Parse(ptsim["Mode"]);
                var bl = Db.BrandListTable.GetRecord(int.Parse(ptsim["BrandListId"]));
                BrandListName = bl.Name;
            }
            catch (IOException)
            {
            }
            catch (FormatException)
            {
            }
        }
    }
}
