﻿// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008, 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: StatementNode.cs 455 2013-06-08 11:52:33Z panacoran $

namespace Protra.Lib.Lang
{
    /// <summary>
    /// 文のノードを表すクラスです。
    /// </summary>
    public class StatementNode : Node
    {
        /// <summary>
        /// 構文解析する。
        /// </summary>
        /// <exception cref="Protra.Lib.Lang.ParseException">
        /// 構文解析中にエラーが発生したときにthrowされる。
        /// </exception>
        public override Node Parse()
        {
            Token = Scanner.Token;
            switch (Token.Value)
            {
                case "if":
                    return new IfStatementNode().Parse();
                case "while":
                    return new WhileStatementNode().Parse();
                case "return":
                    return new ReturnStatementNode().Parse();
                case "break":
                    return new BreakStatementNode().Parse();
                case "continue":
                    return new ContinueStatementNode().Parse();
                case ";":
                    return new EmptyStatementNode().Parse();
                default:
                    return new ExpressionStatementNode().Parse();
            }
        }

        /// <summary>
        /// プログラムを実行する。
        /// </summary>
        /// <exception cref="Protra.Lib.Lang.RuntimeException">
        /// プログラム実行中にエラーが発生した場合にthrowされる。
        /// </exception>
        /// <param name="resource">リソース</param>
        /// <param name="at">int型@作用素の値</param>
        /// <param name="ats">string型@作用素の値</param>
        /// <returns>実行結果</returns>
        public override Value Execute(Resource resource, int at, string ats)
        {
            return null;
        }
    }
}