﻿// Copyright(C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008, 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: PrimaryNode.cs 472 2013-06-26 15:26:49Z panacoran $

namespace Protra.Lib.Lang
{
    /// <summary>
    /// 一次子のノードを表すクラス。
    /// </summary>
    public class PrimaryNode : ExpressionNode
    {
        /// <summary>
        /// 構文解析する。
        /// </summary>
        /// <exception cref="Protra.Lib.Lang.ParseException">
        /// 構文解析中にエラーが発生したときにthrowされる。
        /// </exception>
        /// <return>
        /// 解析した結果のノード。
        /// </return>
        public override ExpressionNode Parse(Scanner scanner)
        {
            Token = scanner.Token;

            if (Token.Type == TokenType.LocalVariable ||
                Token.Type == TokenType.GlobalVariable)
                return new VariableNode().Parse(scanner);

            if (Token.Type == TokenType.Int ||
                Token.Type == TokenType.Float ||
                Token.Type == TokenType.String ||
                Token.Value == "null")
                return new LiteralNode().Parse(scanner);

            if (Token.Type == TokenType.FunctionName)
                return new FunctionNode().Parse(scanner);

            if (Token.Value == "[")
                return new ArrayNode().Parse(scanner);

            if (Token.Value == "(")
            {
                scanner.Scan();
                var node = new ExpressionNode().Parse(scanner);
                if (scanner.Token.Value != ")")
                    throw new ParseException("')' expected", Token);
                scanner.Scan();
                return node;
            }
            throw new ParseException("syntax error", Token);
        }

        /// <summary>
        /// 式を評価する。
        /// </summary>
        /// <exception cref="Protra.Lib.Lang.RuntimeException">
        /// 評価中にエラーが発生した場合にthrowされる。
        /// </exception>
        /// <param name="resource">リソース</param>
        /// <param name="at">int型@作用素の値</param>
        /// <param name="ats">string型@作用素の値</param>
        /// <returns>値</returns>
        public override Value Evaluate(Resource resource, int at, string ats)
        {
            return null;
        }
    }
}