// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004, 2005 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: System.cs,v 1.7 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Db
{
	/// <summary>
	/// Systeme[ũR[h\B
	/// </summary>
	public class TradingSystem: IRecord
	{
		private int id;
		private string file;
		private int mode;

		/// <summary>
		/// ̃RXgN^
		/// </summary>
		public TradingSystem() {}

		/// <summary>
		/// RXgN^
		/// </summary>
		private TradingSystem(int id, string file, int mode)
		{
			this.id = id;
			this.file = file;
			this.mode = mode;
		}

		/// <summary>
		/// VXeID擾B
		/// </summary>
		public int Id
		{
			get { return id; }
		}

		/// <summary>
		/// t@C擾B
		/// </summary>
		public string File
		{
			get { return file; }
		}

		/// <summary>
		/// [h擾B[hȂ0AT[hȂ1B
		/// </summary>
		public int Mode
		{
			get { return mode; }
		}

		/// <summary>
		/// f[^x[X̃R[hIuWFNgɕϊB
		/// </summary>
		/// <param name="values">lCeBu`̒l̔z</param>
		/// <returns>ϊTradingSystemIuWFNgԂB</returns>
		public Object ToObject(Object[] values)
		{
			return new TradingSystem((int)values[0], // @Id
									 (string)values[1], // @File
									 (int)values[2]); // @Mode
		}

		/// <summary>
		/// CX^X𕶎\ɕϊB
		/// </summary>
		/// <returns>\</returns>
		public override string ToString()
		{
			return string.Format("TradingSystem[Id={0}, File={1}, Mode={2}]",
								 id, file, mode);
		}
	}

	/// <summary>
	/// Systeme[u𑀍삷B
	/// </summary>
	public class SystemTable
	{
		private static Connection conn;
		private static Connection Conn
		{
			get 
			{
				if (conn != null)
					return conn;
				conn = new Connection("protra");
				return conn;
			}
		}

		/// <summary>
		/// w肳ꂽVXeID̃R[h擾B
		/// </summary>
		/// <param name="id">VXeID</param>
		/// <returns>TradingSystemIuWFNgԂBR[h݂ȂꍇɂnullԂB</returns>
		public static TradingSystem GetRecord(int id)
		{
			string sql =
				string.Format("SELECT * FROM System WHERE @Id={0}", id);
			ArrayList result = Conn.Query(sql, new TradingSystem());
			return result.Count == 0 ? null : (TradingSystem)result[0];
		}

		/// <summary>
		/// w肳ꂽt@Cƃ[h̃R[h擾B
		/// </summary>
		/// <param name="file">t@C</param>
		/// <param name="mode">[h</param>
		/// <returns>TradingSystemIuWFNgԂBR[h݂ȂꍇɂnullԂB</returns>
		public static TradingSystem GetRecord(string file, int mode)
		{
			string sql = string.Format(
				"SELECT * FROM System WHERE @File='{0}' AND @Mode={1}",
				file, mode);
			ArrayList result = Conn.Query(sql, new TradingSystem());
			return result.Count == 0 ? null : (TradingSystem)result[0];
		}

		/// <summary>
		/// ׂẴR[h擾B
		/// </summary>
		/// <returns>TradingSystemIuWFNg̔zԂB</returns>
		public static TradingSystem[] GetAllRecords()
		{
			string sql = "SELECT * FROM System ORDER BY @Id";
			ArrayList result = Conn.Query(sql, new TradingSystem());
			return (TradingSystem[])result.ToArray(typeof(TradingSystem));
		}

		/// <summary>
		/// R[hǉB
		/// </summary>
		/// <param name="file">t@C</param>
		/// <param name="mode">[h</param>
		/// <returns>ǉꂽR[hԂ</returns>
		public static TradingSystem Add(string file, int mode)
		{
			string sql = string.Format(
				"INSERT INTO System(@File, @Mode) VALUES('{0}', {1})",
				file, mode);
			Conn.Execute(sql);
			TradingSystem[] all = GetAllRecords();
			return all[all.Length - 1];
		}

		/// <summary>
		/// w肳ꂽVXeID̃f[^폜B
		/// </summary>
		/// <param name="id">VXeID</param>
		public static void Delete(int id)
		{
			string sql = string.Format("DELETE FROM Price WHERE @Id={0}", id);
			Conn.Execute(sql);
		}

		/// <summary>
		/// Sf[^폜B
		/// </summary>
		public static void Delete()
		{
			string sql = "DELETE FROM System";
			Conn.Execute(sql);
		}
	}
}
