// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: FunctionNode.cs,v 1.6 2008-04-17 12:59:09 panacoran Exp $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ֐̃m[h\NXB
	/// </summary>
	public class FunctionNode : Node
	{
		/// <summary>
		/// ֐̃^Cv
		/// </summary>
		private FunctionType ft;
		/// <summary>
		/// ̃m[h̃Xg
		/// </summary>
		private List<Node> nodeList = new List<Node>();
        
		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
		{
			Token = Scanner.Token;

			// ֐̎擾
			string name = Scanner.Token.Value;

			// ̃`FbN
            Scanner.Scan();
			if (Scanner.Token.Value != "(")
			{
				ft = new FunctionType(name, 0);
				return this;
			}
            Scanner.Scan();
			if (Scanner.Token.Value == ")")
			{
				ft = new FunctionType(name, 0);
                Scanner.Scan();
				return this;
			}
			do
			{
				nodeList.Add(new ExpressionNode().Parse());
				if (Scanner.Token.Value == ")")
				{
					ft = new FunctionType(name, nodeList.Count);
                    Scanner.Scan();
					return this;
				}
				else if (Scanner.Token.Value != ",")
					throw new ParseException("',' or ')' expected", Token);
			}
            while (Scanner.Scan());
            throw new ParseException("unexpected EOF", Token);
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			// ֐`ĂΎs
			if(resource.FunctionTable.ContainsKey(ft))
			{	
				// ֐`m[h̎擾
				FunctionDefinitionNode fdn = resource.FunctionTable[ft];

				// X^bNt[p
                Value[] frame = new Value[fdn.FrameSize];
				frame[0] = new Value(at);
				for(int i = 0; i < nodeList.Count; i++)
                    frame[i + 1] = nodeList[i].Execute(resource, at);
				
				resource.Stack.Push(frame);

				// ̎s
				List<Node> nodes = fdn.Nodes;
                try
                {
                    foreach (Node node in nodes)
                        node.Execute(resource, at);
                    return null;
                }
                catch (ReturnStatementExecutedException e)
                {
                    return e.Value;
                }
                finally
                {
                    resource.Stack.Pop();
                }
			}

			// gݍ݊֐sB
            try
            {
                Value[] args = new Value[nodeList.Count];
                for (int i = 0; i < nodeList.Count; i++)
                {
                    Node node = (Node)nodeList[i];
                    args[i] = node.Execute(resource, at);
                }
                return resource.Builtins.Invoke(ft.Name, args, at);
            }
            catch (NoSuchBuiltinException)
            {
                throw new RuntimeException("undefined function --- " + ft.ToString(), Token);
            }
            catch (NullReferenceException e)
            {
                throw new RuntimeException(e.Message, Token);
            }
		}
	}
}
