﻿// Copyright (C) 2004 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: EditBrandListDialog.cs 306 2010-03-19 13:21:22Z panacoran $

using System.Windows.Forms;
using Protra.Lib.Config;
using Protra.Lib.Db;

namespace PtSim.Dialogs
{
	/// <summary>
	/// 銘柄リストを編集するためのダイアログです。
	/// </summary>
	public class EditBrandListDialog : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label labelBrandList;
		private System.Windows.Forms.Label labelContent;
		private System.Windows.Forms.ListBox listBoxBrandList;
		private System.Windows.Forms.ListView listViewContent;
		private System.Windows.Forms.ColumnHeader columnHeaderMarket;
		private System.Windows.Forms.ColumnHeader columnHeaderCode;
		private System.Windows.Forms.ColumnHeader columnHeaderName;
		private System.Windows.Forms.Button buttonAdd;
		private System.Windows.Forms.Button buttonEdit;
		private System.Windows.Forms.Button buttonDelete;
		private System.Windows.Forms.Button buttonExit;
		/// <summary>
		/// 必要なデザイナ変数です。
		/// </summary>
		private System.ComponentModel.Container components = null;


        BrandListConfig listConfig;

        /// <summary>
		/// コンストラクタ
		/// </summary>
		public EditBrandListDialog(BrandListConfig listConfig)
		{
			//
			// Windows フォーム デザイナ サポートに必要です。
			//
			InitializeComponent();

            this.listConfig = listConfig;
            foreach (var list in listConfig.List)
            {
                if (list.Name == "お気に入り")
                    continue;
                listBoxBrandList.Items.Add(list);
            }
            if (listBoxBrandList.Items.Count > 0)
                listBoxBrandList.SelectedIndex = 0;
		}

		/// <summary>
		/// 使用されているリソースに後処理を実行します。
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows フォーム デザイナで生成されたコード 
		/// <summary>
		/// デザイナ サポートに必要なメソッドです。このメソッドの内容を
		/// コード エディタで変更しないでください。
		/// </summary>
		private void InitializeComponent()
		{
			this.labelBrandList = new System.Windows.Forms.Label();
			this.labelContent = new System.Windows.Forms.Label();
			this.listBoxBrandList = new System.Windows.Forms.ListBox();
			this.listViewContent = new System.Windows.Forms.ListView();
			this.columnHeaderMarket = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderCode = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderName = new System.Windows.Forms.ColumnHeader();
			this.buttonAdd = new System.Windows.Forms.Button();
			this.buttonEdit = new System.Windows.Forms.Button();
			this.buttonDelete = new System.Windows.Forms.Button();
			this.buttonExit = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// labelBrandList
			// 
			this.labelBrandList.Location = new System.Drawing.Point(8, 8);
			this.labelBrandList.Name = "labelBrandList";
			this.labelBrandList.Size = new System.Drawing.Size(56, 16);
			this.labelBrandList.TabIndex = 0;
			this.labelBrandList.Text = "銘柄リスト";
			// 
			// labelContent
			// 
			this.labelContent.Location = new System.Drawing.Point(8, 120);
			this.labelContent.Name = "labelContent";
			this.labelContent.Size = new System.Drawing.Size(32, 16);
			this.labelContent.TabIndex = 6;
			this.labelContent.Text = "内容";
			// 
			// listBoxBrandList
			// 
			this.listBoxBrandList.ItemHeight = 12;
			this.listBoxBrandList.Location = new System.Drawing.Point(8, 24);
			this.listBoxBrandList.Name = "listBoxBrandList";
			this.listBoxBrandList.Size = new System.Drawing.Size(128, 88);
			this.listBoxBrandList.Sorted = true;
			this.listBoxBrandList.TabIndex = 1;
			this.listBoxBrandList.SelectedIndexChanged += new System.EventHandler(this.listBoxBrandList_SelectedIndexChanged);
			// 
			// listViewContent
			// 
			this.listViewContent.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnHeaderMarket,
																							  this.columnHeaderCode,
																							  this.columnHeaderName});
			this.listViewContent.FullRowSelect = true;
			this.listViewContent.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.listViewContent.Location = new System.Drawing.Point(8, 136);
			this.listViewContent.Name = "listViewContent";
			this.listViewContent.Size = new System.Drawing.Size(280, 184);
			this.listViewContent.TabIndex = 7;
			this.listViewContent.View = System.Windows.Forms.View.Details;
			// 
			// columnHeaderMarket
			// 
			this.columnHeaderMarket.Text = "市場";
			this.columnHeaderMarket.Width = 69;
			// 
			// columnHeaderCode
			// 
			this.columnHeaderCode.Text = "コード";
			this.columnHeaderCode.Width = 59;
			// 
			// columnHeaderName
			// 
			this.columnHeaderName.Text = "銘柄名";
			this.columnHeaderName.Width = 114;
			// 
			// buttonAdd
			// 
			this.buttonAdd.Location = new System.Drawing.Point(144, 24);
			this.buttonAdd.Name = "buttonAdd";
			this.buttonAdd.Size = new System.Drawing.Size(64, 23);
			this.buttonAdd.TabIndex = 2;
			this.buttonAdd.Text = "追加";
			this.buttonAdd.Click += new System.EventHandler(this.buttonAdd_Click);
			// 
			// buttonEdit
			// 
			this.buttonEdit.Location = new System.Drawing.Point(144, 56);
			this.buttonEdit.Name = "buttonEdit";
			this.buttonEdit.Size = new System.Drawing.Size(64, 23);
			this.buttonEdit.TabIndex = 3;
			this.buttonEdit.Text = "編集";
			this.buttonEdit.Click += new System.EventHandler(this.buttonEdit_Click);
			// 
			// buttonDelete
			// 
			this.buttonDelete.Location = new System.Drawing.Point(144, 88);
			this.buttonDelete.Name = "buttonDelete";
			this.buttonDelete.Size = new System.Drawing.Size(64, 23);
			this.buttonDelete.TabIndex = 4;
			this.buttonDelete.Text = "削除";
			this.buttonDelete.Click += new System.EventHandler(this.buttonDelete_Click);
			// 
			// buttonExit
			// 
			this.buttonExit.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonExit.Location = new System.Drawing.Point(216, 24);
			this.buttonExit.Name = "buttonExit";
			this.buttonExit.TabIndex = 5;
			this.buttonExit.Text = "終了";
			// 
			// EditBrandListDialog
			// 
			this.AcceptButton = this.buttonExit;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(298, 333);
			this.ControlBox = false;
			this.Controls.Add(this.buttonExit);
			this.Controls.Add(this.buttonDelete);
			this.Controls.Add(this.buttonEdit);
			this.Controls.Add(this.buttonAdd);
			this.Controls.Add(this.listViewContent);
			this.Controls.Add(this.listBoxBrandList);
			this.Controls.Add(this.labelContent);
			this.Controls.Add(this.labelBrandList);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditBrandListDialog";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "銘柄リスト編集";
			this.ResumeLayout(false);

		}
		#endregion

		private void buttonAdd_Click(object sender, System.EventArgs e)
		{
            using (var dialog = new EditBrandListContentDialog(listConfig))
            {
                DialogResult result = dialog.ShowDialog(this);
                if (result == DialogResult.OK)
                {
                    listBoxBrandList.Items.Add(dialog.SelectedList);
                    listBoxBrandList.SelectedItem = dialog.SelectedList;
                }
            }
		}

		private void buttonEdit_Click(object sender, System.EventArgs e)
		{
			var item = listBoxBrandList.SelectedItem;
			if (item == null)
                return;
			using (var dialog = new EditBrandListContentDialog(listConfig))
            {
                dialog.SelectedList = (Protra.Lib.Config.BrandList)item;
				DialogResult result = dialog.ShowDialog(this);
				if(result == DialogResult.OK)
				{
					listBoxBrandList.Items.Remove(item);
					listBoxBrandList.Items.Add(item);
					listBoxBrandList.SelectedItem = item;
				}
			}
		}

		private void buttonDelete_Click(object sender, System.EventArgs e)
		{
            var item = (Protra.Lib.Config.BrandList)listBoxBrandList.SelectedItem;
            if (item == null)
                return;			
			string msg = string.Format(
				"{0}を削除します。よろしいですか？", item.Name);
			var result = MessageBox.Show(
					this, msg, "確認", MessageBoxButtons.OKCancel,
					MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1);
			if (result != DialogResult.OK)
                return;
			int index = listBoxBrandList.SelectedIndex;
			listBoxBrandList.Items.Remove(item);
			listConfig.List.Remove(item);
            listConfig.Save();
			if (index < listBoxBrandList.Items.Count)
				listBoxBrandList.SelectedIndex = index;
			else if (listBoxBrandList.Items.Count > 0)
				listBoxBrandList.SelectedIndex = index - 1;
		}

		private void listBoxBrandList_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			listViewContent.Items.Clear();
			var item = (Protra.Lib.Config.BrandList)listBoxBrandList.SelectedItem;
            if (item == null)
                return;
            var listItems = new ListView.ListViewItemCollection(listViewContent);
			foreach (var id in item.List)
            {
                var brand = BrandTable.GetRecordByNewId(id);
                listItems.Add(new ListViewItem(new string [] {
                    brand.Market.Name,
                    brand.Code.ToString(),
                    brand.Name
                }));
            }
		}
	}
}
