// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2007 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Value.cs,v 1.5 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Text.RegularExpressions;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// vOňl𓝈Iɕ\邽߂̃NXłB
	/// </summary>
	[Serializable]
	public class Value : IComparable
	{
		/// <summary>
		/// ľ^\񋓌^łB
		/// </summary>
		public enum Type : byte
		{
			/// <summary>
			/// int
			/// </summary>
			Int,
			/// <summary>
			/// float
			/// </summary>
			Float,
			/// <summary>
			/// string
			/// </summary>
			String,
			/// <summary>
			/// array
			/// </summary>
			Array
		}

		/// <summary>
		/// l̎
		/// </summary>
		private object val;
		/// <summary>
		/// ľ^
		/// </summary>
		private Type type;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="val">l</param>
		public Value(int val)
		{
			this.val = val;
			this.type = Type.Int;
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="val">l</param>
		public Value(double val)
		{
			this.val = val;
			this.type = Type.Float;
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="val">_l</param>
		public Value(bool val)
		{
			this.val = val ? 1 : 0;
			this.type = Type.Int;
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="val"></param>
		public Value(string val)
		{
			this.val = val;
			this.type = Type.String;
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="val">z</param>
		public Value(Value[] val)
		{
			this.val = val;
			this.type = Type.Array;
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="val">l</param>
		public Value(Value val)
		{
			this.val = val.val;
			this.type = val.type;
		}

		/// <summary>
		/// Il̎̂擾܂B
		/// </summary>
		public object InnerValue
		{
			get { return val; }
		}

		/// <summary>
		/// ^l擾܂B
		/// </summary>
		public Type ValueType
		{
			get { return type; }
		}

		/// <summary>
		/// ltrueƕ]邩ǂ_l擾܂B
		/// 0falseAȊOtrueɂȂ܂B
		/// </summary>
		public bool IsTrue
		{
			get
			{
				return !IsFalse;
			}
		}

		/// <summary>
		/// lfalseƕ]邩ǂ_l擾܂B
		/// 0falseAȊOtrueɂȂ܂B
		/// </summary>
		public bool IsFalse
		{
			get
			{
				return type == Type.Int && (int)val == 0 ||
					type == Type.Float && (double)val == 0;

			}
		}

		/// <summary>
		/// z̗vf擾܂͐ݒ肵܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		public Value this[Value index]
		{
			get
			{
				if(index == null)
					throw new RuntimeException("assigned null for index", null);
				if(type != Type.Array)
					throw new RuntimeException("assigned index for non-array", null);
				if(index.type != Type.Int)
					throw new RuntimeException("assigned non-int value for array index", null);
				
				try
				{
					return ((Value[])val)[(int)index.val];
				}
				catch(IndexOutOfRangeException)
				{
					throw new RuntimeException("array index out of range", null);
				}
			}

			set
			{
				if(index == null)
					throw new RuntimeException("assigned null for index", null);
				if(type != Type.Array)
					throw new RuntimeException("assigned index for non-array", null);
				if(index.type != Type.Int)
					throw new RuntimeException("assigned non-int value for array index", null);

				try
				{
					((Value[])val)[(int)index.val] = value;
				}
				catch(IndexOutOfRangeException)
				{
					throw new RuntimeException("array index out of range", null);
				}
			}
		}

		/// <summary>
		/// w肳ꂽ^ɃLXg܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="type">^</param>
		/// <returns>LXgʂłB</returns>
		public Value Cast(Type type)
		{
			if(this.type == Type.Array)
				throw new RuntimeException("array casted", null);
			if(type == Type.String)
				return new Value(val.ToString());

			switch(this.type)
			{
				case Type.Int:
					switch(type)
					{
						case Type.Int:
							return new Value((int)val);
						case Type.Float:
							return new Value((double)(int)val);
					}
					break;
				case Type.Float:
					switch(type)
					{
						case Type.Int:
							return new Value((int)(double)val);
						case Type.Float:
							return new Value((double)val);
					}
					break;
				case Type.String:
					switch(type)
					{
						case Type.Int:
							try
							{
								return new Value(int.Parse((string)val));
							}
							catch(FormatException)
							{
								return new Value(0);
							}
						case Type.Float:
							try
							{
								return new Value(double.Parse((string)val));
							}
							catch(FormatException)
							{
								return new Value(0.0);
							}
					}
					break;
			}

			throw new RuntimeException("unexpected error", null);
		}

		/// <summary>
		/// w肵IuWFNgƓǂ𔻒f܂B
		/// </summary>
		/// <param name="o">IuWFNg</param>
		/// <returns>trueɂȂ܂B</returns>
		public override bool Equals(object o)
		{
			if (!(o is Value))
				return false;
			Value v = (Value)o;
			if (type == Type.Array || type == Type.String ||
				v.type == Type.Array || v.type == Type.String)
				return val.Equals(v.val);
			return CompareTo(v) == 0;
		}

		/// <summary>
		/// nbVlvZ܂B
		/// </summary>
		/// <returns>nbVl</returns>
		public override int GetHashCode()
		{
			return val.GetHashCode();
		}

		/// <summary>
		/// w肵IuWFNgƑ召r܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="o">IuWFNg</param>
		/// <returns>rʂłB</returns>
		public int CompareTo(object o)
		{
			Value v = (Value)o;
			if(type == Type.Array || v.type == Type.Array)
				throw new RuntimeException("array compared", null);
			switch(type)
			{
				case Type.Int:
					switch (v.type)
					{
						case Type.Int:
							return (int)val - (int)v.val;
						case Type.Float:
							return Math.Sign((int)val - (double)v.val);
						case Type.String:
							throw new RuntimeException("int compared with string", null);
					}
					break;
				case Type.Float:
					switch(v.type)
					{
						case Type.Int:
							return Math.Sign((double)val - (int)v.val);
						case Type.Float:
							return Math.Sign((double)val - (double)v.val);
						case Type.String:
							throw new RuntimeException("float compared with string", null);
					}
					break;
				case Type.String:
					switch(v.type)
					{
						case Type.Int:
							throw new RuntimeException("string compared with int", null);
						case Type.Float:
							throw new RuntimeException("string compared with float", null);
						case Type.String:
							return ((string)val).CompareTo(v.val);
					}
					break;
			}
			throw new RuntimeException("unexpected error", null);
		}

		/// <summary>
		/// rs܂B
		/// </summary>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>rʂłB</returns>
		public static bool operator==(Value v1, Value v2)
		{
			if ((object)v1 != null)
				return v1.Equals(v2);
			return (object)v2 == null;
		}

		/// <summary>
		/// rs܂B
		/// </summary>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>rʂłB</returns>
		public static bool operator!=(Value v1, Value v2)
		{
			return !(v1 == v2);
		}

		/// <summary>
		/// _avZ܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>ZʂłB</returns>
		public static Value operator|(Value v1, Value v2)
		{
			bool b1 = (v1 != null) && v1.IsTrue;
			bool b2 = (v2 != null) && v2.IsTrue;
			if(b1 || b2)
				return new Value(1);
			else
				return new Value(0);
		}

		/// <summary>
		/// _ςvZ܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>ZʂłB</returns>
		public static Value operator&(Value v1, Value v2)
		{
			bool b1 = (v1 != null) && v1.IsTrue;
			bool b2 = (v2 != null) && v2.IsTrue;
			if(b1 && b2)
				return new Value(1);
			else
				return new Value(0);
		}

		/// <summary>
		/// 召rs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>rʂłB</returns>
		public static bool operator<(Value v1, Value v2)
		{
			if(v1 == null || v2 == null)
				throw new RuntimeException("null compared", null);
			return v1.CompareTo(v2) < 0;
		}

		/// <summary>
		/// 召rs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>rʂłB</returns>
		public static bool operator>(Value v1, Value v2)
		{
			if(v1 == null || v2 == null)
				throw new RuntimeException("null compared", null);
			return v1.CompareTo(v2) > 0;
		}

		/// <summary>
		/// 召rs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>rʂłB</returns>
		public static bool operator<=(Value v1, Value v2)
		{
			if(v1 == null || v2 == null)
				throw new RuntimeException("null compared", null);
			return v1.CompareTo(v2) <= 0;
		}

		/// <summary>
		/// 召rs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>rʂłB</returns>
		public static bool operator>=(Value v1, Value v2)
		{
			if(v1 == null || v2 == null)
				throw new RuntimeException("null compared", null);
			return v1.CompareTo(v2) >= 0;
		}

		/// <summary>
		/// avZ܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>ZʂłB</returns>
		public static Value operator+(Value v1, Value v2)
		{
			if(v1 == null || v2 == null)
				throw new RuntimeException("binary operator '+' isn't defined for null", null);
			if(v1.type == Type.Array || v2.type == Type.Array)
				throw new RuntimeException("binary operator '+' isn't defined for array", null);
			switch(v1.type)
			{
				case Type.Int:
					switch(v2.type)
					{
						case Type.Int:
							return new Value((int)v1.val + (int)v2.val);
						case Type.Float:
							return new Value((int)v1.val + (double)v2.val);
						case Type.String:
							return new Value(v1.val.ToString() + v2.val.ToString());
					}
					break;
				case Type.Float:
					switch(v2.type)
					{
						case Type.Int:
							return new Value((double)v1.val + (int)v2.val);
						case Type.Float:
							return new Value((double)v1.val + (double)v2.val);
						case Type.String:
							return new Value(v1.val.ToString() + v2.val.ToString());
					}
					break;
				case Type.String:
					return new Value(v1.val.ToString() + v2.val.ToString());
			}

			throw new RuntimeException("unexpected error", null);
		}

		/// <summary>
		/// vZ܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>ZʂłB</returns>
		public static Value operator-(Value v1, Value v2)
		{
			if(v1 == null || v2 == null)
				throw new RuntimeException("binary operator '-' isn't defined for null", null);
			if(v1.type == Type.String || v2.type == Type.String)
				throw new RuntimeException("binary operator '-' isn't defined for string", null);
			if(v1.type == Type.Array || v2.type == Type.Array)
				throw new RuntimeException("binary operator '-' isn't defined for array", null);
			switch(v1.type)
			{
				case Type.Int:
					switch(v2.type)
					{
						case Type.Int:
							return new Value((int)v1.val - (int)v2.val);
						case Type.Float:
							return new Value((int)v1.val - (double)v2.val);
					}
					break;
				case Type.Float:
					switch(v2.type)
					{
						case Type.Int:
							return new Value((double)v1.val - (int)v2.val);
						case Type.Float:
							return new Value((double)v1.val - (double)v2.val);
					}
					break;
			}

			throw new RuntimeException("unexpected error", null);
		}

		/// <summary>
		/// ςvZ܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>ZʂłB</returns>
		public static Value operator*(Value v1, Value v2)
		{
			if(v1 == null || v2 == null)
				throw new RuntimeException("binary operator '*' isn't defined for null", null);
			if(v1.type == Type.String || v2.type == Type.String)
				throw new RuntimeException("binary operator '*' isn't defined for string", null);
			if(v1.type == Type.Array || v2.type == Type.Array)
				throw new RuntimeException("binary operator '*' isn't defined for array", null);
			switch(v1.type)
			{
				case Type.Int:
					switch(v2.type)
					{
						case Type.Int:
							return new Value((int)v1.val * (int)v2.val);
						case Type.Float:
							return new Value((int)v1.val * (double)v2.val);
					}
					break;
				case Type.Float:
					switch(v2.type)
					{
						case Type.Int:
							return new Value((double)v1.val * (int)v2.val);
						case Type.Float:
							return new Value((double)v1.val * (double)v2.val);
					}
					break;
			}

			throw new RuntimeException("unexpected error", null);
		}

		/// <summary>
		/// vZ܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>ZʂłB</returns>
		public static Value operator/(Value v1, Value v2)
		{
			if(v1 == null || v2 == null)
				throw new RuntimeException("binary operator '/' isn't defined for null", null);
			if(v1.type == Type.String || v2.type == Type.String)
				throw new RuntimeException("binary operator '/' isn't defined for string", null);
			if(v1.type == Type.Array || v2.type == Type.Array)
				throw new RuntimeException("binary operator '/' isn't defined for array", null);
			switch(v1.type)
			{
				case Type.Int:
					switch(v2.type)
					{
						case Type.Int:
							if ((int)v2.val == 0)
								throw new RuntimeException("divided by 0", null);
							return new Value((int)v1.val / (int)v2.val);
						case Type.Float:
							if ((double)v2.val == 0.0)
								throw new RuntimeException("divided by 0", null);
							return new Value((int)v1.val / (double)v2.val);
					}
					break;
				case Type.Float:
					switch(v2.type)
					{
						case Type.Int:
							if ((int)v2.val == 0)
								throw new RuntimeException("divided by 0", null);
							return new Value((double)v1.val / (int)v2.val);
						case Type.Float:
							if ((double)v2.val == 0.0)
								throw new RuntimeException("divided by 0", null);
							return new Value((double)v1.val / (double)v2.val);
					}
					break;
			}

			throw new RuntimeException("unexpected error", null);
		}

		/// <summary>
		/// ]vZ܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v1">Iyh1</param>
		/// <param name="v2">Iyh2</param>
		/// <returns>ZʂłB</returns>
		public static Value operator%(Value v1, Value v2)
		{
			if(v1 == null || v2 == null)
				throw new RuntimeException("binary operator '%' isn't defined for null", null);
			if(v1.type == Type.Float || v2.type == Type.Float)
				throw new RuntimeException("binary operator '%' isn't defined for float", null);
			if(v1.type == Type.String || v2.type == Type.String)
				throw new RuntimeException("binary operator '%' isn't defined for string", null);
			if(v1.type == Type.Array || v2.type == Type.Array)
				throw new RuntimeException("binary operator '%' isn't defined for array", null);
			switch(v1.type)
			{
				case Type.Int:
					switch(v2.type)
					{
						case Type.Int:
							return new Value((int)v1.val % (int)v2.val);
					}
					break;
			}

			throw new RuntimeException("unexpected error", null);
		}

		/// <summary>
		/// ےvZ܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v">Iyh</param>
		/// <returns>ZʂłB</returns>
		public static Value operator!(Value v)
		{
			return new Value(v == null || v.IsFalse);
		}

		/// <summary>
		/// vXvZ܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v">Iyh</param>
		/// <returns>ZʂłB</returns>
		public static Value operator+(Value v)
		{
			switch(v.type)
			{
				case Type.Int:
				case Type.Float:
					return new Value(v);
				case Type.String:
					throw new RuntimeException("unary operator '+' isn't defined for string", null);
				case Type.Array:
					throw new RuntimeException("unary operator '+' isn't defined for array", null);
			}

			throw new RuntimeException("unexpected error", null);
		}

		/// <summary>
		/// }CiXvZ܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="v">Iyh</param>
		/// <returns>ZʂłB</returns>
		public static Value operator-(Value v)
		{
			switch(v.type)
			{
				case Type.Int:
					return new Value(-(int)v.val);
				case Type.Float:
					return new Value(-(double)v.val);
				case Type.String:
					throw new RuntimeException("unary operator '-' isn't defined for string", null);
				case Type.Array:
					throw new RuntimeException("unary operator '-' isn't defined for array", null);
			}

			throw new RuntimeException("unexpected error", null);
		}
	}
}
