// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004, 2005, 2007, 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: OptionDialog.cs,v 1.12 2008-08-25 09:22:42 panacoran Exp $

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Protra.Lib;
using Protra.Lib.Update;

namespace Protra.Dialogs
{
	/// <summary>
	/// IvṼ_CAOłB
	/// </summary>
	public class OptionDialog : System.Windows.Forms.Form
	{
		/// <summary>
		/// IvV
		/// </summary>
		private Option option;

		private System.Windows.Forms.TabControl tabControl;
		private System.Windows.Forms.TabPage tabPageChart;
		private System.Windows.Forms.TabPage tabPageUpload;
		private System.Windows.Forms.Button buttonOk;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.NumericUpDown numericUpDownChartNum;
		private System.Windows.Forms.Label labelChartNum;
		private System.Windows.Forms.GroupBox groupBoxChartColor;
		private System.Windows.Forms.Label labelChartBackColor;
		private System.Windows.Forms.Label labelChartForeColor;
		private System.Windows.Forms.Button buttonChartBackColor;
		private System.Windows.Forms.Button buttonChartForeColor;
        private System.Windows.Forms.GroupBox groupBoxProxy;
		private System.Windows.Forms.Label labelProxyAddress;
		private System.Windows.Forms.Label labelProxyPort;
		private System.Windows.Forms.TextBox textBoxProxyAddress;
		private System.Windows.Forms.TextBox textBoxProxyPort;
		private System.Windows.Forms.Label labelPriceDataSource;
		private System.Windows.Forms.ComboBox comboBoxPriceDataSource;
		private System.Windows.Forms.Label labelDataSourceInfo;
		private System.Windows.Forms.CheckBox drawLastWeek;
		private System.Windows.Forms.CheckBox useDifferentChart;
        private RadioButton radioButtonOriginalProxy;
        private RadioButton radioButtonIEProxy;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="option">IvV</param>
		public OptionDialog(Option option)
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

            this.comboBoxPriceDataSource.Items.AddRange(PriceDataUpdator.DataSourceNames);
			this.option = option;
			this.radioButtonOriginalProxy.Checked = option.UseProxy;
			this.textBoxProxyAddress.Text = option.ProxyAddress;
			if(option.ProxyPort >= 0)
				this.textBoxProxyPort.Text = option.ProxyPort.ToString();
			this.comboBoxPriceDataSource.SelectedIndex = (int)option.PriceDataSource;
			this.numericUpDownChartNum.Value = option.ChartNum;
			this.buttonChartBackColor.BackColor = option.ChartBackColor;
			this.buttonChartForeColor.BackColor = option.ChartForeColor;
			this.drawLastWeek.Checked = option.DrawLastWeek;
			this.useDifferentChart.Checked = option.UseDifferentChart;
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
            this.tabControl = new System.Windows.Forms.TabControl();
            this.tabPageUpload = new System.Windows.Forms.TabPage();
            this.labelDataSourceInfo = new System.Windows.Forms.Label();
            this.comboBoxPriceDataSource = new System.Windows.Forms.ComboBox();
            this.labelPriceDataSource = new System.Windows.Forms.Label();
            this.groupBoxProxy = new System.Windows.Forms.GroupBox();
            this.radioButtonOriginalProxy = new System.Windows.Forms.RadioButton();
            this.radioButtonIEProxy = new System.Windows.Forms.RadioButton();
            this.textBoxProxyPort = new System.Windows.Forms.TextBox();
            this.textBoxProxyAddress = new System.Windows.Forms.TextBox();
            this.labelProxyPort = new System.Windows.Forms.Label();
            this.labelProxyAddress = new System.Windows.Forms.Label();
            this.tabPageChart = new System.Windows.Forms.TabPage();
            this.useDifferentChart = new System.Windows.Forms.CheckBox();
            this.drawLastWeek = new System.Windows.Forms.CheckBox();
            this.groupBoxChartColor = new System.Windows.Forms.GroupBox();
            this.buttonChartForeColor = new System.Windows.Forms.Button();
            this.buttonChartBackColor = new System.Windows.Forms.Button();
            this.labelChartForeColor = new System.Windows.Forms.Label();
            this.labelChartBackColor = new System.Windows.Forms.Label();
            this.numericUpDownChartNum = new System.Windows.Forms.NumericUpDown();
            this.labelChartNum = new System.Windows.Forms.Label();
            this.buttonOk = new System.Windows.Forms.Button();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.tabControl.SuspendLayout();
            this.tabPageUpload.SuspendLayout();
            this.groupBoxProxy.SuspendLayout();
            this.tabPageChart.SuspendLayout();
            this.groupBoxChartColor.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownChartNum)).BeginInit();
            this.SuspendLayout();
            // 
            // tabControl
            // 
            this.tabControl.Controls.Add(this.tabPageUpload);
            this.tabControl.Controls.Add(this.tabPageChart);
            this.tabControl.Location = new System.Drawing.Point(8, 8);
            this.tabControl.Name = "tabControl";
            this.tabControl.SelectedIndex = 0;
            this.tabControl.Size = new System.Drawing.Size(376, 277);
            this.tabControl.TabIndex = 0;
            // 
            // tabPageUpload
            // 
            this.tabPageUpload.Controls.Add(this.labelDataSourceInfo);
            this.tabPageUpload.Controls.Add(this.comboBoxPriceDataSource);
            this.tabPageUpload.Controls.Add(this.labelPriceDataSource);
            this.tabPageUpload.Controls.Add(this.groupBoxProxy);
            this.tabPageUpload.Location = new System.Drawing.Point(4, 21);
            this.tabPageUpload.Name = "tabPageUpload";
            this.tabPageUpload.Size = new System.Drawing.Size(368, 252);
            this.tabPageUpload.TabIndex = 1;
            this.tabPageUpload.Text = "f[^XV";
            // 
            // labelDataSourceInfo
            // 
            this.labelDataSourceInfo.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.labelDataSourceInfo.Location = new System.Drawing.Point(28, 54);
            this.labelDataSourceInfo.Name = "labelDataSourceInfo";
            this.labelDataSourceInfo.Padding = new System.Windows.Forms.Padding(3);
            this.labelDataSourceInfo.Size = new System.Drawing.Size(316, 44);
            this.labelDataSourceInfo.TabIndex = 3;
            this.labelDataSourceInfo.Text = "f[^\[XIĂB";
            // 
            // comboBoxPriceDataSource
            // 
            this.comboBoxPriceDataSource.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboBoxPriceDataSource.Location = new System.Drawing.Point(117, 21);
            this.comboBoxPriceDataSource.Name = "comboBoxPriceDataSource";
            this.comboBoxPriceDataSource.Size = new System.Drawing.Size(163, 20);
            this.comboBoxPriceDataSource.TabIndex = 2;
            this.comboBoxPriceDataSource.SelectedIndexChanged += new System.EventHandler(this.comboBoxPriceDataSource_SelectedIndexChanged);
            // 
            // labelPriceDataSource
            // 
            this.labelPriceDataSource.Location = new System.Drawing.Point(28, 24);
            this.labelPriceDataSource.Name = "labelPriceDataSource";
            this.labelPriceDataSource.Size = new System.Drawing.Size(92, 16);
            this.labelPriceDataSource.TabIndex = 1;
            this.labelPriceDataSource.Text = "f[^\[X";
            // 
            // groupBoxProxy
            // 
            this.groupBoxProxy.Controls.Add(this.radioButtonOriginalProxy);
            this.groupBoxProxy.Controls.Add(this.radioButtonIEProxy);
            this.groupBoxProxy.Controls.Add(this.textBoxProxyPort);
            this.groupBoxProxy.Controls.Add(this.textBoxProxyAddress);
            this.groupBoxProxy.Controls.Add(this.labelProxyPort);
            this.groupBoxProxy.Controls.Add(this.labelProxyAddress);
            this.groupBoxProxy.Location = new System.Drawing.Point(28, 120);
            this.groupBoxProxy.Name = "groupBoxProxy";
            this.groupBoxProxy.Size = new System.Drawing.Size(316, 112);
            this.groupBoxProxy.TabIndex = 0;
            this.groupBoxProxy.TabStop = false;
            this.groupBoxProxy.Text = "vLVT[o";
            // 
            // radioButtonOriginalProxy
            // 
            this.radioButtonOriginalProxy.AutoSize = true;
            this.radioButtonOriginalProxy.Location = new System.Drawing.Point(16, 40);
            this.radioButtonOriginalProxy.Name = "radioButtonOriginalProxy";
            this.radioButtonOriginalProxy.Size = new System.Drawing.Size(133, 16);
            this.radioButtonOriginalProxy.TabIndex = 7;
            this.radioButtonOriginalProxy.Text = "ȉ̐ݒgp";
            this.radioButtonOriginalProxy.UseVisualStyleBackColor = true;
            this.radioButtonOriginalProxy.CheckedChanged += new System.EventHandler(this.radioButtonOriginalProxy_CheckedChanged);
            // 
            // radioButtonIEProxy
            // 
            this.radioButtonIEProxy.AutoSize = true;
            this.radioButtonIEProxy.Checked = true;
            this.radioButtonIEProxy.Location = new System.Drawing.Point(16, 18);
            this.radioButtonIEProxy.Name = "radioButtonIEProxy";
            this.radioButtonIEProxy.Size = new System.Drawing.Size(194, 16);
            this.radioButtonIEProxy.TabIndex = 6;
            this.radioButtonIEProxy.TabStop = true;
            this.radioButtonIEProxy.Text = "Internet Explorer̐ݒgp";
            this.radioButtonIEProxy.UseVisualStyleBackColor = true;
            // 
            // textBoxProxyPort
            // 
            this.textBoxProxyPort.Enabled = false;
            this.textBoxProxyPort.Location = new System.Drawing.Point(246, 78);
            this.textBoxProxyPort.Name = "textBoxProxyPort";
            this.textBoxProxyPort.Size = new System.Drawing.Size(56, 19);
            this.textBoxProxyPort.TabIndex = 4;
            // 
            // textBoxProxyAddress
            // 
            this.textBoxProxyAddress.Enabled = false;
            this.textBoxProxyAddress.Location = new System.Drawing.Point(16, 78);
            this.textBoxProxyAddress.Name = "textBoxProxyAddress";
            this.textBoxProxyAddress.Size = new System.Drawing.Size(220, 19);
            this.textBoxProxyAddress.TabIndex = 3;
            // 
            // labelProxyPort
            // 
            this.labelProxyPort.Enabled = false;
            this.labelProxyPort.Location = new System.Drawing.Point(242, 62);
            this.labelProxyPort.Name = "labelProxyPort";
            this.labelProxyPort.Size = new System.Drawing.Size(48, 16);
            this.labelProxyPort.TabIndex = 2;
            this.labelProxyPort.Text = "|[g";
            // 
            // labelProxyAddress
            // 
            this.labelProxyAddress.Enabled = false;
            this.labelProxyAddress.Location = new System.Drawing.Point(14, 62);
            this.labelProxyAddress.Name = "labelProxyAddress";
            this.labelProxyAddress.Size = new System.Drawing.Size(48, 16);
            this.labelProxyAddress.TabIndex = 1;
            this.labelProxyAddress.Text = "AhX";
            // 
            // tabPageChart
            // 
            this.tabPageChart.Controls.Add(this.useDifferentChart);
            this.tabPageChart.Controls.Add(this.drawLastWeek);
            this.tabPageChart.Controls.Add(this.groupBoxChartColor);
            this.tabPageChart.Controls.Add(this.numericUpDownChartNum);
            this.tabPageChart.Controls.Add(this.labelChartNum);
            this.tabPageChart.Location = new System.Drawing.Point(4, 21);
            this.tabPageChart.Name = "tabPageChart";
            this.tabPageChart.Size = new System.Drawing.Size(368, 251);
            this.tabPageChart.TabIndex = 0;
            this.tabPageChart.Text = "`[g";
            // 
            // useDifferentChart
            // 
            this.useDifferentChart.Location = new System.Drawing.Point(32, 80);
            this.useDifferentChart.Name = "useDifferentChart";
            this.useDifferentChart.Size = new System.Drawing.Size(220, 24);
            this.useDifferentChart.TabIndex = 5;
            this.useDifferentChart.Text = "TƓňقȂ`[ggp";
            // 
            // drawLastWeek
            // 
            this.drawLastWeek.Location = new System.Drawing.Point(32, 56);
            this.drawLastWeek.Name = "drawLastWeek";
            this.drawLastWeek.Size = new System.Drawing.Size(172, 24);
            this.drawLastWeek.TabIndex = 4;
            this.drawLastWeek.Text = "T̓rŏT`悷";
            // 
            // groupBoxChartColor
            // 
            this.groupBoxChartColor.Controls.Add(this.buttonChartForeColor);
            this.groupBoxChartColor.Controls.Add(this.buttonChartBackColor);
            this.groupBoxChartColor.Controls.Add(this.labelChartForeColor);
            this.groupBoxChartColor.Controls.Add(this.labelChartBackColor);
            this.groupBoxChartColor.Location = new System.Drawing.Point(28, 124);
            this.groupBoxChartColor.Name = "groupBoxChartColor";
            this.groupBoxChartColor.Size = new System.Drawing.Size(316, 100);
            this.groupBoxChartColor.TabIndex = 2;
            this.groupBoxChartColor.TabStop = false;
            this.groupBoxChartColor.Text = "zF";
            // 
            // buttonChartForeColor
            // 
            this.buttonChartForeColor.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.buttonChartForeColor.Location = new System.Drawing.Point(80, 56);
            this.buttonChartForeColor.Name = "buttonChartForeColor";
            this.buttonChartForeColor.Size = new System.Drawing.Size(75, 20);
            this.buttonChartForeColor.TabIndex = 3;
            this.buttonChartForeColor.Click += new System.EventHandler(this.buttonChartForeColor_Click);
            // 
            // buttonChartBackColor
            // 
            this.buttonChartBackColor.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.buttonChartBackColor.Location = new System.Drawing.Point(80, 28);
            this.buttonChartBackColor.Name = "buttonChartBackColor";
            this.buttonChartBackColor.Size = new System.Drawing.Size(75, 20);
            this.buttonChartBackColor.TabIndex = 2;
            this.buttonChartBackColor.Click += new System.EventHandler(this.buttonChartBackColor_Click);
            // 
            // labelChartForeColor
            // 
            this.labelChartForeColor.Location = new System.Drawing.Point(24, 60);
            this.labelChartForeColor.Name = "labelChartForeColor";
            this.labelChartForeColor.Size = new System.Drawing.Size(48, 16);
            this.labelChartForeColor.TabIndex = 1;
            this.labelChartForeColor.Text = "OiF";
            // 
            // labelChartBackColor
            // 
            this.labelChartBackColor.Location = new System.Drawing.Point(24, 32);
            this.labelChartBackColor.Name = "labelChartBackColor";
            this.labelChartBackColor.Size = new System.Drawing.Size(48, 16);
            this.labelChartBackColor.TabIndex = 0;
            this.labelChartBackColor.Text = "wiF";
            // 
            // numericUpDownChartNum
            // 
            this.numericUpDownChartNum.Location = new System.Drawing.Point(116, 24);
            this.numericUpDownChartNum.Maximum = new decimal(new int[] {
            6,
            0,
            0,
            0});
            this.numericUpDownChartNum.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.numericUpDownChartNum.Name = "numericUpDownChartNum";
            this.numericUpDownChartNum.Size = new System.Drawing.Size(56, 19);
            this.numericUpDownChartNum.TabIndex = 1;
            this.numericUpDownChartNum.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            // 
            // labelChartNum
            // 
            this.labelChartNum.Location = new System.Drawing.Point(28, 28);
            this.labelChartNum.Name = "labelChartNum";
            this.labelChartNum.Size = new System.Drawing.Size(84, 16);
            this.labelChartNum.TabIndex = 0;
            this.labelChartNum.Text = "`[ǧ";
            // 
            // buttonOk
            // 
            this.buttonOk.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonOk.Location = new System.Drawing.Point(230, 290);
            this.buttonOk.Name = "buttonOk";
            this.buttonOk.Size = new System.Drawing.Size(75, 23);
            this.buttonOk.TabIndex = 1;
            this.buttonOk.Text = "OK";
            this.buttonOk.Click += new System.EventHandler(this.buttonOk_Click);
            // 
            // buttonCancel
            // 
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Location = new System.Drawing.Point(311, 290);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.Size = new System.Drawing.Size(75, 23);
            this.buttonCancel.TabIndex = 2;
            this.buttonCancel.Text = "LZ";
            // 
            // OptionDialog
            // 
            this.AcceptButton = this.buttonOk;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.CancelButton = this.buttonCancel;
            this.ClientSize = new System.Drawing.Size(394, 322);
            this.ControlBox = false;
            this.Controls.Add(this.buttonCancel);
            this.Controls.Add(this.buttonOk);
            this.Controls.Add(this.tabControl);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "OptionDialog";
            this.ShowInTaskbar = false;
            this.Text = "IvV";
            this.tabControl.ResumeLayout(false);
            this.tabPageUpload.ResumeLayout(false);
            this.groupBoxProxy.ResumeLayout(false);
            this.groupBoxProxy.PerformLayout();
            this.tabPageChart.ResumeLayout(false);
            this.groupBoxChartColor.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownChartNum)).EndInit();
            this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// ݒ肳ĂIvV擾܂B
		/// </summary>
		public Option Option
		{
			get { return option; }
		}

		private void buttonOk_Click(object sender, System.EventArgs e)
		{
            option.UseProxy = this.radioButtonOriginalProxy.Checked;
			option.ProxyAddress = this.textBoxProxyAddress.Text;
			try
			{
				option.ProxyPort = int.Parse(this.textBoxProxyPort.Text);
			}
			catch(FormatException)
			{
				option.ProxyPort = -1;
			}
			option.PriceDataSource = (PriceDataSource)this.comboBoxPriceDataSource.SelectedIndex;
			option.ChartNum = (int)this.numericUpDownChartNum.Value;
			option.DrawLastWeek = this.drawLastWeek.Checked;
			option.UseDifferentChart = this.useDifferentChart.Checked;
			option.ChartBackColor = this.buttonChartBackColor.BackColor;
			option.ChartForeColor = this.buttonChartForeColor.BackColor;

			option.Save();
		}

		private void comboBoxPriceDataSource_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			PriceDataSource dataSource = (PriceDataSource)this.comboBoxPriceDataSource.SelectedIndex;
            this.labelDataSourceInfo.Text = PriceDataUpdator.GetDescription(dataSource);
		}

		private void buttonChartBackColor_Click(object sender, System.EventArgs e)
		{
			ColorDialog dialog = new ColorDialog();
            dialog.CustomColors = new int[] { ColorTranslator.ToWin32(Color.FromKnownColor(KnownColor.Control)) };
			DialogResult result = dialog.ShowDialog(this);
			if(result == DialogResult.OK)
			{
				this.buttonChartBackColor.BackColor = dialog.Color;
			}
		}

		private void buttonChartForeColor_Click(object sender, System.EventArgs e)
		{
			ColorDialog dialog = new ColorDialog();
			DialogResult result = dialog.ShowDialog(this);
			if(result == DialogResult.OK)
			{
				this.buttonChartForeColor.BackColor = dialog.Color;
			}
		}

        private void radioButtonOriginalProxy_CheckedChanged(object sender, EventArgs e)
        {
            Boolean enabled = radioButtonOriginalProxy.Checked;
            labelProxyAddress.Enabled = enabled;
            labelProxyPort.Enabled = enabled;
            textBoxProxyAddress.Enabled = enabled;
            textBoxProxyPort.Enabled = enabled;

        }
	}
}
