// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// $Id: ContinueStatementNode.cs,v 1.4 2008-03-26 22:12:54 panacoran Exp $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// continuẽm[h\NXB
	/// </summary>
	public class ContinueStatementNode : Node
	{
		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
        {
            Token = Scanner.Token;
            Scanner.Scan();
            return this;
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <exception cref="Protra.Lib.Lang.ContinueStatementExecutedException">
		/// KthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			throw new ContinueStatementExecutedException();
		}
	}

	/// <summary>
	/// ContinueStatementNode.ExecuteĂ΂ꂽƂthrowOB
	/// </summary>
	public class ContinueStatementExecutedException : Exception {}
}
