// Copyright(C) 2008 panacorn <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: KdbComUpdator.cs,v 1.4 2008-08-27 13:36:33 panacoran Exp $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Text;
using Protra.Lib.Db;

namespace Protra.Lib.Update
{
	/// <summary>
	/// f[^_E[hTCg𗘗pĊf[^̍XVsNXB
	/// </summary>
	public class KdbComUpdator: PriceDataUpdator
	{
        /// <summary>
        /// f[^݂ŏ̓t擾B
        /// </summary>
        public static DateTime DataSince
        {
            get {
                DateTime tmp = DateTime.Now.AddMonths(-6);
                return new DateTime(tmp.Year, tmp.Month, tmp.Day);
            }
        }

        /// <summary>
		/// f[^XVB
		/// </summary>
		/// <param name="worker">BackgroundWorker</param>
        /// <param name="e">DoWorkCxg̈</param>
		public override void Update(BackgroundWorker worker, DoWorkEventArgs e)
		{
            DateTime begin = (DateTime)e.Argument;
            if (begin < DataSince)
                begin = DataSince;
			DateTime today = DateTime.Now;
			// Vf[^û͑Ăߌ4ȍ~
			if (today.Hour < 16)
				today = today.AddDays(-1);

            Dictionary<DateTime, double> indexVolume = GetIndexVolume();

            for (Start(begin, today); ShouldContinue(); NextDate())
			{
				UpdateProgress(worker, e);

                StartDownload();
                DownloadUtil.Url =
                    "http://k-db.com/site/download.aspx?date=" +
                    Date.ToString(@"yyyy-MM-dd-\d") + "&hyouji=1";
                Stream stream = DownloadUtil.GetResponse();
                if (stream == null)
                {
                    DecrementTotalDays();
                    continue;
                }
                if (worker.CancellationPending)
                {
                    e.Cancel = true;
                    stream.Close();
                    return;
                }
                StreamReader reader = new StreamReader(stream, Encoding.GetEncoding("shift_jis"));
                List<PriceData> dataList = new List<PriceData>();
                string line;
                while ((line = reader.ReadLine()) != null)
                {
                    PriceData tmp = ParseLine(line);
                    if (tmp != null)
                    {
                        tmp.Date = Date; // eR[hɂ͓tȂB
                        if (tmp.Code == 1001 || tmp.Code == 1002)
                            tmp.Volume = indexVolume[Date];
                        dataList.Add(tmp);
                    }
                }
                reader.Close();
                TotalRecords = dataList.Count;
                EndDownload();

                for (; NumRecords < TotalRecords; IncrementRecords(), UpdateProgress(worker, e))
                {
                    if (worker.CancellationPending)
                    {
                        e.Cancel = true;
                        PriceTable.Delete(Date);
                        return;
                    }
                    
                    PriceData data = (PriceData)dataList[NumRecords];
                    Brand brand = BrandTable.GetRecordOrCreate(data.MarketId, data.Code, data.Name);
                    PriceTable.Add(brand.Id, data.Date, data.Open, data.High, data.Low, data.Close, data.Volume);
                }
                IncrementDays();
            }
			UpdateSplitData(worker, e);
            worker.ReportProgress(100, "");
		}

        Dictionary<DateTime, double> GetIndexVolume()
        {
            DownloadUtil.Url = "http://k-db.com/site/toukei.aspx?market=T1&download=csv";
            Stream stream = DownloadUtil.GetResponse();
            if (stream == null)
                throw new ApplicationException("sꓝvf[^̓ǂݍ݂Ɏs܂B");
            StreamReader reader = new StreamReader(stream, Encoding.GetEncoding("shift_jis"));
            string line;
            Dictionary<DateTime, Double> indexVolume = new Dictionary<DateTime, double>();
            while ((line = reader.ReadLine()) != null)
            {
                string[] tokens = line.Split(',');
                if ((tokens[0] == "؂P") || (tokens[0] == "t"))
                    continue;
                DateTime date = DateTime.ParseExact(tokens[0], "yyyyNMMdd", null);
                double volume = Math.Round(double.Parse(tokens[1]) / 1000, MidpointRounding.AwayFromZero);
                indexVolume[date] = volume;
            }
            reader.Close();
            return indexVolume;
        }

        /// <summary>
        /// Ɋ܂܂f[^i[IuWFNgԂB
        /// </summary>
        /// <param name="line">w肷B</param>
        /// <returns>IuWFNg</returns>
        private PriceData ParseLine(string line)
        {
            string[] tokens = line.Split(',');
            PriceData r = new PriceData();
            try
            {
                int i = 0;
				if (tokens[i] == "w")
				{
					if (tokens[2] == "TOPIX")
						r.Code = 1002;
					else if (tokens[2] == "o")
						r.Code = 1001;
					else
						return null;
				}
				else
					r.Code = int.Parse(tokens[i]);
				switch (tokens[++i])
				{
					case "":
						if (r.Code == 1001 || r.Code == 1002)
                            r.MarketId = Db.MarketId.Tokyo1;
						else
							return null;
						break;
					case "":
					case "؂P":
						r.MarketId = Db.MarketId.Tokyo1;
						break;
					case "؂Q":
						r.MarketId = Db.MarketId.Tokyo2;
						break;
					case "؃}U[Y":
					case "؃}U[YO":
						r.MarketId = Db.MarketId.Mothers;
						break;
                    case "؂PO":
                        r.MarketId = MarketId.TokyoForeign;
                        break;
                    case "":
                    case "؂P":
                        r.MarketId = MarketId.Osaka1;
                        break;
                    case "؂Q":
                        r.MarketId = MarketId.Osaka2;
                        break;
                    case "gbX^_[h":
                    case "gbX^_[hO":
                    case "gbO[X":
                        r.MarketId = MarketId.Hercules;
                        break;
                    case "":
                    case "؂P":
                        r.MarketId = MarketId.Nagoya1;
                        break;
                    case "؂Q":
                        r.MarketId = MarketId.Nagoya2;
                        break;
                    case "ip":
                    case "ipmdn":
                        r.MarketId = MarketId.Jasdaq;
                        break;
					default:
						return null;
                }
				r.Name = tokens[++i];
                r.Open = (int)ParseField(tokens[++i]);
                r.High = (int)ParseField(tokens[++i]);
                r.Low = (int)ParseField(tokens[++i]);
                r.Close = (int)ParseField(tokens[++i]);
                r.Volume = ParseField(tokens[++i]) / 1000;
            }
            catch (FormatException)
            {
                // tH[}bgG[͑SB
                return null;
            }
            return r;
        }

		private double ParseField(string s)
		{
			// ȃtB[h"-"0ƂĈB
			if (s == "-")
				return 0;
			// w̒lɏ܂܂Ă̂double.Parse𗘗pB
			return double.Parse(s);
		}
	}
}
