#include "common.h"

#include "unpackpsar.h"
#include "packer.h"
#include "usb.h"

PSP_MODULE_INFO("PSP_Ex_Tools", PSP_MODULE_USER, 1, 1);
PSP_MAIN_THREAD_ATTR(0);



//int exit_callback(int arg1, int arg2, void *common)
//{
//	if( IsWork == 0 ) sceKernelExitGame();
//	
//    return 0;
//}
//
//
//int CallbackThread(SceSize args, void *argp)
//{
//    int cbid = sceKernelCreateCallback("Exit Callback", exit_callback, NULL);
//
//    sceKernelRegisterExitCallback(cbid);
//    sceKernelSleepThreadCB();
//
//    return 0;
//}
//
//
//int SetupCallbacks(void)
//{
//    int thid = sceKernelCreateThread("update_thread", CallbackThread, 0x11, 0xFA0, 0, 0);
//
//    if (thid >= 0)	sceKernelStartThread(thid, 0, 0);
//
//    return thid;
//}




int main(void)
{
	//int ret;

	//SetupCallbacks();
	pspDebugScreenInit();
	
	//if (sceKernelDevkitVersion() < 0x02070110)
	//{
	//	ErrorExit(10000, "This program requires 2.71 or higher.\n", "If you are in a cfw, please reexecute psardumper on the higher kernel.\n");
	//}
	
	SceUID mod = pspSdkLoadStartModule("Bridge.prx", PSP_MEMORY_PARTITION_KERNEL);
	if (mod < 0)
	{
		ErrorExit(5000, "Error 0x%08X loading/starting Bridge.prx.\n", mod);
	}
	

	//printf("pack = %d\n",pspPack( "host0:/pspdecrypt.prx" ,pspPackOpt_FIX_PBP_ATTR ));
	//printf("unpack = %d\n",pspUnpack("host0:/E.PBP"));

	sceIoMkdir("ms0:/PSPExT", 0777);
	sceIoMkdir("ms0:/PSPExT/Pack", 0777);
	sceIoMkdir("ms0:/PSPExT/Unpack", 0777);

	int mode = -1;

	while (1)
	{
		SceCtrlData pad;
		
		sceCtrlReadBufferPositive(&pad, 1);
		
		if (pad.Buttons & PSP_CTRL_CIRCLE)
		{
			mode = 0;
			break;
		}
		else if (pad.Buttons & PSP_CTRL_SQUARE)
		{
			mode = 1;
			break;
		}
		
		sceKernelDelayThread(10000);
	}

	char dname[256];
	const char *tgt = NULL;

	if( mode == 0 )
	{
		tgt = "Pack";
	}
	else
	{
		tgt = "Unpack";
	}

	printf("Mode = %s\n",tgt);

	sprintf(dname,"ms0:/PSPExT/%s", tgt );

	extDirObj *obj = extDirOpen(dname);
	extDirEnt *ent = NULL;

	if( obj )
	{
		while( (ent = extDirNext(obj)) )
		{	
			if( extDirEntType(ent) == extEnt_File )
			{
				char name[256];
				int ret = 0;
				
				sprintf(name,"%s/%s",dname,ent->entry.d_name);

				if( mode == 0 )
				{
					ret = pspPack(name,pspPackOpt_FIX_PBP_ATTR);
					printf("Pack (%s) = %d\n",ent->entry.d_name,ret);
				}
				else
				{
					ret = pspUnpack(name);
					printf("Unpack (%s) = %d\n",ent->entry.d_name,ret);
				}
			}
		}
	}
	else
	{
		printf("Not Found '%s'.\n",dname);
	}

	extDirClose(obj);


	sceKernelDelayThread(1000000);
    scePowerTick(0);
	ErrorExit(10000, "Done.\n");
	
    return 0;
}


/*
	printf("total = 0x%08X , max = 0x%08X\n",sceKernelTotalFreeMemSize(),sceKernelMaxFreeMemSize());


	if( UsbLoad() != -1 )
	{
		if( IsEnableUsb() == 0 )
		{
			setPathRoot( "host0:/" );

			printf("USBHOSTFS OK\n");
		}
		else
		{
			setPathRoot( "ms0:/" );
			
			UsbUnload();

			printf("USBHOSTFS NG\n");
		}
	}
	
	
	int mode = MODE_ENCRYPT_SIGCHECK;

	while (1)
	{
		SceCtrlData pad;
		
		sceCtrlReadBufferPositive(&pad, 1);
		
		if (pad.Buttons & PSP_CTRL_CROSS)
		{
			mode = MODE_ENCRYPT_SIGCHECK;
			break;
		}
		else if (pad.Buttons & PSP_CTRL_CIRCLE)
		{
			mode = MODE_ENCRYPT;
			break;
		}
		else if (pad.Buttons & PSP_CTRL_SQUARE)
		{
			mode = MODE_DECRYPT;
			break;
		}
		
		sceKernelDelayThread(10000);
	}
	
	printf("DecodeInit = %d\n",DecodeInit());
	UnpacktPsar("host0:/EBOOT.pbp",mode);
*/





	//int size = GetSize(FILE_TMP_NAME);
	//gzDeComppresFile("host0:/decomp.prx",FILE_TMP_NAME, 0x150, size - 0x150);


	//int size = GetSize( "host0:/NP.PBP" );
	//gzComppresFile( "host0:/NP.PBP", "host0:/NP.gz", 0, size);

	//ret = gzComppresFile( "host0:/NP.PBP", "host0:/NP.gz", 0);

	//printf("comp ret = %d\n",ret);
	//PackFile( root, "host0:/EBOOT.PBP" , 1 );
	//printf("size = %d\n",sizeof(PSP_Header));

	//gzComppres("host0:/pspdecrypt.prx", "host0:/pspdecrypt.gz", 0 );

	//WriteFileAppend("host0:/pspdecrypt.prx", "host0:/EBOOT.PBP", 0x10,0x40);
	//WriteFileAppend("host0:/pspdecrypt.prx", "host0:/EBOOT.PBP", 0x100,0x200);






//const char *t_com[] = {"com:00000"};
//const char *t_1g[] = { "01g:00000" , "00001" };
//const char *t_2g[] = { "02g:00000" , "00002" };
//const char *t_3g[] = {"00003"};
//const char *t_4g[] = {"00004"};
//
//
//
//
//typedef struct
//{
//	const char **list;
//	int *size;
//	void *buf;
//} table_info;

//table_info







