typedef struct
{
	u32 tag; // 4 byte value at offset 0xD0 in the PRX file
	u8* key; // "step1_result" use for XOR step
	u8 code;
	u8 codeExtra;
} TAG_INFO;


typedef struct
{
	u32 tag; // 4 byte value at offset 0xD0 in the PRX file
	u8  *key; // 16 bytes keys
	u8 code; // code for scramble
} TAG_INFO2;

typedef struct
{
	u32 mklow;
	u32 mkhigh;
	u8 *key_S;
} TABLE_KEYS;



////////// Decryption 1 //////////

// use pre-calculated keys (step1 results)

u32 g_key0[] =
{
	0x7b21f3be, 0x299c5e1d, 0x1c9c5e71, 0x96cb4645, 0x3c9b1be0, 0xeb85de3d,
	0x4a7f2022, 0xc2206eaa, 0xd50b3265, 0x55770567, 0x3c080840, 0x981d55f2,
	0x5fd8f6f3, 0xee8eb0c5, 0x944d8152, 0xf8278651, 0x2705bafa, 0x8420e533,
	0x27154ae9, 0x4819aa32, 0x59a3aa40, 0x2cb3cf65, 0xf274466d, 0x3a655605,
	0x21b0f88f, 0xc5b18d26, 0x64c19051, 0xd669c94e, 0xe87035f2, 0x9d3a5909,
	0x6f4e7102, 0xdca946ce, 0x8416881b, 0xbab097a5, 0x249125c6, 0xb34c0872,
};

u32 g_key2[] =
{
	0xccfda932, 0x51c06f76, 0x046dcccf, 0x49e1821e, 0x7d3b024c, 0x9dda5865,
	0xcc8c9825, 0xd1e97db5, 0x6874d8cb, 0x3471c987, 0x72edb3fc, 0x81c8365d,
	0xe161e33a, 0xfc92db59, 0x2009b1ec, 0xb1a94ce4, 0x2f03696b, 0x87e236d8,
	0x3b2b8ce9, 0x0305e784, 0xf9710883, 0xb039db39, 0x893bea37, 0xe74d6805,
	0x2a5c38bd, 0xb08dc813, 0x15b32375, 0x46be4525, 0x0103fd90, 0xa90e87a2,
	0x52aba66a, 0x85bf7b80, 0x45e8ce63, 0x4dd716d3, 0xf5e30d2d, 0xaf3ae456,
};

u32 g_key3[] =
{
	0xa6c8f5ca, 0x6d67c080, 0x924f4d3a, 0x047ca06a, 0x08640297, 0x4fd4a758,
	0xbd685a87, 0x9b2701c2, 0x83b62a35, 0x726b533c, 0xe522fa0c, 0xc24b06b4,
	0x459d1cac, 0xa8c5417b, 0x4fea62a2, 0x0615d742, 0x30628d09, 0xc44fab14,
	0x69ff715e, 0xd2d8837d, 0xbeed0b8b, 0x1e6e57ae, 0x61e8c402, 0xbe367a06,
	0x543f2b5e, 0xdb3ec058, 0xbe852075, 0x1e7e4dcc, 0x1564ea55, 0xec7825b4,
	0xc0538cad, 0x70f72c7f, 0x49e8c3d0, 0xeda97ec5, 0xf492b0a4, 0xe05eb02a,
};

u32 g_key44[] =
{
	0xef80e005, 0x3a54689f, 0x43c99ccd, 0x1b7727be, 0x5cb80038, 0xdd2efe62,
	0xf369f92c, 0x160f94c5, 0x29560019, 0xbf3c10c5, 0xf2ce5566, 0xcea2c626,
	0xb601816f, 0x64e7481e, 0x0c34debd, 0x98f29cb0, 0x3fc504d7, 0xc8fb39f0,
	0x0221b3d8, 0x63f936a2, 0x9a3a4800, 0x6ecc32e3, 0x8e120cfd, 0xb0361623,
	0xaee1e689, 0x745502eb, 0xe4a6c61c, 0x74f23eb4, 0xd7fa5813, 0xb01916eb,
	0x12328457, 0xd2bc97d2, 0x646425d8, 0x328380a5, 0x43da8ab1, 0x4b122ac9,
};

u32 g_key20[] =
{
	0x33b50800, 0xf32f5fcd, 0x3c14881f, 0x6e8a2a95, 0x29feefd5, 0x1394eae3,
	0xbd6bd443, 0x0821c083, 0xfab379d3, 0xe613e165, 0xf5a754d3, 0x108b2952,
	0x0a4b1e15, 0x61eadeba, 0x557565df, 0x3b465301, 0xae54ecc3, 0x61423309,
	0x70c9ff19, 0x5b0ae5ec, 0x989df126, 0x9d987a5f, 0x55bc750e, 0xc66eba27,
	0x2de988e8, 0xf76600da, 0x0382dccb, 0x5569f5f2, 0x8e431262, 0x288fe3d3,
	0x656f2187, 0x37d12e9c, 0x2f539eb4, 0xa492998e, 0xed3958f7, 0x39e96523,
};

u32 g_key3A[] =
{
	0x67877069, 0x3abd5617, 0xc23ab1dc, 0xab57507d, 0x066a7f40, 0x24def9b9,
	0x06f759e4, 0xdcf524b1, 0x13793e5e, 0x0359022d, 0xaae7e1a2, 0x76b9b2fa,
	0x9a160340, 0x87822fba, 0x19e28fbb, 0x9e338a02, 0xd8007e9a, 0xea317af1,
	0x630671de, 0x0b67ca7c, 0x865192af, 0xea3c3526, 0x2b448c8e, 0x8b599254,
	0x4602e9cb, 0x4de16cda, 0xe164d5bb, 0x07ecd88e, 0x99ffe5f8, 0x768800c1,
	0x53b091ed, 0x84047434, 0xb426dbbc, 0x36f948bb, 0x46142158, 0x749bb492,
};

/* updaters keys */
u8 updaters_keys[0x90+0x14] = 
{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0B, 0x01, 0x1C, 0xE7, 0x31, 0x15, 0x6B, 0x83,
	0x3E, 0x26, 0x0D, 0xCC, 0x69, 0x36, 0x12, 0xCB,
	0xA7, 0xFD, 0x26, 0x66, 0x93, 0x2A, 0x6E, 0x1A,
	0x91, 0x2E, 0xC6, 0xFC, 0xD8, 0x2F, 0x00, 0x13,
	0x5A, 0xE2, 0xDF, 0xB6, 0xA2, 0xE4, 0x27, 0xC8,
	0x18, 0xC3, 0x50, 0x50, 0xB7, 0xE9, 0x4A, 0xED,
	0xCC, 0x3C, 0x30, 0xFD, 0x10, 0x6A, 0x2B, 0x0A,
	0x22, 0xCB, 0xC6, 0xE0, 0x20, 0x65, 0x12, 0xEB,
	0x7D, 0x4E, 0x2A, 0x37, 0x0B, 0x0A, 0xEF, 0x88,
	0xDA, 0x06, 0x54, 0xD4, 0x30, 0xAF, 0xCD, 0xCA,
	0x9A, 0xF9, 0xDA, 0x1A, 0xB0, 0x1B, 0xBB, 0x62,
	0x0C, 0xDB, 0xF8, 0x44, 0x73, 0x56, 0x14, 0x8E,
	0x93, 0xB1, 0x2C, 0xFD, 0x67, 0xE2, 0x5D, 0xCB,
	0x48, 0x5B, 0xD9, 0xB3, 0x54, 0x14, 0xD7, 0x9F,
	0x79, 0x9C, 0x24, 0xE9, 0xC2, 0x7A, 0x4E, 0x8C,
	0x4D, 0x24, 0x19, 0x94, 0xFF, 0xC9, 0xC2, 0x2D,
	0x23, 0x63, 0x51, 0xB8, 0xFA, 0xD6, 0x7F, 0xE6,
	0x5E, 0xBC, 0x32, 0xB2, 0x02, 0x13, 0xC4, 0x76
};

/* locoroco, kazue, and maybe others demos keys */
u8 demo_keys0[0x90+0x14] = 
{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x82, 0x4C, 0xA5, 0x18, 0xD3, 0xC8, 0x6E, 0xEA,
	0x17, 0x41, 0x04, 0xDC, 0xEA, 0xC5, 0x01, 0xFC,
	0x97, 0xB1, 0x94, 0x54, 0x71, 0x19, 0x22, 0xEE,
	0xE0, 0x2D, 0xE9, 0x83, 0x3D, 0x64, 0x30, 0xE6,
	0x42, 0x5C, 0x30, 0x5F, 0xEB, 0x41, 0xA0, 0xE0,
	0x62, 0xC6, 0x63, 0xEE, 0x5D, 0xA5, 0x0D, 0x1E,
	0xC2, 0x10, 0x14, 0x49, 0x06, 0xC6, 0x93, 0x84,
	0x71, 0xA5, 0x42, 0x63, 0x13, 0xF0, 0xB6, 0xD5,
	0x43, 0x51, 0x9E, 0xFA, 0x91, 0x0A, 0x7C, 0xE1,
	0x58, 0x1B, 0x95, 0x25, 0x40, 0x11, 0xF1, 0x8D,
	0xB1, 0x01, 0x8D, 0x04, 0x09, 0x54, 0x5C, 0x54,
	0xF5, 0x53, 0x08, 0xB0, 0x53, 0x85, 0xB4, 0xCE,
	0x0B, 0xF5, 0xC3, 0xFB, 0xC6, 0x55, 0x24, 0x0B,
	0xF2, 0xC6, 0x2C, 0xE4, 0x0C, 0xF0, 0x05, 0x3C,
	0xD7, 0x6C, 0x39, 0xD5, 0x87, 0x22, 0x09, 0xF7,
	0x3D, 0xC5, 0xA2, 0xFD, 0x55, 0x92, 0x3F, 0xB1,
	0xF6, 0xFE, 0xC8, 0x18, 0x1D, 0x6B, 0x04, 0x52, 
	0x5F, 0x8C, 0xE8, 0xE7, 0x26, 0x5A, 0x6E, 0x5A
};



static const TAG_INFO g_tagInfo[] =
{
	// 1.x PRXs
 	{ 0x00000000, (u8*)g_key0	, 0x42 },
 	{ 0x02000000, (u8*)g_key2	, 0x45 },
	{ 0x03000000, (u8*)g_key3	, 0x46 },
	
	// 2.0 PRXs
	{ 0x4467415d, (u8*)g_key44	, 0x59, 0x59 },
	{ 0x207bbf2f, (u8*)g_key20	, 0x5A, 0x5A },
	{ 0x3ace4dce, (u8*)g_key3A	, 0x5B, 0x5B },
	
	// updaters
	{ 0x0b000000, updaters_keys	, 0x4E },
	
	// locoroco, kazue, demos	
	{ 0x0c000000, demo_keys0	, 0x4F },
};


////////// Decryption 2 //////////

/* kernel modules 2.60-2.71 */
u8 keys260_0[0x10] =
{
	0xC3, 0x24, 0x89, 0xD3, 0x80, 0x87, 0xB2, 0x4E,
	0x4C, 0xD7, 0x49, 0xE4, 0x9D, 0x1D, 0x34, 0xD1
};

/* user modules 2.60-2.71 */
u8 keys260_1[0x10] =
{
	0xF3, 0xAC, 0x6E, 0x7C, 0x04, 0x0A, 0x23, 0xE7,
	0x0D, 0x33, 0xD8, 0x24, 0x73, 0x39, 0x2B, 0x4A
};

/* vshmain 2.60-2.71 */
u8 keys260_2[0x10] =
{
	0x72, 0xB4, 0x39, 0xFF, 0x34, 0x9B, 0xAE, 0x82,
	0x30, 0x34, 0x4A, 0x1D, 0xA2, 0xD8, 0xB4, 0x3C
};

/* kernel modules 2.80 */
u8 keys280_0[0x10] =
{
	0xCA, 0xFB, 0xBF, 0xC7, 0x50, 0xEA, 0xB4, 0x40,
	0x8E, 0x44, 0x5C, 0x63, 0x53, 0xCE, 0x80, 0xB1
};

/* user modules 2.80 */
u8 keys280_1[0x10] =
{
	0x40, 0x9B, 0xC6, 0x9B, 0xA9, 0xFB, 0x84, 0x7F,
	0x72, 0x21, 0xD2, 0x36, 0x96, 0x55, 0x09, 0x74
};

/* vshmain executable 2.80 */
u8 keys280_2[0x10] =
{
	0x03, 0xA7, 0xCC, 0x4A, 0x5B, 0x91, 0xC2, 0x07,
	0xFF, 0xFC, 0x26, 0x25, 0x1E, 0x42, 0x4B, 0xB5
};

/* kernel modules 3.00 */
u8 keys300_0[0x10] =
{
	0x9F, 0x67, 0x1A, 0x7A, 0x22, 0xF3, 0x59, 0x0B,
	0xAA, 0x6D, 0xA4, 0xC6, 0x8B, 0xD0, 0x03, 0x77
};

/* user modules 3.00 */
u8 keys300_1[0x10] =
{
	0x15, 0x07, 0x63, 0x26, 0xDB, 0xE2, 0x69, 0x34,
	0x56, 0x08, 0x2A, 0x93, 0x4E, 0x4B, 0x8A, 0xB2
};

/* vshmain 3.00 */
u8 keys300_2[0x10] =
{
	0x56, 0x3B, 0x69, 0xF7, 0x29, 0x88, 0x2F, 0x4C,
	0xDB, 0xD5, 0xDE, 0x80, 0xC6, 0x5C, 0xC8, 0x73
};

/* kernel modules 3.00 */
u8 keys303_0[0x10] =
{
	0x7b, 0xa1, 0xe2, 0x5a, 0x91, 0xb9, 0xd3, 0x13,
	0x77, 0x65, 0x4a, 0xb7, 0xc2, 0x8a, 0x10, 0xaf
};

/* kernel modules 3.10 */
u8 keys310_0[0x10] =
{
	0xa2, 0x41, 0xe8, 0x39, 0x66, 0x5b, 0xfa, 0xbb,
	0x1b, 0x2d, 0x6e, 0x0e, 0x33, 0xe5, 0xd7, 0x3f
};

/* user modules 3.10 */
u8 keys310_1[0x10] =
{
	0xA4, 0x60, 0x8F, 0xAB, 0xAB, 0xDE, 0xA5, 0x65,
	0x5D, 0x43, 0x3A, 0xD1, 0x5E, 0xC3, 0xFF, 0xEA
};

/* vshmain 3.10 */
u8 keys310_2[0x10] =
{
	0xE7, 0x5C, 0x85, 0x7A, 0x59, 0xB4, 0xE3, 0x1D,
	0xD0, 0x9E, 0xCE, 0xC2, 0xD6, 0xD4, 0xBD, 0x2B
};

/* reboot.bin 3.10 */
u8 keys310_3[0x10] =
{
	0x2E, 0x00, 0xF6, 0xF7, 0x52, 0xCF, 0x95, 0x5A,
	0xA1, 0x26, 0xB4, 0x84, 0x9B, 0x58, 0x76, 0x2F
};

/* kernel modules 3.30 */ 
u8 keys330_0[0x10] = 
{ 
	0x3B, 0x9B, 0x1A, 0x56, 0x21, 0x80, 0x14, 0xED,
	0x8E, 0x8B, 0x08, 0x42, 0xFA, 0x2C, 0xDC, 0x3A
};

/* user modules 3.30 */ 
u8 keys330_1[0x10] = 
{ 
	0xE8, 0xBE, 0x2F, 0x06, 0xB1, 0x05, 0x2A, 0xB9,
	0x18, 0x18, 0x03, 0xE3, 0xEB, 0x64, 0x7D, 0x26 
};

/* vshmain 3.30 */ 
u8 keys330_2[0x10] = 
{ 
	0xAB, 0x82, 0x25, 0xD7, 0x43, 0x6F, 0x6C, 0xC1,
	0x95, 0xC5, 0xF7, 0xF0, 0x63, 0x73, 0x3F, 0xE7 
};

/* reboot.bin 3.30 */ 
u8 keys330_3[0x10] = 
{ 
	0xA8, 0xB1, 0x47, 0x77, 0xDC, 0x49, 0x6A, 0x6F,
	0x38, 0x4C, 0x4D, 0x96, 0xBD, 0x49, 0xEC, 0x9B 
};

/* stdio.prx 3.30 */
u8 keys330_4[0x10] =
{
	0xEC, 0x3B, 0xD2, 0xC0, 0xFA, 0xC1, 0xEE, 0xB9,
	0x9A, 0xBC, 0xFF, 0xA3, 0x89, 0xF2, 0x60, 0x1F
};

/* 3.60 common kernel modules */
u8 keys360_0[0x10] = 
{
	0x3C, 0x2B, 0x51, 0xD4, 0x2D, 0x85, 0x47, 0xDA,
	0x2D, 0xCA, 0x18, 0xDF, 0xFE, 0x54, 0x09, 0xED
};

/* 3.60 specific slim kernel modules */
u8 keys360_1[0x10] = 
{
	0x31, 0x1F, 0x98, 0xD5, 0x7B, 0x58, 0x95, 0x45,
	0x32, 0xAB, 0x3A, 0xE3, 0x89, 0x32, 0x4B, 0x34
};

/* 3.70 common and fat kernel modules */
u8 keys370_0[0x10] = 
{
	0x26, 0x38, 0x0A, 0xAC, 0xA5, 0xD8, 0x74, 0xD1,
	0x32, 0xB7, 0x2A, 0xBF, 0x79, 0x9E, 0x6D, 0xDB
};

/* 3.70 slim specific kernel modules */
u8 keys370_1[0x10] = 
{
	0x53, 0xE7, 0xAB, 0xB9, 0xC6, 0x4A, 0x4B, 0x77,
	0x92, 0x17, 0xB5, 0x74, 0x0A, 0xDA, 0xA9, 0xEA
};

/* some 3.70 slim user modules */
u8 keys370_2[0x10] = 
{
	0x71, 0x10, 0xF0, 0xA4, 0x16, 0x14, 0xD5, 0x93,
	0x12, 0xFF, 0x74, 0x96, 0xDF, 0x1F, 0xDA, 0x89
};

/* 3.90 kernel */
u8 keys390_0[0x10] = 
{
	0x45, 0xEF, 0x5C, 0x5D, 0xED, 0x81, 0x99, 0x84,
	0x12, 0x94, 0x8F, 0xAB, 0xE8, 0x05, 0x6D, 0x7D
};

/* 3.90 slim */
u8 keys390_1[0x10] = 
{
	0x70, 0x1B, 0x08, 0x25, 0x22, 0xA1, 0x4D, 0x3B,
	0x69, 0x21, 0xF9, 0x71, 0x0A, 0xA8, 0x41, 0xA9
};

/* 5.00 kernel */
u8 keys500_0[0x10] = 
{
	0xEB, 0x1B, 0x53, 0x0B, 0x62, 0x49, 0x32, 0x58,
	0x1F, 0x83, 0x0A, 0xF4, 0x99, 0x3D, 0x75, 0xD0
};

/* 5.00 kernel 2000 specific */
u8 keys500_1[0x10] = 
{
	0xBA, 0xE2, 0xA3, 0x12, 0x07, 0xFF, 0x04, 0x1B,
	0x64, 0xA5, 0x11, 0x85, 0xF7, 0x2F, 0x99, 0x5B
};

/* 5.00 kernel 3000 specific */
u8 keys500_2[0x10] = 
{
	0x2C, 0x8E, 0xAF, 0x1D, 0xFF, 0x79, 0x73, 0x1A,
 	0xAD, 0x96, 0xAB, 0x09, 0xEA, 0x35, 0x59, 0x8B
};

/* for psp 2000 file table and ipl pre-decryption */
u8 keys02G_E[0x10] = 
{
	0x9D, 0x09, 0xFD, 0x20, 0xF3, 0x8F, 0x10, 0x69,
	0x0D, 0xB2, 0x6F, 0x00, 0xCC, 0xC5, 0x51, 0x2E
};

/* for psp 3000 file table and ipl pre-decryption */
u8 keys03G_E[0x10] = 
{
	0x4F, 0x44, 0x5C, 0x62, 0xB3, 0x53, 0xC4, 0x30,
 	0xFC, 0x3A, 0xA4, 0x5B, 0xEC, 0xFE, 0x51, 0xEA
};

/* 6.00-6.20 kernel and phat */
u8 keys620_0[0x10] = 
{
	0xD6, 0xBD, 0xCE, 0x1E, 0x12, 0xAF, 0x9A, 0xE6,
	0x69, 0x30, 0xDE, 0xDA, 0x88, 0xB8, 0xFF, 0xFB
};

/* 6.00-6.20 slim kernel */
u8 keys620_1[0x10] = 
{
	0x1D, 0x13, 0xE9, 0x50, 0x04, 0x73, 0x3D, 0xD2,
	0xE1, 0xDA, 0xB9, 0xC1, 0xE6, 0x7B, 0x25, 0xA7
};



//Tag 0x8004FD03 - 2.71 EBOOT.BIN
u8 keys271_EBOOT[0x10] = 
{
	0xF4, 0xAE, 0xF4, 0xE1, 0x86, 0xDD, 0xD2, 0x9C,
	0x7C, 0xC5, 0x42, 0xA6, 0x95, 0xA0, 0x83, 0x88
};


//Tag 0xD91605F0 - 2.8X EBOOT.BIN
u8 keys28X_EBOOT[0x10] = 
{
	0xB8, 0x8C, 0x45, 0x8B, 0xB6, 0xE7, 0x6E, 0xB8,
	0x51, 0x59, 0xA6, 0x53, 0x7C, 0x5E, 0x86, 0x31
};


//Tag 0xD91606F0 - 3.0X EBOOT.BIN
u8 keys30X_EBOOT[0x10] = 
{
	0xED, 0x10, 0xE0, 0x36, 0xC4, 0xFE, 0x83, 0xF3,
	0x75, 0x70, 0x5E, 0xF6, 0xA4, 0x40, 0x05, 0xF7
};

//Tag 0xD91608F0 - 3.1X EBOOT.BIN
u8 keys31X_EBOOT[0x10] = 
{
	0x5C, 0x77, 0x0C, 0xBB, 0xB4, 0xC2, 0x4F, 0xA2,
	0x7E, 0x3B, 0x4E, 0xB4, 0xB4, 0xC8, 0x70, 0xAF
};


//Tag 0xD91609F0 - 5.00 EBOOT.BIN
u8 keys500_EBOOT[0x10] = 
{
	0xD0, 0x36, 0x12, 0x75, 0x80, 0x56, 0x20, 0x43,
	0xC4, 0x30, 0x94, 0x3E, 0x1C, 0x75, 0xD1, 0xBF
};


//Tag 0xD9160AF0 - 5.50 EBOOT.BIN
u8 keys550_EBOOT[0x10] = 
{
	0x10, 0xA9, 0xAC, 0x16, 0xAE, 0x19, 0xC0, 0x7E,
	0x3B, 0x60, 0x77, 0x86, 0x01, 0x6F, 0xF2, 0x63
};

//Tag 0xD9160BF0 - 5.55 EBOOT.BIN
u8 keys555_EBOOT[0x10] = 
{
	0x83, 0x83, 0xF1, 0x37, 0x53, 0xD0, 0xBE, 0xFC,
	0x8D, 0xA7, 0x32, 0x52, 0x46, 0x0A, 0xC2, 0xC2
};

//Tag 0xD91611F0 - 6.00 EBOOT.BIN (which game(s) use this?)
u8 keys600_EBOOT_1[0x10] = 
{
	0x61, 0xB0, 0xC0, 0x58, 0x71, 0x57, 0xD9, 0xFA,
	0x74, 0x67, 0x0E, 0x5C, 0x7E, 0x6E, 0x95, 0xB9
};

//Tag 0xD91612F0 - 6.00 EBOOT.BIN (GTN USA - PSN edition, any others?) not decrypted!
u8 keys600_EBOOT_2[0x10] = 
{
	0x9E, 0x20, 0xE1, 0xCD, 0xD7, 0x88, 0xDE, 0xC0,
	0x31, 0x9B, 0x10, 0xAF, 0xC5, 0xB8, 0x73, 0x23
};


u8 keys_ETC_01[0x10] = 
{
	0x12, 0x99, 0x70, 0x5E, 0x24, 0x07, 0x6C, 0xD0,
	0x2D, 0x06, 0xFE, 0x7E, 0xB3, 0x0C, 0x11, 0x26
};

u8 keys_ETC_02[0x10] = 
{
	0x47, 0x05, 0xD5, 0xE3, 0x56, 0x1E, 0x81, 0x9B,
	0x09, 0x2F, 0x06, 0xDB, 0x6B, 0x12, 0x92, 0xE0
};

u8 keys_ETC_03[0x10] = 
{
	0xF6, 0x62, 0x39, 0x6E, 0x26, 0x22, 0x4D, 0xCA,
	0x02, 0x64, 0x16, 0x99, 0x7B, 0x9A, 0xE7, 0xB8
};

u8 keys_ETC_04[0x10] = 
{
	0xF9, 0x48, 0x38, 0x0C, 0x96, 0x88, 0xA7, 0x74,
	0x4F, 0x65, 0xA0, 0x54, 0xC2, 0x76, 0xD9, 0xB8
};

u8 keys_ETC_05[0x10] = 
{
	0x2D, 0x86, 0x77, 0x3A, 0x56, 0xA4, 0x4F, 0xDD,
	0x3C, 0x16, 0x71, 0x93, 0xAA, 0x8E, 0x11, 0x43
};

u8 keys_ETC_06[0x10] = 
{
	0x78, 0x1A, 0xD2, 0x87, 0x24, 0xBD, 0xA2, 0x96,
	0x18, 0x3F, 0x89, 0x36, 0x72, 0x90, 0x92, 0x85
};

u8 keys_ETC_07[0x10] = 
{
	0xC9, 0x7D, 0x3E, 0x0A, 0x54, 0x81, 0x6E, 0xC7,
	0x13, 0x74, 0x99, 0x74, 0x62, 0x18, 0xE7, 0xDD
};

u8 keys_ETC_08[0x10] = 
{
	0xC7, 0x27, 0x72, 0x85, 0xAB, 0xA7, 0xF7, 0xF0,
	0x4C, 0xC1, 0x86, 0xCC, 0xE3, 0x7F, 0x17, 0xCA
};

u8 keys_ETC_09[0x10] = 
{
	0x76, 0x40, 0x9E, 0x08, 0xDB, 0x9B, 0x3B, 0xA1,
	0x47, 0x8A, 0x96, 0x8E, 0xF3, 0xF7, 0x62, 0x92
};

u8 keys_ETC_10[0x10] = 
{
	0x23, 0xDC, 0x3B, 0xB5, 0xA9, 0x82, 0xD6, 0xEA,
	0x63, 0xA3, 0x6E, 0x2B, 0x2B, 0xE9, 0xE1, 0x54
};

u8 keys_ETC_11[0x10] = 
{
	0x22, 0x43, 0x57, 0x68, 0x2F, 0x41, 0xCE, 0x65,
	0x4C, 0xA3, 0x7C, 0xC6, 0xC4, 0xAC, 0xF3, 0x60
};

u8 keys_ETC_12[0x10] = 
{
	0x12, 0x57, 0x0D, 0x8A, 0x16, 0x6D, 0x87, 0x06,
	0x03, 0x7D, 0xC8, 0x8B, 0x62, 0xA3, 0x32, 0xA9
};

u8 keys_ETC_13[0x10] = 
{
	0x1E, 0x2E, 0x38, 0x49, 0xDA, 0xD4, 0x16, 0x08,
	0x27, 0x2E, 0xF3, 0xBC, 0x37, 0x75, 0x80, 0x93
};


u8 keys_ETC_14[0x10] = 
{
	0x7B, 0x94, 0x72, 0x27, 0x4C, 0xCC, 0x54, 0x3B,
	0xAE, 0xDF, 0x46, 0x37, 0xAC, 0x01, 0x4D, 0x87
};

u8 keys_ETC_15[0x10] = 
{
	0xAC, 0x34, 0xBA, 0xB1, 0x97, 0x8D, 0xAE, 0x6F,
	0xBA, 0xE8, 0xB1, 0xD6, 0xDF, 0xDF, 0xF1, 0xA2
};


u8 keys_ETC_16[0x10] =
{
	0x9D, 0x5C, 0x5B, 0xAF, 0x8C, 0xD8, 0x69, 0x7E,
	0x51, 0x9F, 0x70, 0x96, 0xE6, 0xD5, 0xC4, 0xE8
};


static TAG_INFO2 g_tagInfo2[] =
{
	{ 0x4C941DF0, keys620_1, 0x43 },
	{ 0x4C941CF0, keys620_0, 0x43 },
	
	{ 0x4C9419F0, keys500_1, 0x43 },
	{ 0x4C9418F0, keys500_0, 0x43 },
	{ 0x4C941FF0, keys500_2, 0x43 },
	{ 0x4C9417F0, keys500_1, 0x43 },
	{ 0x4C9416F0, keys500_0, 0x43 },
	{ 0x4C9415F0, keys390_1, 0x43 },
	{ 0x4C9414F0, keys390_0, 0x43 },
	{ 0x4C9412F0, keys370_0, 0x43 },
	{ 0x4C9413F0, keys370_1, 0x43 },
	{ 0x457B10F0, keys370_2, 0x5B },
	
	{ 0xD82310F0, keys02G_E, 0x51 },
 	{ 0xD8231EF0, keys03G_E, 0x51 },
	
	{ 0x4C940DF0, keys360_0, 0x43 },
	{ 0x4C9410F0, keys360_1, 0x43 },
	
	{ 0x4C940BF0, keys330_0, 0x43 },
	{ 0x457B0AF0, keys330_1, 0x5B },
	{ 0x38020AF0, keys330_2, 0x5A },
	{ 0x4C940AF0, keys330_3, 0x43 },
	{ 0x4C940CF0, keys330_4, 0x43 },
	
	{ 0xcfef09f0, keys310_0, 0x62 },
	{ 0x457b08f0, keys310_1, 0x5B },
	{ 0x380208F0, keys310_2, 0x5A },
	{ 0xcfef08f0, keys310_3, 0x62 },
	
	{ 0xCFEF07F0, keys303_0, 0x62 },
	{ 0xCFEF06F0, keys300_0, 0x62 },
	{ 0x457B06F0, keys300_1, 0x5B },
	{ 0x380206F0, keys300_2, 0x5A },
	
	{ 0xCFEF05F0, keys280_0, 0x62 },
	{ 0x457B05F0, keys280_1, 0x5B },
	{ 0x380205F0, keys280_2, 0x5A },
	{ 0x16D59E03, keys260_0, 0x62 },
	{ 0x76202403, keys260_1, 0x5B },
	{ 0x0F037303, keys260_2, 0x5A },
	
	{ 0x8004FD03, keys271_EBOOT		, 0x5D },
	{ 0xD91605F0, keys28X_EBOOT		, 0x5D },
	{ 0xD91606F0, keys30X_EBOOT		, 0x5D },
	{ 0xD91608F0, keys31X_EBOOT		, 0x5D },
	{ 0xD91609F0, keys500_EBOOT		, 0x5D },
	{ 0xD9160AF0, keys550_EBOOT		, 0x5D },
	{ 0xD9160BF0, keys555_EBOOT		, 0x5D },
	{ 0xD91611F0, keys600_EBOOT_1	, 0x5D },
	{ 0xD91612F0, keys600_EBOOT_2	, 0x5D },
	
	{ 0xADF305F0, keys_ETC_01, 0x60 },
	{ 0xADF306F0, keys_ETC_02, 0x60 },
	{ 0xADF308F0, keys_ETC_03, 0x60 },
	{ 0x0A35EA03, keys_ETC_04, 0x5E },
	{ 0x7B0505F0, keys_ETC_05, 0x5E },
	{ 0x7B0506F0, keys_ETC_06, 0x5E },
	{ 0x7B0508F0, keys_ETC_07, 0x5E },
	{ 0x279D08F0, keys_ETC_08, 0x61 },
	{ 0x279D06F0, keys_ETC_09, 0x61 },
	{ 0x279D05F0, keys_ETC_10, 0x61 },
	{ 0xD66DF703, keys_ETC_11, 0x61 },
	{ 0x279D10F0, keys_ETC_12, 0x61 },
	{ 0x3C2A08F0, keys_ETC_13, 0x67 },
	{ 0x457B0BF0, keys_ETC_14, 0x5B },
	{ 0x457B0CF0, keys_ETC_15, 0x5B },
	{ 0x2E5E10F0, keys_ETC_16, 0x5D },
};



////////// SignCheck //////////

u8 check_keys0[0x10] =
{
	0x71, 0xF6, 0xA8, 0x31, 0x1E, 0xE0, 0xFF, 0x1E,
	0x50, 0xBA, 0x6C, 0xD2, 0x98, 0x2D, 0xD6, 0x2D
};

u8 check_keys1[0x10] =
{
	0xAA, 0x85, 0x4D, 0xB0, 0xFF, 0xCA, 0x47, 0xEB,
	0x38, 0x7F, 0xD7, 0xE4, 0x3D, 0x62, 0xB0, 0x10
};


u8 key_C[56] = 
{
	0x07, 0x0F, 0x17, 0x1F, 0x27, 0x2F, 0x37, 0x3F, 0x06, 0x0E, 0x16, 0x1E, 0x26, 0x2E, 0x36, 0x3E,
	0x05, 0x0D, 0x15, 0x1D, 0x25, 0x2D, 0x35, 0x3D, 0x04, 0x0C, 0x14, 0x1C, 0x01, 0x09, 0x11, 0x19,
	0x21, 0x29, 0x31, 0x39, 0x02, 0x0A, 0x12, 0x1A, 0x22, 0x2A, 0x32, 0x3A, 0x03, 0x0B, 0x13, 0x1B,
	0x23, 0x2B, 0x33, 0x3B, 0x24, 0x2C, 0x34, 0x3C
};

u8 key_Z[48] = 
{
	0x32, 0x2F, 0x35, 0x28, 0x3F, 0x3B, 0x3D, 0x24, 0x31, 0x3A, 0x2B, 0x36, 0x29, 0x2D, 0x34, 0x3C,
	0x26, 0x38, 0x30, 0x39, 0x25, 0x2C, 0x33, 0x3E, 0x17, 0x0C, 0x21, 0x1B, 0x11, 0x09, 0x22, 0x18,
	0x0D, 0x13, 0x1F, 0x10, 0x14, 0x0F, 0x19, 0x08, 0x1E, 0x0B, 0x12, 0x16, 0x0E, 0x1C, 0x23, 0x20
};



u8 table_40[128] = 
{
	0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
	0x00, 0x00, 0x00, 0x20, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x40, 0x00, 0x00, 0x10, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00
};




u8 key_M[512] = 
{
	0x0D, 0x01, 0x02, 0x0F, 0x08, 0x0D, 0x04, 0x08, 0x06, 0x0A, 0x0F, 0x03, 0x0B, 0x07, 0x01, 0x04,
	0x0A, 0x0C, 0x09, 0x05, 0x03, 0x06, 0x0E, 0x0B, 0x05, 0x00, 0x00, 0x0E, 0x0C, 0x09, 0x07, 0x02,
	0x07, 0x02, 0x0B, 0x01, 0x04, 0x0E, 0x01, 0x07, 0x09, 0x04, 0x0C, 0x0A, 0x0E, 0x08, 0x02, 0x0D,
	0x00, 0x0F, 0x06, 0x0C, 0x0A, 0x09, 0x0D, 0x00, 0x0F, 0x03, 0x03, 0x05, 0x05, 0x06, 0x08, 0x0B,
	0x04, 0x0D, 0x0B, 0x00, 0x02, 0x0B, 0x0E, 0x07, 0x0F, 0x04, 0x00, 0x09, 0x08, 0x01, 0x0D, 0x0A,
	0x03, 0x0E, 0x0C, 0x03, 0x09, 0x05, 0x07, 0x0C, 0x05, 0x02, 0x0A, 0x0F, 0x06, 0x08, 0x01, 0x06,
	0x01, 0x06, 0x04, 0x0B, 0x0B, 0x0D, 0x0D, 0x08, 0x0C, 0x01, 0x03, 0x04, 0x07, 0x0A, 0x0E, 0x07,
	0x0A, 0x09, 0x0F, 0x05, 0x06, 0x00, 0x08, 0x0F, 0x00, 0x0E, 0x05, 0x02, 0x09, 0x03, 0x02, 0x0C,
	0x0C, 0x0A, 0x01, 0x0F, 0x0A, 0x04, 0x0F, 0x02, 0x09, 0x07, 0x02, 0x0C, 0x06, 0x09, 0x08, 0x05,
	0x00, 0x06, 0x0D, 0x01, 0x03, 0x0D, 0x04, 0x0E, 0x0E, 0x00, 0x07, 0x0B, 0x05, 0x03, 0x0B, 0x08,
	0x09, 0x04, 0x0E, 0x03, 0x0F, 0x02, 0x05, 0x0C, 0x02, 0x09, 0x08, 0x05, 0x0C, 0x0F, 0x03, 0x0A,
	0x07, 0x0B, 0x00, 0x0E, 0x04, 0x01, 0x0A, 0x07, 0x01, 0x06, 0x0D, 0x00, 0x0B, 0x08, 0x06, 0x0D,
	0x02, 0x0E, 0x0C, 0x0B, 0x04, 0x02, 0x01, 0x0C, 0x07, 0x04, 0x0A, 0x07, 0x0B, 0x0D, 0x06, 0x01,
	0x08, 0x05, 0x05, 0x00, 0x03, 0x0F, 0x0F, 0x0A, 0x0D, 0x03, 0x00, 0x09, 0x0E, 0x08, 0x09, 0x06,
	0x04, 0x0B, 0x02, 0x08, 0x01, 0x0C, 0x0B, 0x07, 0x0A, 0x01, 0x0D, 0x0E, 0x07, 0x02, 0x08, 0x0D,
	0x0F, 0x06, 0x09, 0x0F, 0x0C, 0x00, 0x05, 0x09, 0x06, 0x0A, 0x03, 0x04, 0x00, 0x05, 0x0E, 0x03,
	0x07, 0x0D, 0x0D, 0x08, 0x0E, 0x0B, 0x03, 0x05, 0x00, 0x06, 0x06, 0x0F, 0x09, 0x00, 0x0A, 0x03,
	0x01, 0x04, 0x02, 0x07, 0x08, 0x02, 0x05, 0x0C, 0x0B, 0x01, 0x0C, 0x0A, 0x04, 0x0E, 0x0F, 0x09,
	0x0A, 0x03, 0x06, 0x0F, 0x09, 0x00, 0x00, 0x06, 0x0C, 0x0A, 0x0B, 0x01, 0x07, 0x0D, 0x0D, 0x08,
	0x0F, 0x09, 0x01, 0x04, 0x03, 0x05, 0x0E, 0x0B, 0x05, 0x0C, 0x02, 0x07, 0x08, 0x02, 0x04, 0x0E,
	0x0A, 0x0D, 0x00, 0x07, 0x09, 0x00, 0x0E, 0x09, 0x06, 0x03, 0x03, 0x04, 0x0F, 0x06, 0x05, 0x0A,
	0x01, 0x02, 0x0D, 0x08, 0x0C, 0x05, 0x07, 0x0E, 0x0B, 0x0C, 0x04, 0x0B, 0x02, 0x0F, 0x08, 0x01,
	0x0D, 0x01, 0x06, 0x0A, 0x04, 0x0D, 0x09, 0x00, 0x08, 0x06, 0x0F, 0x09, 0x03, 0x08, 0x00, 0x07,
	0x0B, 0x04, 0x01, 0x0F, 0x02, 0x0E, 0x0C, 0x03, 0x05, 0x0B, 0x0A, 0x05, 0x0E, 0x02, 0x07, 0x0C,
	0x0F, 0x03, 0x01, 0x0D, 0x08, 0x04, 0x0E, 0x07, 0x06, 0x0F, 0x0B, 0x02, 0x03, 0x08, 0x04, 0x0E,
	0x09, 0x0C, 0x07, 0x00, 0x02, 0x01, 0x0D, 0x0A, 0x0C, 0x06, 0x00, 0x09, 0x05, 0x0B, 0x0A, 0x05,
	0x00, 0x0D, 0x0E, 0x08, 0x07, 0x0A, 0x0B, 0x01, 0x0A, 0x03, 0x04, 0x0F, 0x0D, 0x04, 0x01, 0x02,
	0x05, 0x0B, 0x08, 0x06, 0x0C, 0x07, 0x06, 0x0C, 0x09, 0x00, 0x03, 0x05, 0x02, 0x0E, 0x0F, 0x09,
	0x0E, 0x00, 0x04, 0x0F, 0x0D, 0x07, 0x01, 0x04, 0x02, 0x0E, 0x0F, 0x02, 0x0B, 0x0D, 0x08, 0x01,
	0x03, 0x0A, 0x0A, 0x06, 0x06, 0x0C, 0x0C, 0x0B, 0x05, 0x09, 0x09, 0x05, 0x00, 0x03, 0x07, 0x08,
	0x04, 0x0F, 0x01, 0x0C, 0x0E, 0x08, 0x08, 0x02, 0x0D, 0x04, 0x06, 0x09, 0x02, 0x01, 0x0B, 0x07,
	0x0F, 0x05, 0x0C, 0x0B, 0x09, 0x03, 0x07, 0x0E, 0x03, 0x0A, 0x0A, 0x00, 0x05, 0x06, 0x00, 0x0D
};


u8 key_S[8] = 
{
	0x9E, 0xA4, 0x33, 0x81, 0x86, 0x0C, 0x52, 0x85
};

u8 key_S2[8] = 
{
	0xB2, 0xFE, 0xD9, 0x79, 0x8A, 0x02, 0xB1, 0x87
};

u8 key_S3[8] = 
{
	0x81, 0x08, 0xC1, 0xF2, 0x35, 0x98, 0x69, 0xB0
};

u8 key_S4[8] =
{
	0x6D, 0x52, 0x1B, 0xA3, 0xC2, 0x36, 0xF9, 0x2B
};

u8 key_S5[8] =
{
	0xDB, 0x4E, 0x79, 0x41, 0xF5, 0x97, 0x30, 0xAD
};

TABLE_KEYS table_keys[] =
{
	{ 0xb730e5c7, 0x95620b49, key_S  },
	{ 0x45c9dc95, 0x5a7b3d9d, key_S2 },
	{ 0x6F20585A, 0x4CCE495B, key_S3 },
	{ 0x620BF15A, 0x73F45262, key_S4 },
	{ 0xFD9D4498, 0xA664C8F8, key_S5 },
};

