#include <pspsdk.h>
#include <pspkernel.h>
#include <pspdebug.h>
#include <pspctrl.h>
#include <pspsuspend.h>
#include <psppower.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
//#include <zlib.h>

#include <pspusbstor.h>
#include <pspusb.h>
#include <pspusbbus.h>

#define HOSTFSDRIVER_NAME "USBHostFSDriver"
#define HOSTFSDRIVER_PID  (0x1C9)



int UsbLoad()
{
	//if(	sceKernelFindModuleByName("USBHostFS") == NULL )
	//{
		SceUID mod = pspSdkLoadStartModule("usbhostfs.prx",PSP_MEMORY_PARTITION_KERNEL);
		//printf("usbhost load = 0x%08X\n",mod);

		if( mod < 0 ) return -1;
		/*loadStartModule("usbhostfs.prx", 0, NULL);
		hostload=1;*/
	//}

	
	if (sceUsbStart(PSP_USBBUS_DRIVERNAME, 0, 0) != 0) 
	{
		//printf("Error loading USB BUS driver.\n");
		return -1;
	}
	

	if (sceUsbStart(HOSTFSDRIVER_NAME, 0, 0) != 0) 
	{
		//printf("Error loading USB HOST driver.\n");
		return -1;
	}
	
	if( sceUsbActivate(HOSTFSDRIVER_PID) != 0 )
	{
		return -1;
	}

	sceKernelDelayThread(3000000);

	return 0;
}

void UsbUnload()
{
	sceUsbDeactivate(HOSTFSDRIVER_PID);
	sceUsbStop(HOSTFSDRIVER_NAME, 0, 0);
  	sceUsbStop(PSP_USBBUS_DRIVERNAME, 0, 0);

	sceKernelDelayThread(3000000);
	//printf("unload usb");
}



int IsEnableUsb()
{
	int ret = -1;
	int fd33 = sceIoOpen("host0:/usbhostfs.log", PSP_O_CREAT | PSP_O_RDWR, 0777);
		
	if(fd33 < 0)
	{
		ret = -1;
	}
	else
	{
		sceIoWrite(fd33, "OK", 2);
		sceIoClose(fd33);
		sceIoRemove("host0:/usbhostfs.log");

		ret = 0;
	}

	return ret;
}


