#ifndef LIB_COMPRES_H
#define LIB_COMPRES_H

#ifdef __cplusplus
extern "C" {
#endif


enum tagCompressed_Type
{
	Compressed_ERR,
	Compressed_ZIP,
	Compressed_Deflate,
	Compressed_2RLZ,
	Compressed_KL4E,
	Compressed_KL3E,
};


#define	DeflateDecompress(outbuf, outcapacity, inbuf)		Decode(outbuf, outcapacity, inbuf, Compressed_Deflate);
#define	GzipDecompress(outbuf, outcapacity, inbuf)			Decode(outbuf, outcapacity, inbuf, Compressed_ZIP);
#define	KL4EDecode(outbuf, outcapacity, inbuf)				Decode(outbuf, outcapacity, inbuf, Compressed_KL4E);
#define	KL3EDecode(outbuf, outcapacity, inbuf)				Decode(outbuf, outcapacity, inbuf, Compressed_KL3E);
#define	LZRCDecode(outbuf, outcapacity, inbuf)				Decode(outbuf, outcapacity, inbuf, Compressed_2RLZ);


int pspIsCompressed(u8 *buf);
int pspDecompress(u8 *inbuf, u8 *outbuf, u32 outcapacity);

#ifdef __cplusplus
}
#endif

#endif