/*
 *  psychlops_code_snippets.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 208/09/22 by Kenchi HOSOKAWA
 *  (C) 2008 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_CODINGSUPPORT_SNIPPETS
#define HEADER_PSYCHLOPS_CODINGSUPPORT_SNIPPETS


#include <string>
#include <sstream>


namespace Psychlops {

	std::wstring StringToWString(const std::string& s);
	std::string WStringToString(const std::wstring& s);

	namespace Utilities {
		template <class T> std::string toString( const T &t )
		{
			std::ostringstream oss;
			oss << t;
			return std::string (oss.str());
		}
		template <class T> std::wstring toStringW( const T &t )
		{
			std::string s = toString(t);
			return StringToWString(s);
		}
		template <class T> std::string to_s( const T &t )
		{
			std::ostringstream oss;
			oss << t;
			return std::string (oss.str());
		}
		template <class T> std::wstring to_sw( const T &t )
		{
			std::string s = toString(t);
			return StringToWString(s);
		}
	}

/*
	template <typename X, typename C> class READ_ONLY_ {
		friend class C;
		private:
		X val_;
		void set(X val) { val_=val; }
		public:
		READ_ONLY_() {}
		operator X() const { return val_; }
	};
*/


}	/*	<- namespace Psychlops 	*/


#endif
