/*
 *  psychlops_g_SVG.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/05/20 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_GRAPHIC_SVG
#define HEADER_PSYCHLOPS_GRAPHIC_SVG

#include <string>
#include "../../../core/graphic/psychlops_g_module.h"

namespace Psychlops {

	class SVGCanvas : public Drawable
	{
	protected:
		char buffer[512];
		Drawable* prime_backup;
		double width, height;
		std::string output;
	public:
		SVGCanvas(double width_, double height_);
		virtual ~SVGCanvas();
		virtual SVGCanvas& save(std::string filename);
		virtual int getWidth() const;
		virtual int getHeight() const;
		virtual const Point getCenter() const;

		virtual SVGCanvas& clear(const Color &col);
		virtual SVGCanvas& pix(const double x, const double y, const Color &col);


		virtual SVGCanvas& line(const Line &drawee, const Color &col);
		virtual SVGCanvas& line(const Line &drawee, const Stroke &strk);
		virtual SVGCanvas& rect(const Rectangle &drawee, const Color &col);
		virtual SVGCanvas& rect(const Rectangle &drawee, const Stroke &strk);
		virtual SVGCanvas& ellipse(const Ellipse &drawee, const Color &col);
		virtual SVGCanvas& ellipse(const Ellipse &drawee, const Stroke &strk);
		virtual SVGCanvas& polygon(const Polygon &drawee);
		virtual SVGCanvas& polygon(const Polygon &drawee, const Color &col);
		virtual SVGCanvas& polygon(const Polygon &drawee, const Stroke &strk);
		virtual SVGCanvas& polyline(const PolyLine &drawee);
		virtual SVGCanvas& polyline(const PolyLine &drawee, const Color &col);
		virtual SVGCanvas& polyline(const PolyLine &drawee, const Stroke &strk);

		virtual SVGCanvas& figures(const Group &drawee);

		virtual SVGCanvas& image(const Image &img);
		virtual SVGCanvas& image(const Image &img, const double x, const double y);
		virtual SVGCanvas& image(const Image &img, const double alpha);
		virtual SVGCanvas& letters(Letters &let, const Color &col);
	};

}	/*	<- namespace Psycholops 	*/

#endif
