/*
 *  psychlops_g_PNG_bridge.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2006/08/22 by Kenchi HOSOKAWA
 *  (C) 2006- Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#include <stdio.h>
#include <stdlib.h>
#include <opencv2/highgui/highgui.hpp>

#include "../../../core/ApplicationInterfaces/psychlops_code_exception.h"
#include "../../../core/graphic/psychlops_g_image.h"
#include "psychlops_g_OPENCV_bridge.h"


namespace Psychlops {
namespace IMAGE_FORMATS {


	OPENCV_BRIDGE::OPENCV_BRIDGE() {
	}
	OPENCV_BRIDGE::~OPENCV_BRIDGE() {
	}


	void OPENCV_BRIDGE::load(const char *file_name, Image * target) {
		std::string file(file_name);
		cv::Mat img = cv::imread(file, -1);
		target->from(img);
	}
	void OPENCV_BRIDGE::save(const char *file_name, Image * target) {
		std::string file(file_name);
		cv::Mat img;
		target->to(img);
		cv::imwrite(file, img);
	}


}
}
