/*
 *  psychlops_devices_nidaqmxbase.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/07/30 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_DEVICES_NIDAQMX
#define HEADER_PSYCHLOPS_DEVICES_NIDAQMX

#include "../../core/devices/psychlops_io_analog.h"

namespace Psychlops {

namespace Devices {

	struct NIDAQmxAPI;

	class NIDAQmx : public ITrigger {
		protected:
		NIDAQmxAPI *ain;
		NIDAQmxAPI *aout;

		public:
		NIDAQmx();
		~NIDAQmx();
		void open(const char* devname = "Dev1/ai0");
		void open(double rate, const char* devname = "Dev1/ai0");

		virtual double getSamplingRate();
		virtual void setSamplingRate(double sample_per_sec);
		virtual double getLatency();
		virtual double getJitterSD();
		virtual Interval getRange();
		virtual bool isAnalog();

		virtual double get();
		virtual int get(double* buf, int length, double timeout_second);
		virtual void put(double);
		virtual void trigger();
		virtual void pulse(double);
		virtual void keep(double);
	};

	class AnalogInput_NIDAQmx : public AnalogInput {
		protected:
		NIDAQmxAPI *api;

		public:
		AnalogInput_NIDAQmx(const char* devname = "Dev1/ai0");
		AnalogInput_NIDAQmx(double rate, const char* devname = "Dev1/ai0");
		virtual ~AnalogInput_NIDAQmx();
		virtual double get();
		virtual int get(double* buf, int length, double timeout_second);
		virtual void samplingRate(double sample_per_sec);


		virtual double samplingRate();
		virtual double getSamplingRate();
		virtual double getLatency();
		virtual double getJitterSD();
		virtual Interval getRange();
		virtual bool isAnalog();
		virtual void put(double);
		virtual void pulse(double);
		virtual void keep(double);
	};

	class AnalogOutput_NIDAQmx : public ITrigger, public AnalogOutput {
		protected:
		NIDAQmxAPI *api;

		public:
		AnalogOutput_NIDAQmx(const char* devname = "Dev1/ao0");
		virtual ~AnalogOutput_NIDAQmx();
		virtual void put(double);
		static void setVoltage(double val, const char* devname = "Dev1/ao0");
		virtual void trigger();
		virtual void pulse(double);
		virtual void keep(double);


		virtual double getLatency();
		virtual double getJitterSD();
		virtual Interval getRange();
		virtual bool isAnalog();
		virtual double get();
	};

}

}	/*	<- namespace Psycholops 	*/



#endif
