/*
 *  psychlops_devices_nidaqmxbase.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/07/30 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_DEVICES_PARALLELPORT
#define HEADER_PSYCHLOPS_DEVICES_PARALLELPORT

#include "../../core/devices/psychlops_io_analog.h"

namespace Psychlops {

namespace Devices {


	class GenericParallelPort : public ITrigger
	{
		public:
		enum PIN { D0=1, D1=2, D2=4, D3=8, D4=16, D5=32, D6=64, D7=-128 };

		private:
		char pins;
		void * handle;

		public:
		GenericParallelPort(std::string port_name, size_t pin);
		virtual ~GenericParallelPort();

		virtual void trigger();
		void trigger(int length);
		void trigger(const char *data, size_t length);
		void trigger(std::string data);
	};

}

}	/*	<- namespace Psycholops 	*/



#endif
