#include <psychlops.h>
using namespace Psychlops;

Psychlops::Polygon Poly;

int radius = 100;
int v_n = 6;
double bg_lum =0.0;
double Poly_lum = 0.5;

void StimDisplay()
{

    Range rng;
    Independent << Poly_lum | "Poly lum" | 0 <= rng <= 1.0 | 0.05 | 0.1;

    for(int i=0; i<v_n; i++)
    {
        double angle = (double)i/v_n * 2*PI;
        Poly.append(radius*cos(angle), radius*sin(angle));
    }
    Poly.Shape::centering();

    while(!Keyboard::esc.pushed()){
        Display::clear(bg_lum);
        Poly.draw(Poly_lum);
        Display::flip();
    }
}

void psychlops_main()
{
    Canvas canvas(Canvas::window, Display::secondary);
    canvas.showFPS();
    canvas.watchFPS();

    Procedure p;
    p.setDesign(Procedure::DEMO);
    p.setProcedure(&StimDisplay);
    p.run();
}


#if 0

// Motion with glass patterns.
// Ross, J., Badcock, D. R., and Hayes, A. (2000)
// Coherent global motion in the absence of coherent velocity signals.
// Current Biology, 10, 679-682.
///+ Prefix
//// Include Psychlops Package
#include <psychlops.h>
using namespace Psychlops;    // Initially developed with Psychlops Win32 1.5.3 / 20110311
///- Prefix

///+ Stimulus drawing function
//// A function for stimulus drawing (main body)


void psychlops_main() {
	Canvas cnvs(Canvas::window);

	Letters let(L"flower_png24.png");
	let.fill = Color::white;

	Psychlops::Ellipse rect(100,100);
	rect.fill = Color::red;

	char data[100] = {
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,
		-128,-128,-128,-128,-128,-128,-128,-128,
		-128,-128,-128,-128,-128,-128,-128,-128,
		-128,-128,-128,-128,-128,-128,-128,-128,
		-128,-128,-128,-128,-128,-128,-128,-128,
	};
	Devices::GenericParallelPort trigger0("USB_PARALLEL", 0);
	Devices::GenericParallelPort trigger1("USB_PARALLEL", Devices::GenericParallelPort::D0 + Devices::GenericParallelPort::D2);

	trigger0.trigger();
	trigger1.trigger();


	int trigger_ticks = 100, a;
	Interval rng;
	Widgets::Slider slide;
	slide.link(trigger_ticks, "trigger_ticks", 1<=rng<=1000, 20.0, 100.0);

	int t=0;

	while(!Keyboard::esc.pushed()) {
		t++;
		if(t%2==0) Display::clear(); //Clear window
		else  Display::clear(Color::gray); //Clear window

		//if(t%100 == 0)
		//	rs = CreateProcess("C:\\Windows\\System32\\print.exe",(LPTSTR)" /D:LPT1 D:\\Users\\hskwk\\Desktop\\zzz.txt",NULL,NULL,FALSE,NORMAL_PRIORITY_CLASS,NULL,NULL,&si,&pi);

		//if(t%300==0) trigger1.trigger(data,100);
		if(t%150==0) trigger0.trigger(trigger_ticks);
		rect.draw();

		slide.draw();

		Display::flip(); // Flip frame buffers
	}
}
///- Stimulus drawing function

#endif


#if 0

// Motion with glass patterns.
// Ross, J., Badcock, D. R., and Hayes, A. (2000)
// Coherent global motion in the absence of coherent velocity signals.
// Current Biology, 10, 679-682.
///+ Prefix
//// Include Psychlops Package
#include <psychlops.h>
using namespace Psychlops;    // Initially developed with Psychlops Win32 1.5.3 / 20110311
///- Prefix

///+ Stimulus drawing function
//// A function for stimulus drawing (main body)
void psychlops_main() {

	Canvas cnvs(Canvas::window);

	Letters let(L"flower_png24.png");
	let.fill = Color::white;

	Psychlops::Ellipse rect(100,100);
	rect.fill = Color::red;

	while(!Keyboard::esc.pushed()) {
		Display::clear(); //Clear window

		rect.centering();
		std::cout << rect.getDatum().x << std::endl;
		rect.shift(100,100).draw();
		std::cout << rect.getDatum().x << std::endl << std::endl;
		let.centering();
		let.shift(100,100).draw();
		std::cout << let.getDatum().x << std::endl;

		Display::flip(); // Flip frame buffers
	}

	//Figures::Movie mov;
	//mov.bin_path = "C:\\";
}
///- Stimulus drawing function



#include <psychlops.h>
using namespace Psychlops;


Clock before, after;
void memoBefore() { before.update(); }
double pastTime() { after.update(); return (after-before).at_msec(); }


void psychlops_main() {


	Display target_display = Display::secondary;
	std::cout << target_display.width << std::endl;
	std::cout << Display::secondary.getHeight() << std::endl;


	Canvas display(1024, 768, Canvas::window, target_display);
	Range rng;
/*
	Mouse::show();
	Color::setGammaValue(1.0,1.0,1.0);

	double cutoff1=1.0,cutoff2=0.0;
	Widgets::Slider slider[3];
	slider[0].link(cutoff1, "cutoff1"  , 0<=rng<=256, 1);
	slider[1].link(cutoff2, "half width"  , 0<=rng<=1, 0.125);
*/

/*
	//void drawGrating(Image &img, int width, int height, double wavelength, double contrast, double orientation, double phase);
	//void drawGaussian(Image &img, double sigma, double factor);
	//void drawGabor(Image &img, double sigma, double wavelength, double contrast, double orientation, double phase);
	std::stringstream ss;
	Image img;
	for(double wavelength_=2; wavelength_<8; wavelength_+=1.0 )
	{
		for(double ori = 0; ori<180.0; ori+=30)
		{
			for(double amp = 0.25; amp<=1; amp+=0.25)
			{
				for(double phase = 0; phase<360.0; phase+=30)
				{
					Figures::drawGrating(img, 36, 36, pow(2,wavelength_), amp, ori/360*2*PI, phase/360*2*PI);
					ss.str("");
					ss << "output/Grating_wav" << pow(2,wavelength_) << "_amp" << amp << "_ori" << ori << "_pha" << phase << ".png";
					img.save(ss.str());
					//Figures::drawGrating(img, 45, 45, pow(2,wavelength_), amp, ori/360*2*PI, phase/360*2*PI);
				}
			}
		}
	}
*/

/*
	while(!Keyboard::esc.pushed()) {

		memoBefore();
		std::cout << pastTime() << std::endl;


		memoBefore();
*/

	Figures::Movie m;
	m.source.set(100,100).centering();

		//while(!Keyboard::esc.pushed()) {
		for(int j=0; j<10; j++) {
			display.clear(Color::blue);


			//img.centering().draw();
			for(int i=0; i<2; i++)
			{
				//slider[i].setDatum(Point(0,0)).shift(20, i*25 + 10).draw();
			}
			m.capture();
			//display.to(m[j], r);
			display.flip();
		}
		m.save("test.gif");
	//	std::cout << pastTime() << std::endl;
	//}* /
}
#endif
