 #include <psychlops.h>
 using namespace Psychlops;


void psychlops_main() {
	Canvas cnvs(1024, 768, Canvas::window);

	FFT1 fftworkspace;
	Matrix source_mat, filtered_mat, mat;
	source_mat.load("voltage_spec_vaio_ie.csv");
	source_mat.transpose();

	//fftworkspace.set(64,64);
	//fftworkspace.makeNoise();
	fftworkspace.set(source_mat);
	fftworkspace.fft();
	fftworkspace.getSpectrum(filtered_mat, 1.0);

	int q = filtered_mat.getCols() / 4;
	Interval col;
	mat = filtered_mat(1, q*2+3<=col<=q*3);
	mat.transpose();
	mat.save("voltage_spec.csv");

	double mean = 0.0;
	for(int i=0; i<source_mat.getCols(); i++) {
		mean += source_mat(1, i+1);
	}
	mean /= source_mat.getCols();
	int counter = 0;
	for(int i=1; i<source_mat.getCols()-3; i++) {
		if(    source_mat(1, i+1)<mean
			&& source_mat(1, i+2)<mean
			&& source_mat(1, i+3)>mean
			&& source_mat(1, i+4)>mean
		) { counter++; }
	}
	std::cout << counter << std::endl;
}


/*
const int S = 128;

 void psychlops_main() {
	Canvas cnvs(1024, 768, Canvas::window);

	Image source("test.png");
	Image result;

	Image img[5];
	//for(int i=0; i<1000; i++){
		FFT2 fftworkspace;
		Matrix source_mat(S,S), filtered_mat, filter;
		for(int x=1; x<=S; x++)
			for(int y=1; y<=S; y++)
				source_mat(x,y) = random(0.0,1.0);
		//source_mat=FFT2::makeNoise(64, 64);
		filter=FFT2::makeFilter(S, S, 8, 12);

		//fftworkspace.set(64,64);
		//fftworkspace.makeNoise();
		fftworkspace.set(source_mat);
		fftworkspace.fft();
		fftworkspace.filtering(filter);
		fftworkspace.ifft();
		fftworkspace.getImage(filtered_mat);

		img[0].from(source_mat);
		img[1].from(filter);
		img[2].from(filtered_mat);

	while(!Keyboard::esc.pushed())
	{
		cnvs.clear(0.5);
		for(int i=0; i<5; i++) img[i].centering().shift(-400,0).shift((S+1)*i,0).draw();
		cnvs.var(Mouse::x, 100, 80);
		cnvs.var(Mouse::y, 100, 100);
		cnvs.flip();
	}

 }

*/
