#include <psychlops.h>
using namespace Psychlops;

void psychlops_main() {
	Canvas cnvs(Canvas::window);

	Font font(L"MS P Gothic", 32);
	Letters let(L"hoge", font);
	let._zoom_cache = true;

	Clock after, before;
	after.update();

	while(!Keyboard::esc.pushed()) {
        before = after;
        after.update();

        cnvs.clear();

        font.size = random(100);
        //let.setFont(font);
        let.font = font;
        let.centering().draw(Color::white);

        cnvs.var((after-before).at_msec(), 100,100, Color::green);

        cnvs.flip();
	}
}

/*
#include <psychlops.h>
using namespace Psychlops;


class RectLuminance : public ExperimentalMethods::Demo {
	Canvas display;
	double bg_lum, x;
//	Widgets::SequentialScreenshot sc;
	Gabor *gabor;
	Psychlops::Rectangle rect;
	FigureGroupe g;
	Figures::Cross xr;
	Figures::Arrow arr;

	void initialize() {
		display.set(Canvas::window);
		gabor = new QuickGabor(10.0, 10.0, 1.0);
		g.add(rect);
		rect.set(100, 100).centering(0,0);
		xr.set(100,100).shift(200,200);
		xr.brush = Stroke(Color::red, 2, Stroke::SOLID);
		g.shift(100,0);
		g.rotation = -5;
		arr.centering();
		arr.vec = Psychlops::Point(100,50);

		Interval itv;
		Independent << bg_lum    | "BG Luminance"   | 0.0<=itv<=4095 |  128 | 1 , 1;
		Independent << x         | "X"              | 0.0<=itv<=4095 |  128 | 1 , 1;
	}

	void trial() {
		Letters let(L"hoge");
		while(!Input::get(Keyboard::esc)) {
			display.clear(Color(bg_lum/4095));
			(*gabor).centering().draw();
			let.centering();
			let.draw(Color::red);
			g.draw(Color::red);
			arr.vec.x -= 1;
			arr.draw(Color::white);
			if(Mouse::left.pressed()) display.var(Mouse::x, 100,100);

			display.flip();
		}
	}

};


void psychlops_main() {
	RectLuminance * exp = new RectLuminance;
	exp->run();
	delete exp;
}
*/



/*
#include <psychlops.h>
using namespace Psychlops;


const int DIVISION_MODES = 5;
const int MIN_DIVISION_MODES = 5;
const double SIGMA_MAGN = 6.0;

void GaborChart() {

	Canvas display(Canvas::window);
	int div = 5, divarr;

	double size_whole= 400.0, wl = 30.0;
	double contrast = 0.5, ori = 0.0, velocity = 15.0;
	int velmode = 1;

	Range rng;
	Independent << div      | "Division"      |      5<=rng<=9     |  1   | 1   ;
	Independent << wl       | "Wavelength"    |   30.0<=rng<=60.0  |  5.0 | 1.0 ;
	Independent << contrast | "Contrast"      |      0<=rng<=1.0   |  0.1 | 0.01;
	Independent << velocity | "Velocity"      |  -90.0<=rng<=90.0  | 15.0 | 1.0 ;
	Independent << velmode  | "Velocity Mode" |      0<=rng<=1     |  1   | 1   ;
	Independent << ori      | "Orientation"   | -360.0<=rng<=720.0 | 30.0 | 15.0;
	double each_size;

	//Formatting and (re)locating Gabors
	QuickGabor gabor[DIVISION_MODES][DIVISION_MODES+MIN_DIVISION_MODES][DIVISION_MODES+MIN_DIVISION_MODES];
	for(int divs=0, divs_really=0; divs<DIVISION_MODES; divs++) {
		divs_really = MIN_DIVISION_MODES+divs;
		for(int x=0; x<DIVISION_MODES+MIN_DIVISION_MODES; x++) {
			for(int y=0; y<DIVISION_MODES+MIN_DIVISION_MODES; y++) {
				each_size = size_whole/divs_really;
				gabor[divs][x][y].set((wl/(divs_really-y+1)), each_size/SIGMA_MAGN).centering().shift(each_size*((x+0.5)-(divs_really/2.0)), each_size*(divs_really/2.0-(y+0.5)));
				gabor[divs][x][y].phase = Psychlops::random(360);
			}
		}
	}

	//Run Movie
	display.showFPS();
	display.watchFPS();
	while(!Input::get(Keyboard::esc)) {
		Display::clear(Color::gray);
		divarr = div-MIN_DIVISION_MODES;

		for(int x=0; x<div; x++) {
			for(int y=0; y<div; y++) {
				if(ori>360.0) ori -=360.0; if(ori<0.0) ori+=360.0;

				//Set Gabor parameters
				gabor[divarr][x][y].wavelength  = wl / pow(4.0/3.0, y);
				gabor[divarr][x][y].contrast    = contrast;
				gabor[divarr][x][y].orientation = ori;
				if(velmode) {
					gabor[divarr][x][y].phase += velocity * (1.0*x/div);
				} else {
					gabor[divarr][x][y].phase += velocity / gabor[divarr][x][y].wavelength * (1.0*x/div) * 20;
				}

				//Drawing Gabors
				gabor[divarr][x][y].draw();
			}
		}

		Display::flip();
	}

}

void psychlops_main()
{
	Procedure p;
	p.setDesign(Procedure::DEMO);
	p.setProcedure(&GaborChart);
	p.run();
}
*/

/*
#include <psychlops.h>
using namespace Psychlops;	// Initially developed with Psychlops Win32 1.0.2 / 20080414



void RectLuminance() {
	Canvas display(1024, 768, Canvas::window, Display::secondary);
	display.showFPS();
	display.watchFPS();

	double rect_size = 100;
	double rect_lum  = 0.5;
	double bg_lum    = 0.2;

	Psychlops::Rectangle rect(rect_size,rect_size);
	rect.centering();

	Range rng;
	Independent << rect_size | "Rect Size"      |   1< rng< 500 | 10.0 | 2.0 ;
	Independent << rect_lum  | "Rect Luminance" | 0.0<=rng<=1.0 |  0.1 | 0.05;
	Independent << bg_lum    | "BG Luminance"   | 0.0<=rng<=1.0 |  0.1 | 0.05;
	Psychlops::Rectangle drawee(100,100);

	Clock before, after;
	while(!Input::get(Keyboard::esc)) {
		Display::clear(bg_lum);
		rect.resize(rect_size,rect_size).draw(rect_lum);
		after.update();
		display.var((after-before).at_msec(), 100,100, Color::green);
		if(Independent[&rect_lum].changed()) display.var((after-before).at_msec(), 100,200, Color::green);
		drawee.centering().shift(Psychlops::random(100),0).draw(Color::black);
		Display::flip();
	}

}


void psychlops_main() {
	Procedure p;
	p.setDesign(Procedure::DEMO);
	p.setProcedure(RectLuminance);
	p.run();

}
*/
