/// <summary>Amplitude of Grating</summary>
/// <minValue>0</minValue>
/// <maxValue>1</maxValue>
/// <defaultValue>1</defaultValue>
float contrast : register(C1);

/// <summary>Phase of Grating</summary>
/// <minValue>0</minValue>
/// <maxValue>100</maxValue>
/// <defaultValue>100</defaultValue>
float frequency: register(C2);

/// <summary>Phase of Grating</summary>
/// <minValue>0</minValue>
/// <maxValue>6.283184</maxValue>
/// <defaultValue>0</defaultValue>
float phase: register(C3);

/// <summary>Orientation of Grating</summary>
/// <minValue>0</minValue>
/// <maxValue>6.283184</maxValue>
/// <defaultValue>0</defaultValue>
float orientation: register(C4);

/// <summary>Half bandwidth of envelope</summary>
/// <minValue>2</minValue>
/// <maxValue>8</maxValue>
/// <defaultValue>4</defaultValue>
float sigma : register(C5);

/// <summary>Transparency of Figure</summary>
/// <minValue>0</minValue>
/// <maxValue>1</maxValue>
/// <defaultValue>1</defaultValue>
float alpha : register(C6);


float rp(float2 uv)
{
	const float2 Center = float2(0.5,0.5);
	float2 dir = uv - Center; // vector from center to pixel
	float dist = length(dir);
	//dir /= dist;
	return dist;
}

float4 main(float2 uv : TEXCOORD) : COLOR
//float4 main(float2 uv : VPOS ) : COLOR
{
	//float _r = rp(uv)*sigma*4.0;
	//float env = exp( -(_r*_r) / 2.0 ) * alpha;
	float _r = rp(uv)*8;
	float env = exp( -(_r*_r) / (2.0) ) * alpha;

	float _x = sin(orientation)*uv[0]-cos(orientation)*uv[1];
	float l = 0.5+contrast*0.5*cos(frequency*_x + phase);
	
	float4 color = float4(l,l,l,1.0);
	return color;
}
