﻿using System;
using System.Windows;


namespace Psychlops
{
	public static class StaticFunctions
	{
		public static T[] NewArray<T>(int x)
			where T : new()
		{
			T[] t = new T[x];
			for (int i = 0; i < x; i++)
			{
				t[i] = new T();
			}
			return t;
		}
		public static T[,] NewArray<T>(int x, int y)
			where T : new()
		{
			T[,] t = new T[x,y];
			for (int i = 0; i < x; i++)
			{
				for (int j = 0; j < x; j++)
				{
					t[i,j] = new T();
				}
			}
			return t;
		}
		public static T[,,] NewArray<T>(int x, int y, int z)
			where T : new()
		{
			T[,,] t = new T[x, y, z];
			for (int i = 0; i < x; i++)
			{
				for (int j = 0; j < y; j++)
				{
					for (int k = 0; k < z; k++)
					{
						t[i, j, k] = new T();
					}
				}
			}
			return t;
		}
	}

	public partial struct Point
	{
		public double x, y, z;
		public Point(double dx, double dy, double dz = 0.0)
		{
			x = dx;
			y = dy;
			z = dz;
		}
		public Point set(double dx, double dy, double dz = 0.0)
		{
			x = dx;
			y = dy;
			z = dz;
			return this;
		}

		public static Point operator +(Point lhs, Point rhs)
		{
			return new Point(lhs.x + rhs.x, lhs.y + rhs.y, lhs.z + rhs.z);
		}
		public static Point operator -(Point lhs, Point rhs)
		{
			return new Point(lhs.x - rhs.x, lhs.y - rhs.y, lhs.z - rhs.z);
		}
		public override string ToString()
		{
			return "X:"+ x.ToString() + " Y:"+ y.ToString() + " Z:"+ z.ToString();
		}
	}


	public partial struct Color
	{
		public double r, g, b, a;
		public Color(double lum)
		{
			r = g = b = lum;
			a = 1.0;
		}
		public Color(double red, double green, double blue, double alpha = 1.0)
		{
			r = red;
			g = green;
			b = blue;
			a = alpha;
		}
		public void set(double lum)
		{
			r = g = b = lum;
			a = 1.0;
		}
		public void set(double red, double green, double blue, double alpha = 1.0)
		{
			r = red;
			g = green;
			b = blue;
			a = alpha;
		}

		public override string ToString()
		{
			return "R:" + r.ToString() + " G:" + g.ToString() + " B:" + b.ToString() + " A:" + a.ToString();
		}

		public static readonly Color
			black = new Color(0, 0, 0, 1),
			red = new Color(1, 0, 0, 1),
			green = new Color(0, 1, 0, 1),
			blue = new Color(0, 0, 1, 1),
			yellow = new Color(1, 1, 0, 1),
			magenta = new Color(1, 0, 1, 1),
			cyan = new Color(0, 1, 1, 1),
			gray = new Color(.5, .5, .5, 1),
			white = new Color(1, 1, 1, 1),
			null_color = new Color(0, 0, 0, 0),
			transparent = new Color(0, 0, 0, 0);

	}


	public interface Drawable
	{
		Point getCenter();
		void clear(Color col);
		void pix(int x, int y, Color col);
		void line(Line drawee);
		void rect(Rectangle drawee);
		void ellipse(Ellipse drawee);
		void polygon(Polygon drawee);
		void letters(Letters drawee);
		void image(Image drawee);
		void group(Group drawee);
		void msg(string s, double x, double y, Color c);
	}



	public interface Figure
	{
		Point datum { get; set; }
		Figure shift(Point p);
		Figure centering(Point p);
		void draw();
	}
	public static class FigureExtention
	{
		public static Point getDatum(this Figure target)
		{
			return target.datum;
		}
		public static Point setDatum(this Figure target, Point p)
		{
			target.datum = p;
			return target.datum;
		}
		public static Figure shift(this Figure target, double x, double y, double z = 0.0)
		{
			return target.shift(new Point(x, y, z));
		}
		public static Figure centering(this Figure target)
		{
			return target.centering(Main.drawable.getCenter());
		}
		public static Figure centering(this Figure target, double x, double y, double z = 0.0)
		{
			return target.centering(new Point(x, y, z));
		}
	}

	namespace Internal
	{
		public interface PrimitiveFigure : Figure
		{
			UIElement toNative();
			UIElement poolNative(Canvas c);
		}
	}

	public partial class Group : Internal.PrimitiveFigure
	{
		System.Collections.Generic.List<Figure> list;
		System.Windows.Controls.Canvas cnvs;
		System.Windows.Media.TransformGroup trans;
		System.Windows.Media.TransformCollection transF;
		System.Windows.Media.RotateTransform rotateF;
		SimpleProcedure setRotation_;
		System.Windows.Media.ScaleTransform scaleF;
		SimpleProcedure setScaling_;
		System.Windows.Media.TranslateTransform translateF;

		bool AsyncBool;
		double rotation_;
		public double rotation
		{
			get { return rotation_; }
			set { rotation_ = value; rotateF.Dispatcher.BeginInvoke(setRotation_); }
		}		
		public Point axis
		{
			get;
			set;
		}
		Point scaling_;
		public Point scaling
		{
			get { return scaling_; }
			set { scaling_ = value; scaleF.Dispatcher.BeginInvoke(setScaling_); }
		}

		AppendFunc1 append_;

		public Group()
		{
			setRotation_ = new SimpleProcedure(setRotation__);
			setScaling_ = new SimpleProcedure(setScaling__);
			append_ = new AppendFunc1(append__);
			list = new System.Collections.Generic.List<Figure>();
			AsyncBool = false;
			initialize__();
			while (!AsyncBool) { }
		}

		public Group append(Internal.PrimitiveFigure fig)
		{
			list.Add(fig);
			cnvs.Dispatcher.BeginInvoke(append_, fig);
			return this;
		}

		public Point datum { get; set; }
		public Figure shift(Point p)
		{
			datum = datum + p;
			return this;
		}
		public Figure centering(Point p)
		{
			datum = p;
			return this;
		}
		public void draw()
		{
			Main.drawable.group(this);
		}
	}

}