﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;


namespace Psychlops
{
	public class HID
	{
		public struct Button
		{
			private static object locker;
			static Button()
			{
				locker = new object(); 
			}
			private bool pushed_, released_, pressed_;
			public void down()
			{
				lock (locker)
				{
					pushed_ = true;
					pressed_ = true;
				}
			}
			public void up()
			{
				lock (locker)
				{
					released_ = true;
					pressed_ = false;
				}
			}
			public bool pushed() { lock (locker) { bool tmp = pushed_; pushed_ = false; return tmp; } }
			public bool released() { lock (locker) { bool tmp = released_; released_ = false; return tmp; } }
			public bool pressed() { return pressed_; }
		}
	}


	public static class Mouse
	{
		static internal Point position_;
		static internal System.Windows.UIElement _prime;
		static public HID.Button left, right, middle;
		static internal Point wheelDelta_;

		static public Point position { get { return position_; } }
		static public int x { get { return (int)position_.x; } }
		static public int y { get { return (int)position_.y; } }
		static public Point wheelDelta { get { return wheelDelta_; } }

		static public void show() { }
		static public void hide() { }

		static public void Canvas_MousePos(object sender, MouseEventArgs e)
		{
			System.Windows.Point p = e.GetPosition(_prime);
			position_.set(p.X, p.Y);
		}
		static public void Canvas_LDown(object sender, MouseEventArgs e)
		{
			left.down();
			System.Windows.Point p = e.GetPosition(_prime);
			position_.set(p.X, p.Y);
		}
		static public void Canvas_LUp(object sender, MouseEventArgs e)
		{
			left.up();
			System.Windows.Point p = e.GetPosition(_prime);
			position_.set(p.X, p.Y);
		}
		static public void Canvas_MouseWheel(object sender, MouseWheelEventArgs e)
		{
			wheelDelta_.y += e.Delta;
			System.Windows.Point p = e.GetPosition(_prime);
			position_.set(p.X, p.Y);
		}
	}


	public static class Keyboard
	{
		public class IKey
		{
			//internal static HID.Button[] states;
			//int p;
			internal HID.Button state;
			public void down() { state.down(); }
			public void up() { state.up(); }
			public bool pushed() { return state.pushed(); }
			public bool released() { return state.released(); }
			public bool pressed() { return state.pressed(); }
		}
		static public IKey
			alt, shift, ctrl,
			esc, spc, rtn,
			left, right, up, down,
			tab,
			comma, period,
			q, w, e, r, t, y, u, i, o, p,
			a, s, d, f, g, h, j, k, l,
			z, x, c, v, b, n, m,
			one, two, three, four, five, six, seven, eight, nine, zero,
			pad0, pad1, pad2, pad3, pad4, pad5, pad6, pad7, pad8, pad9;
		static private System.Collections.Generic.Dictionary<System.Windows.Input.Key, IKey> map;
		static public void Canvas_KeyUp(object sender, KeyEventArgs e)
		{
			if (map.ContainsKey(e.Key)) map[e.Key].up();
		}
		static public void Canvas_KeyDown(object sender, KeyEventArgs e)
		{
			if (map.ContainsKey(e.Key)) map[e.Key].down();
		}


		static Keyboard()
		{
			/*
			esc = new Key(0); spc = new Key(1); rtn = new Key(2);
			left = new Key(3); right = new Key(4); up = new Key(5); down = new Key(6);
			comma = new Key(7); period = new Key(8);
			q = new Key(32); w = new Key(33); e = new Key(34); r = new Key(35); t = new Key(36); y = new Key(37); u = new Key(38); i = new Key(39); o = new Key(40); p = new Key(41);
			a = new Key(42); s = new Key(43); d = new Key(44); f = new Key(45); g = new Key(46); h = new Key(47); j = new Key(48); k = new Key(49); l = new Key(50);
			z = new Key(51); x = new Key(52); c = new Key(53); v = new Key(54); b = new Key(55); n = new Key(56); m = new Key(57);
			one = new Key(80); two = new Key(81); three = new Key(82); four = new Key(83); five = new Key(84); six = new Key(85); seven = new Key(86); eight = new Key(87); nine = new Key(88); zero = new Key(96);
			pad0 = new Key(96); pad1 = new Key(97); pad2 = new Key(98); pad3 = new Key(99); pad4 = new Key(100); pad5 = new Key(101); pad6 = new Key(102); pad7 = new Key(103); pad8 = new Key(104); pad9 = new Key(105);
			*/
			alt = new IKey(); shift = new IKey(); ctrl = new IKey();
			esc = new IKey(); spc = new IKey(); rtn = new IKey();
			left = new IKey(); right = new IKey(); up = new IKey(); down = new IKey();
			comma = new IKey(); period = new IKey();
			q = new IKey(); w = new IKey(); e = new IKey(); r = new IKey(); t = new IKey(); y = new IKey(); u = new IKey(); i = new IKey(); o = new IKey(); p = new IKey();
			a = new IKey(); s = new IKey(); d = new IKey(); f = new IKey(); g = new IKey(); h = new IKey(); j = new IKey(); k = new IKey(); l = new IKey();
			z = new IKey(); x = new IKey(); c = new IKey(); v = new IKey(); b = new IKey(); n = new IKey(); m = new IKey();
			one = new IKey(); two = new IKey(); three = new IKey(); four = new IKey(); five = new IKey(); six = new IKey(); seven = new IKey(); eight = new IKey(); nine = new IKey(); zero = new IKey();
			pad0 = new IKey(); pad1 = new IKey(); pad2 = new IKey(); pad3 = new IKey(); pad4 = new IKey(); pad5 = new IKey(); pad6 = new IKey(); pad7 = new IKey(); pad8 = new IKey(); pad9 = new IKey();

			map = new System.Collections.Generic.Dictionary<System.Windows.Input.Key, IKey>();
			map.Add(Key.Alt, alt); map.Add(Key.Shift, shift); map.Add(Key.Ctrl, ctrl);
			map.Add(Key.Escape, esc); map.Add(Key.Space, spc); map.Add(Key.Enter, rtn);
			map.Add(Key.Left, left); map.Add(Key.Right, right); map.Add(Key.Up, up); map.Add(Key.Down, down);
			map.Add(Key.Tab, tab);
			map.Add(Key.PageDown, comma); map.Add(Key.PageUp, period);
			map.Add(Key.Q, q); map.Add(Key.W, w); map.Add(Key.E, e); map.Add(Key.R, r); map.Add(Key.T, t); map.Add(Key.Y, y); map.Add(Key.U, u); map.Add(Key.I, i); map.Add(Key.O, o); map.Add(Key.P, p);
			map.Add(Key.A, a); map.Add(Key.S, s); map.Add(Key.D, d); map.Add(Key.F, f); map.Add(Key.G, g); map.Add(Key.H, h); map.Add(Key.J, j); map.Add(Key.K, k); map.Add(Key.L, l);
			map.Add(Key.Z, z); map.Add(Key.X, x); map.Add(Key.C, c); map.Add(Key.V, v); map.Add(Key.B, b); map.Add(Key.N, n); map.Add(Key.M, m);
			map.Add(Key.D1, one); map.Add(Key.D2, two); map.Add(Key.D3, three); map.Add(Key.D4, four); map.Add(Key.D5, five); map.Add(Key.D6, six); map.Add(Key.D7, seven); map.Add(Key.D8, eight); map.Add(Key.D9, nine); map.Add(Key.D0, zero);
			map.Add(Key.NumPad0, pad0); map.Add(Key.NumPad1, pad1); map.Add(Key.NumPad2, pad2); map.Add(Key.NumPad3, pad3); map.Add(Key.NumPad4, pad4); map.Add(Key.NumPad5, pad5); map.Add(Key.NumPad6, pad6); map.Add(Key.NumPad7, pad7); map.Add(Key.NumPad8, pad8); map.Add(Key.NumPad9, pad9);
		}
	}

}