/*
 *  psychlops_widgets_Win32GL.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/12/14 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */


#include <windows.h>
#include "../../../core/ApplicationInterfaces/psychlops_code_exception.h"
#include "../../win32/psychlops_app_tweak_Win32.h"

namespace Psychlops {
namespace Widgets {




namespace Dialog {

	void alert(std::string message)
	{
		ShowCursor(true);
		MessageBox( NULL, message.c_str(), "Notification", MB_OK );
		ShowCursor(false);
	}
	void alert(std::wstring message)
	{
		ShowCursor(true);
		MessageBoxW( NULL, message.c_str(), L"Notification", MB_OK );
		ShowCursor(false);
	}

static TCHAR strFile[MAX_PATH] = "\0\0", strCustom[256] = TEXT("Beforefiles\0*.*\0\0");
	std::string getOpenFileName()
	{
		Canvas *cnvs = dynamic_cast<Canvas*>(Drawable::prime);
		HWND handle = Psychlops::DebugTweakTool::getRawWindowHandle(*cnvs);

		OPENFILENAME *ofn = new OPENFILENAME;
		ZeroMemory(ofn, sizeof(OPENFILENAME));

		ofn->lStructSize = sizeof(OPENFILENAME);
		ofn->hwndOwner = handle;
		ofn->lpstrFilter =  //TEXT("Text files {*.txt}\0*.txt\0")
							TEXT("All files {*.*}\0*.*\0\0");
		ofn->lpstrCustomFilter = NULL;//strCustom;
		ofn->nMaxCustFilter = 256;
		ofn->nFilterIndex = 0;
		ofn->lpstrFile = strFile;
		ofn->nMaxFile = MAX_PATH;
		ofn->Flags = OFN_FILEMUSTEXIST;

		ShowCursor(true);
		GetOpenFileName(ofn);
		//std::cout << CommDlgExtendedError();
		ShowCursor(false);
		std::string result(ofn->lpstrFile);
		//std::string result;
		delete ofn;
		return result;
	}

}	/*	<- namespace Dialog 	*/





	CloseButton::CloseButton()
	: Button(L"X", 20)
	{
		theme_type = Widgets::Theme::ALERT;
		Button::onClick = &exitApp;
		label.font.weight = Font::bold;
		label.fill = Color::white;
	}
	void CloseButton::exitApp()
	{
		if(AppState::shouldBeClose) exit(0);
		AppState::shouldBeClose = true;
	}

	MinimizeButton::MinimizeButton(Canvas &target)
	: Button(L"-", 20)
	{
		window = &target;
		arg = this;
		Button::onClickP = &minimizeApp;
		label.font.weight = Font::bold;
		label.fill = Color::white;
	}
	void MinimizeButton::minimizeApp(void *hwnd)
	{
		MinimizeButton *button = (MinimizeButton*)(hwnd);
		button->pushed_ = false;
		HWND window = Psychlops::DebugTweakTool::getRawWindowHandle(*(button->window));
		ShowWindow( window, SW_MINIMIZE );
	}


	TitleBar::TitleBar(Canvas &target)
	: mleft(Mouse::left), minimize(target)
	{
Theme::initialize();
		area.set(target.getWidth()-85, 20);
		area.fill = Color::white;
		close.area.set(50, 20).setDatum(Point(target.getWidth()-55, 0));
		minimize.area.set(30, 20).setDatum(Point(target.getWidth()-85, 0));
		dragged_ = false;
	}
	TitleBar& TitleBar::draw(Drawable &target)
	{
		/*
		Canvas *cnvs = dynamic_cast<Canvas*>(&target);
		::RECT rect;
		TRACKMOUSEEVENT eventTrack;

		if(cnvs!=0) {
			HWND window = Psychlops::DebugTweakTool::getRawWindowHandle(*cnvs);
			::POINT mousept;
			if(mleft.pushed()) {
				if(area.include(Mouse::position)) {
					GetWindowRect(window, &rect);
					begin_w.set(rect.left, rect.top);
					begin_w_size.set(rect.right - rect.left, rect.bottom - rect.top);
					begin_m = Mouse::uniPosition;
					GetCursorPos(&mousept);
						eventTrack.cbSize = sizeof(TRACKMOUSEEVENT);
						eventTrack.dwFlags = TME_LEAVE;
						eventTrack.hwndTrack = window;
						eventTrack.dwHoverTime = 100;
						TrackMouseEvent(&eventTrack);
					DragDetect( window, mousept );
					//ClipCursor( rect );
					dragged_=true;
				}
			} else if(mleft.pressed() && dragged_) {
				GetWindowRect(window, &rect);
				Point p = (Point)Mouse::uniPosition - begin_m, np = p + begin_w;
				MoveWindow(window, np.x, np.y, begin_w_size.x, begin_w_size.y, false);
						eventTrack.cbSize = sizeof(TRACKMOUSEEVENT);
						eventTrack.dwFlags = TME_LEAVE;
						eventTrack.hwndTrack = window;
						eventTrack.dwHoverTime = 100;
						TrackMouseEvent(&eventTrack);
				//GetCursorPos(&mousept);
				//DragDetect( window, mousept );
				//ClipCursor( rect );
			} else if(mleft.released()) {
				//ClipCursor( NULL );
				dragged_ = false;
			}
			cnvs->drawImage(*(Theme::current.button_back), area);
			cnvs->drawImage(*(Theme::current.horiz_grad), area);
		}
		*/
		minimize.draw();
		close.draw();
		return *this;
	}


	std::string SequentialScreenshot::bin_path = "C:\\Library\\Frameworks\\Psychlops.framework\\bin\\fmpeg.exe ";
	const SequentialScreenshot& SequentialScreenshot::save(std::string filename) {
		std::stringstream command;
		char buf[256];
		for(int i=0; i<movie.size(); i++) {
			memset(buf, 0, 256);
			sprintf(buf, "snap%04d.png\0", i+1);
			movie[i]->save(directory+"/ScreenShots/"+buf);
		}
		command << bin_path << " -r 60 -y -i cap\\cap%04d.png -vcodec msmpeg4 " << filename;
		const char *lpArg = command.str().c_str();
		PROCESS_INFORMATION pi;
		STARTUPINFO si;
		ZeroMemory(&si,sizeof(si));
		si.cb=sizeof(si);
		CreateProcess(NULL,(LPTSTR)lpArg,NULL,NULL,FALSE,NORMAL_PRIORITY_CLASS,NULL,NULL,&si, &pi);
		CloseHandle(pi.hThread);
		WaitForSingleObject(pi.hProcess,INFINITE);
		CloseHandle(pi.hProcess);
		clear();
		saved = true;
		return *this;
	}

}	/*	<- namespace Widgets 	*/
}	/*	<- namespace Psycholops 	*/
