#include <psychlops.h>
using namespace Psychlops;


void psychlops_main() {

	for(int i=0; i<AppInfo::args.size(); i++)
	{
		std::cout << i << ": \""<< AppInfo::args[i] << "\"" << std::endl;
	}

	Canvas display(Canvas::window, Display::primary);
	Mouse::show();
	Color::setGammaValue(1.0,1.0,1.0);

	double cutoff1=1.0,cutoff2=1.0;
	Range rng;
	Widgets::Slider mean[3];
	mean[0].link(cutoff1, "cutoff1"  , 0<=rng<=256, 1);
	mean[1].link(cutoff2, "cutoff2"  , 0<=rng<=256, 1);


	Image source(256,256);
	for(int x=0; x<256; x++){
		double col = random(1.0);
		for(int y=0; y<256; y++){
			source.pix(x,y,Color(col));
		}
	}
	Image result, result2;
	FFT2::filterImage(source, result, 10, 10, 1.0);
	FFT2::filterImage(source, result2, 10, 10, 1.0);


	while(!Input::get(Keyboard::esc)) {
		display.clear();

		result.centering().shift(-200,0).draw();
		result2.centering().shift(200,0).draw();

		if(mean[0].changed()) {
			FFT2::filterImage(source, result, cutoff1, cutoff1, 0.1);
		}

		if(mean[1].changed()) {
			FFT2::filterImage(source, result2, cutoff2, cutoff2, 0.1);
		}


		for(int i=0; i<3; i++)
		{
			mean[i].setDatum(Point(0,0)).shift(20, i*25 + 10).draw();
		}

		display.flip();
	}


}
