
// Motion with glass patterns.
// Ross, J., Badcock, D. R., and Hayes, A. (2000)
// Coherent global motion in the absence of coherent velocity signals.
// Current Biology, 10, 679-682.
///+ Prefix
//// Include Psychlops Package
#include <psychlops.h>
using namespace Psychlops;    // Initially developed with Psychlops Win32 1.5.3 / 20110311
///- Prefix

///+ Stimulus drawing function
//// A function for stimulus drawing (main body)
void GlassPattern() {

	///+ Preperation
	//// Declare and initialize local variables
	Canvas display(Canvas::window); //Prepare drawing window
	int duration = 2;
	double dotsize = 2;
	double dot_lum  = 0.5;
	double bg_lum    = 0.2;
	double distance = 3.0;
	double fieldsize = 600;
	double orientation[4096];
	Psychlops::Rectangle dots(dotsize, dotsize);
	///+ prepare dots position
	//// prepare dots position and paired orientation
	Psychlops::Matrix positionmat(4096,2);
	random(positionmat, -0.5*fieldsize, 0.5*fieldsize);
	for(int i=0; i<4096; i++){orientation[i] = atan2(positionmat(i+1,2), positionmat(i+1,1));}
	///- prepare dots position
	///+ prepare selectbox
	//// prepare selectbox to select stimulus type.
	Psychlops::Widgets::SelectBox stimulus_type;
	stimulus_type.area.set(100,20);
	stimulus_type.append(L"Circular");
	stimulus_type.append(L"Diversion");
	stimulus_type.append(L"Spiral");
	stimulus_type.centering().shift(0.0, 250);
	///- prepare selectbox
	///- Preperation

	///+ Draw Gaussian Envelope
	////Draw offscreen Gaussian Envelope
	Psychlops::Image envelope(fieldsize+100, fieldsize+100, Image::RGBA); //declare offscreen image
	envelope.clear(Color(bg_lum)); //clear offscreen image
	double _x,_y;
	for(int i=0; i<fieldsize+100; i++){
		_x=i-0.5*fieldsize-50;
		for(int j=0; j<fieldsize+100; j++){
			_y=j-0.5*fieldsize-50;
			envelope.alpha(i,j,1.0-exp(-((_x*_x+_y*_y)/ (2.0*pow(fieldsize/6.0, 2.0) ))));
		}
	}
	envelope.cache();
	///- Draw Gaussian Envelope
	///+ set Independent
	//// set variables and value ranges for interaction
	Interval rng;
	Independent << distance | "distance between pairs"      |   1 <= rng <= 100 | 1.0 | 10.0 ;
	Independent << duration | "Refresh" | 0.0<=rng<=10.0 |  1 | 1;
	///- set Independent

	int frame = 0;
	Figures::Movie m;
	m.source.set(256,256).centering();

	while(!Input::get(Keyboard::esc)) {
		///+ position change
		//// Re-randomize position with a desingated interval
		if(frame > duration)
		{
			random(positionmat, -0.5*fieldsize, 0.5*fieldsize);
			for(int i=0; i<4096; i++){orientation[i] = atan2(positionmat(i+1,2), positionmat(i+1,1));}
			frame = 0;
		}
		///- position change
		Display::clear(Color(bg_lum)); //Clear window


		//// Draw 4096 pairs of dots
		for(int i=0; i<4096; i++){
			///+ draw first dots

			///+ switch stimulus type
			//// draw the second dots to generate selected stimulu type.
			switch(stimulus_type.getSelected()){
				///+ case rotation
				//// Rotation
				case 0:
				dots.centering().shift(positionmat(i+1,1),positionmat(i+1,2)); // move to center position
				dots.shift(-0.5*distance*cos(orientation[i]+0.5*PI),-0.5*distance*sin(orientation[i]+0.5*PI));// move to the first position
				dots.draw(Color(dot_lum)); // draw first dot
				dots.shift(distance*cos(orientation[i]+0.5*PI),distance*sin(orientation[i]+0.5*PI));// move to the second position
				break;
				///- case rotation
				///+ case diversion
				////Diversion
				case 1:
				dots.centering().shift(positionmat(i+1,1),positionmat(i+1,2));// move to center position
				dots.shift(-0.5*distance*cos(orientation[i]+0.5*PI),-0.5*distance*sin(orientation[i]+0.5*PI));// move to the first position
				dots.draw(Color(dot_lum));// draw first dot
				dots.shift(distance*cos(orientation[i]),distance*sin(orientation[i]));// move to the second position
				break;
				///- case diversion
				///+ case spiral
				//// Spiral
				case 2:
				dots.centering().shift(positionmat(i+1,1),positionmat(i+1,2));// move to center position
				dots.shift(-0.5*distance*cos(orientation[i]+0.5*PI),-0.5*distance*sin(orientation[i]+0.5*PI));// move to the first position
				dots.draw(Color(dot_lum));// draw first dot
				dots.shift(distance*cos(orientation[i]+0.25*PI),distance*sin(orientation[i]+0.25*PI));// move to the second position
				break;
				///- case spiral
			}
			///- switch stimulus type

			dots.draw(Color(dot_lum)); // Draw dots at a desinated position.

		}
		///- Draw dots
		envelope.centering().draw(); //Draw offscreen Gaussian onto screen
		stimulus_type.draw(); //Draw a select box.
        m.capture();
		Display::flip(); // Flip frame buffers
		frame++;
	}
    Figures::Movie::bin_path = "C:\\Library\\frameworks\\Psychlops.framework\\bin\\ffmpeg.exe";
	m.save("D:\\Users\\hskwk\\Documents\\Develop\\Psychlops\\result.gif");

}
///- Stimulus drawing function

///+ Main function for demo circumstances
void psychlops_main() {
///+ Demo circumstances
//// Spells for run demonstration circumstances
Procedure p;
p.setDesign(Procedure::DEMO); //Designate that this is a demo.
p.setProcedure(GlassPattern);  //The argument name is a name of drawing function.
p.run();
///- Demo circumstances
}
///- Main function for demo circumstances


#if 0

#include <psychlops.h>
using namespace Psychlops;


Clock before, after;
void memoBefore() { before.update(); }
double pastTime() { after.update(); return (after-before).at_msec(); }


void psychlops_main() {


	Display target_display = Display::secondary;
	std::cout << target_display.width << std::endl;
	std::cout << Display::secondary.getHeight() << std::endl;


	Canvas display(1024, 768, Canvas::window, target_display);
	Range rng;
/*
	Mouse::show();
	Color::setGammaValue(1.0,1.0,1.0);

	double cutoff1=1.0,cutoff2=0.0;
	Widgets::Slider slider[3];
	slider[0].link(cutoff1, "cutoff1"  , 0<=rng<=256, 1);
	slider[1].link(cutoff2, "half width"  , 0<=rng<=1, 0.125);
*/

/*
	//void drawGrating(Image &img, int width, int height, double wavelength, double contrast, double orientation, double phase);
	//void drawGaussian(Image &img, double sigma, double factor);
	//void drawGabor(Image &img, double sigma, double wavelength, double contrast, double orientation, double phase);
	std::stringstream ss;
	Image img;
	for(double wavelength_=2; wavelength_<8; wavelength_+=1.0 )
	{
		for(double ori = 0; ori<180.0; ori+=30)
		{
			for(double amp = 0.25; amp<=1; amp+=0.25)
			{
				for(double phase = 0; phase<360.0; phase+=30)
				{
					Figures::drawGrating(img, 36, 36, pow(2,wavelength_), amp, ori/360*2*PI, phase/360*2*PI);
					ss.str("");
					ss << "output/Grating_wav" << pow(2,wavelength_) << "_amp" << amp << "_ori" << ori << "_pha" << phase << ".png";
					img.save(ss.str());
					//Figures::drawGrating(img, 45, 45, pow(2,wavelength_), amp, ori/360*2*PI, phase/360*2*PI);
				}
			}
		}
	}
*/

/*
	while(!Keyboard::esc.pushed()) {

		memoBefore();
		std::cout << pastTime() << std::endl;


		memoBefore();
*/

	Figures::Movie m;
	m.source.set(100,100).centering();

		//while(!Keyboard::esc.pushed()) {
		for(int j=0; j<10; j++) {
			display.clear(Color::blue);


			//img.centering().draw();
			for(int i=0; i<2; i++)
			{
				//slider[i].setDatum(Point(0,0)).shift(20, i*25 + 10).draw();
			}
			m.capture();
			//display.to(m[j], r);
			display.flip();
		}
		m.save("test.gif");
	//	std::cout << pastTime() << std::endl;
	//}* /
}
#endif
