#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<time.h>
#include	<stdlib.h>
#include	<string.h>

#include	<sys/ioctl.h>
#include	"pt1_ioctl.h"

char	*bsdev[2] = {
	"/dev/pt1video1",
	"/dev/pt1video0"
};
char	*isdb_t_dev[2] = {
	"/dev/pt1video2",
	"/dev/pt1video3"
};

// 151chBSī
// 161chBS-i
// 171chBSѥ
// 211chBS11ǥ
// 222chTwellV
// 141chBSƥ
// 181chBSե
// 101chNHK1(BS1)
// 102chNHK2(BS2)
// 103chNHKϥӥ(BShi)
#define		BUFFER_SIZE		(4 * 1024 * 1024)
#define		WRITE_SIZE		(64 * 1024)
typedef	struct	_ISDB_T_FREQ_CONV_TABLE {
	int		set_freq ;				// ºݤioctl()Ԥ
	char	*parm_freq ;			// ѥ᡼Ǽ
}ISDB_T_FREQ_CONV_TABLE;

// Ѵơ֥(ISDB-T)
ISDB_T_FREQ_CONV_TABLE	isdb_t_conv_table[113] = {
	{   0,   "1"}, {   1,   "2"}, {   2,   "3"}, {   3, "C13"},
	{   4, "C14"}, {   5, "C15"}, {   6, "C16"}, {   7, "C17"},
	{   8, "C18"}, {   9, "C19"}, {  10, "C20"}, {  11, "C21"},
	{  12, "C22"}, {  13,   "4"}, {  14,   "5"}, {  15,   "6"},
	{  16,   "7"}, {  17,   "8"}, {  18,   "9"}, {  19,  "10"},
	{  20,  "11"}, {  21,  "12"}, {  22, "C23"}, {  23, "C24"},
	{  24, "C25"}, {  25, "C26"}, {  26, "C27"}, {  27, "C28"},
	{  28, "C29"}, {  29, "C30"}, {  30, "C31"}, {  31, "C32"},
	{  32, "C33"}, {  33, "C34"}, {  34, "C35"}, {  35, "C36"},
	{  36, "C37"}, {  37, "C38"}, {  38, "C39"}, {  39, "C40"},
	{  40, "C41"}, {  41, "C42"}, {  42, "C43"}, {  43, "C44"},
	{  44, "C45"}, {  45, "C46"}, {  46, "C47"}, {  47, "C48"},
	{  48, "C49"}, {  49, "C50"}, {  50, "C51"}, {  51, "C52"},
	{  52, "C53"}, {  53, "C54"}, {  54, "C55"}, {  55, "C56"},
	{  56, "C57"}, {  57, "C58"}, {  58, "C59"}, {  59, "C60"},
	{  60, "C61"}, {  61, "C62"}, {  62, "C63"}, {  63,  "13"},
	{  64,  "14"}, {  65,  "15"}, {  66,  "16"}, {  67,  "17"},
	{  68,  "18"}, {  69,  "19"}, {  70,  "20"}, {  71,  "21"},
	{  72,  "22"}, {  73,  "23"}, {  74,  "24"}, {  75,  "25"},
	{  76,  "26"}, {  77,  "27"}, {  78,  "28"}, {  79,  "29"},
	{  80,  "30"}, {  81,  "31"}, {  82,  "32"}, {  83,  "33"},
	{  84,  "34"}, {  85,  "35"}, {  86,  "36"}, {  87,  "37"},
	{  88,  "38"}, {  89,  "39"}, {  90,  "40"}, {  91,  "41"},
	{  92,  "42"}, {  93,  "43"}, {  94,  "44"}, {  95,  "45"},
	{  96,  "46"}, {  97,  "47"}, {  98,  "48"}, {  99,  "49"},
	{ 100,  "50"}, { 101,  "51"}, { 102,  "52"}, { 103,  "53"},
	{ 104,  "54"}, { 105,  "55"}, { 106,  "56"}, { 107,  "57"},
	{ 108,  "58"}, { 109,  "59"}, { 110,  "60"}, { 111,  "61"},
	{ 112,  "62"}
};

// ȿơ֥Ѵ
int		searchrecoff(char *channel)
{
	int		lp ;

	for(lp = 0 ; lp < 113 ; lp++){
		// ʸĹפȿơֵֹ֥Ѥ
		if((memcmp(isdb_t_conv_table[lp].parm_freq, channel, strlen(channel)) == 0) &&
			(strlen(channel) == strlen(isdb_t_conv_table[lp].parm_freq))){
			return isdb_t_conv_table[lp].set_freq ;
		}
	}
}
int		main(int argc, char **argv)
{
	int		fd ;
	int		size = 0 ;
	int		fd2 ;
	int		rc ;
	int		lp ;
	int		channel ;
	int		recsec ;
	time_t	start_time ;
	time_t	cur_time ;
	char	*buffer ;
	FREQUENCY	freq;

	if(argc < 4){
		printf("Usage %s: channel recsec destfile\n", argv[0]);
		printf("channel =\n");
		printf("151chBSī\n");
		printf("161chBS-i\n");
		printf("171chBSѥ\n");
		printf("211chBS11ǥ\n");
		printf("222chTwellV\n");
		printf("141chBSƥ\n");
		printf("181chBSե\n");
		printf("101chNHK1(BS1)\n");
		printf("102chNHK2(BS2)\n");
		printf("103chNHKϥӥ(BShi)\n");
		return 1;
	}
	buffer = calloc(BUFFER_SIZE, 2);
	if(buffer == NULL){
		printf("Memory Alloc Error\n");
		return 1 ;
	}
	channel = atoi(argv[1]);
	if(channel > 100){
		freq.frequencyno = channel ;
		for(lp = 0 ; lp < 2 ; lp++){
			fd = open(bsdev[lp], O_RDONLY);
			if(fd >= 0){
				break ;
			}
		}
		if(fd < 0){
			printf("Device Open Error\n");
			return 1;
		}
	}else{
		freq.frequencyno = searchrecoff(argv[1]);
		freq.slot = 0 ;
		for(lp = 0 ; lp < 2 ; lp++){
			fd = open(isdb_t_dev[lp], O_RDONLY);
			if(fd >= 0){
				break ;
			}
		}
		if(fd < 0){
			printf("Device Open Error\n");
			return 1;
		}
	}
	recsec = atoi(argv[2]);

	fd2 = open64(argv[3], (O_RDWR | O_CREAT | O_TRUNC), 0666);
	if(fd2 < 0){
		printf("Output File Open Error(%s)\n", argv[3]);
		return 0;
	}

	if(ioctl(fd, SET_CHANNEL, &freq) < 0){
		printf("Tuner Select Error\n");
		return 0 ;
	}
	if(ioctl(fd, START_REC, 0) < 0){
		printf("Tuner Start Error\n");
		return 0 ;
	}

	time(&start_time);
	while(1){
		rc = read(fd, &buffer[size], ((BUFFER_SIZE * 2) - size));
		if(rc > 0){
			size += rc ;
		}if(size > WRITE_SIZE){
			write(fd2, buffer, size);
			size = 0 ;
		}
		time(&cur_time);

		if((cur_time - start_time) >= recsec){
			ioctl(fd, STOP_REC, 0);
			//ʤʤޤǥǡɤ߽Ф
			while(1){
				rc = read(fd, &buffer[size], ((BUFFER_SIZE * 2) - size));
				if(rc == 0){
					break ;
				}
				if(rc > 0){
					size += rc ;
				}
				if(size){
					write(fd2, buffer, size);
				}
			}
			close(fd);
			close(fd2);
			break ;
		}
	}
	return 0 ;
}
