/*
 * PT1.h
 */
#ifndef __PTX_PT1_H__
#define __PTX_PT1_H__

#include "PTx/PTx.h"

namespace PTx
{

enum
{
    MAX_DEV_COUNT = 4,
    MAX_TUNER_COUNT = 4
};

class PT1
{
private:
    io_connect_t _connect;
    vm_address_t _buffer;
    vm_size_t    _bufsize;
    BufferInfo   _bufferInfo;
    bool         _opened;

public:
    static int scan(PT1 *pt1s[MAX_DEV_COUNT]);

    PT1();
    ~PT1();
    bool init(io_service_t service);

    bool getDeviceInfo(DeviceInfo *info);

    int open();
    int close();
    int getPciClockCounter(uint32_t *counter);
    int setPciLatencyTimer(uint8_t latencyTimer);
    int getPciLatencyTimer(uint8_t *latencyTimer);
    int setLnbPower(LnbPower lnbPower);
    int getLnbPower(LnbPower *lnbPower);
    int setLnbPowerWhenClose(LnbPower lnbPower);
    int getLnbPowerWhenClose(LnbPower *lnbPower);
    int setTunerPowerReset(TunerPowerReset tunerPowerReset);
    int getTunerPowerReset(TunerPowerReset *tunerPowerReset);
    int initTuner(uint32_t tuner);
    int setTunerSleep(uint32_t tuner, ISDB isdb, bool sleep);
    int getTunerSleep(uint32_t tuner, ISDB isdb, bool *sleep);
    int setFrequency(uint32_t tuner, ISDB isdb, uint32_t channel, int32_t offset);
    int getFrequency(uint32_t tuner, ISDB isdb, uint32_t *channel, int32_t *offset);
    int getFrequencyOffset(uint32_t tuner, ISDB isdb, int32_t *clock, int32_t *carrier);
    int getCnAgc(uint32_t tuner, ISDB isdb, uint32_t *cn100, uint32_t *currentAgc, uint32_t *maxAgc);
    int setIdS(uint32_t tuner, uint32_t tsid);
    int getIdS(uint32_t tuner, uint32_t *tsid);
    int getCorrectedErrorRate(uint32_t tuner, ISDB isdb, LayerIndex layerIndex, ErrorRate *errorRate);
    int resetCorrectedErrorCount(uint32_t tuner, ISDB isdb);
    int getErrorCount(uint32_t tuner, ISDB isdb, uint32_t *count);
    int getTmccS(uint32_t tuner, TmccS *tmcc);
    int getLayerS(uint32_t tuner, LayerS *layer);
    int getTmccT(uint32_t tuner, TmccT *tmcc);
    int getLockedT(uint32_t tuner, bool locked[LAYER_COUNT_T]);
    int setLayerEnable(uint32_t tuner, ISDB isdb, LayerMask layerMask);
    int getLayerEnable(uint32_t tuner, ISDB isdb, LayerMask *layerMask);
    int setBufferInfo(const BufferInfo *bufferInfo);
    int getBufferInfo(BufferInfo *bufferInfo);
    int getBufferPtr(uint32_t index, void **ptr);
    int resetTransferCounter();
    int incrementTransferCounter();
    int setStreamEnable(uint32_t tuner, ISDB isdb, bool enable);
    int getStreamEnable(uint32_t tuner, ISDB isdb, bool *enable);
    int setStreamGray(uint32_t tuner, ISDB isdb, uint32_t gray);
    int getStreamGray(uint32_t tuner, ISDB isdb, uint32_t *gray);
    int setTransferEnable(bool enable);
    int getTransferEnable(bool *enable);
    int getTransferInfo(TransferInfo *transferInfo);
};

} // PTx
#endif