#!/bin/bash

#usage: REV4=b44c SUFFIX=rc2 /path/to/create_patch_152.sh

set -uex

echo REV4: $REV4
echo SUFFIX: $SUFFIX

# Unzip all
for f in $(ls *.zip); do
  echo $f
  unzip $f
done

# Prepare (UTF-8)
rm pukiwiki-1.5.1_utf8/cache/*.rel
rm pukiwiki-1.5.1_utf8/cache/*.ref
rm pukiwiki-1.5.1_utf8/cache/autolink.dat
rm pukiwiki-1.5.1_utf8/cache/entities.dat
rm pukiwiki-1.5.1_utf8/skin/pukiwiki.css.php
rm pukiwiki-1.5.1_utf8/skin/tdiary.css.php

# Prepare (EUC-JP)
rm pukiwiki-1.5.1_eucjp/cache/*.rel
rm pukiwiki-1.5.1_eucjp/cache/*.ref
rm pukiwiki-1.5.1_eucjp/cache/autolink.dat
rm pukiwiki-1.5.1_eucjp/cache/entities.dat
rm pukiwiki-1.5.1_eucjp/skin/pukiwiki.css.php
rm pukiwiki-1.5.1_eucjp/skin/tdiary.css.php

no_exit_diff()
{
    set +e
    diff $@
    set -e
}

# Create patch packages
no_exit_diff -urN pukiwiki-1.5.1_utf8 pukiwiki-1.5.2_utf8 > update_pukiwiki_151to152_utf8.patch
no_exit_diff -urN pukiwiki-1.5.1_eucjp pukiwiki-1.5.2_eucjp > update_pukiwiki_151to152_eucjp.patch
zip update_pukiwiki_151to152_utf8.patch.zip update_pukiwiki_151to152_utf8.patch
zip update_pukiwiki_151to152_eucjp.patch.zip update_pukiwiki_151to152_eucjp.patch
cp -p update_pukiwiki_151to152_utf8.patch.zip update_pukiwiki_151to152${SUFFIX}-${REV4}_utf8.patch.zip
cp -p update_pukiwiki_151to152_eucjp.patch.zip update_pukiwiki_151to152${SUFFIX}-${REV4}_eucjp.patch.zip

