#!/bin/bash

set -exu

# usage: REVISION=xxxxxxx PREV=1.5.2 VERSION=1.5.3 SUFFIX=rc2 ./pack.sh

echo REVISION: $REVISION
: $REVISION
: $PREV
: $VERSION
: $SUFFIX

REV4=${REVISION:0:4}
echo $REV4

# Ensure dirs
pushd ../outputs
popd
pushd ../tmp
popd

OUTPUT_DIR="../outputs/_build_package_${VERSION}_${SUFFIX}"
mkdir $OUTPUT_DIR

./release.sh --git --zip --name pukiwiki-${VERSION}_utf8 \
  --utf8 --repo git://git.osdn.jp/gitroot/pukiwiki/pukiwiki.git \
  $REVISION

./release.sh --git --zip --name pukiwiki-${VERSION}_eucjp \
  --eucjp --repo git://git.osdn.jp/gitroot/pukiwiki/pukiwiki.git \
  $REVISION

DIST_UTF8=pukiwiki-${VERSION}-${SUFFIX}-${REV4}_utf8.zip
DIST_EUCJP=pukiwiki-${VERSION}-${SUFFIX}-${REV4}_eucjp.zip
cp -p pukiwiki-${VERSION}_utf8.zip $DIST_UTF8
cp -p pukiwiki-${VERSION}_eucjp.zip $DIST_EUCJP

mv *.zip $OUTPUT_DIR/

DATENOW=$(date +'%Y%m%d_%H%M')
mv pukiwiki-${VERSION}_utf8 ../tmp/_pukiwiki-${VERSION}_utf8_${DATENOW}
mv pukiwiki-${VERSION}_eucjp ../tmp/_pukiwiki-${VERSION}_eucjp_${DATENOW}

# Create patch
PATCH_DIR=../tmp/patch-${VERSION}-${SUFFIX}
mkdir $PATCH_DIR

cp -p ../releases/pukiwiki-${PREV}_utf8.zip ${PATCH_DIR}/
cp -p ../releases/pukiwiki-${PREV}_eucjp.zip ${PATCH_DIR}/
cp -p $OUTPUT_DIR/$DIST_UTF8 ${PATCH_DIR}/
cp -p $OUTPUT_DIR/$DIST_EUCJP ${PATCH_DIR}/
ORI_DIR=$(pwd)
pushd $PATCH_DIR
  REV4=$REV4 SUFFIX=$SUFFIX PREV=$PREV NEW=$VERSION $ORI_DIR/create_patch.sh
popd
cp -p ${PATCH_DIR}/*.patch.zip $OUTPUT_DIR/

pushd $OUTPUT_DIR/
  sha256sum *
popd

