#pragma once

#ifdef WIN32
#include "afxcview.h"
#endif
#include "q2chwmBoardFile.h"
#include "q2chwmBoardItem.h"
#include "q2chwmCommon.h"

// Cq2chwmBoardView r[

class Cq2chwmBoardView : public CTreeView
{
	DECLARE_DYNCREATE(Cq2chwmBoardView)

private:
	Cq2chwmBoardFile m_cBoardFile;
	Cq2chwmBoardFileEtc m_cBoardFileEtc;
	HTREEITEM m_hItemBookmark;
	HTREEITEM m_hItemCache;
	HTREEITEM m_hItemFind2ch;
	HTREEITEM m_hItemEtc;
	CFont *m_pFont;
	BOOL m_bo_running;
	HICON m_hIconCollapsed;
	HICON m_hIconExpanded;
	int m_in_icon_size;

private:
	void createTree();
	void clearTree();
	void createTreeEtc();
	void clearTreeEtc();
	HTREEITEM getBottomItem(HTREEITEM hItemParent = NULL);

public:
	Cq2chwmBoardView();           // IŎgp protected RXgN^
	virtual ~Cq2chwmBoardView();

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

protected:
	DECLARE_MESSAGE_MAP()
public:
//	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
public:
	virtual void OnInitialUpdate();

	BOOL CreateFromFile();
	BOOL CreateFromHttp(const char *chp_url);
	void SetFont();
	void SetColor();
	void GoTop();
	void GoBottom();
	int SearchFromUrl(const char *chp_burl);
	int SearchFromId(const char *chp_bid);
	const char *GetBoardName(int in_index);
	const char *GetBoardId(int in_index);
	const char *GetBoardUrl(int in_index);
	inline BOOL IsRunning(){ return m_bo_running; }
	BOOL DetectRemoval();
	BOOL MergeDirectory(const char *chp_src, const char *chp_dst);
	int SearchNext(const char *chp_word);
	int SearchPrev(const char *chp_word);
	BOOL ReloadEtc();
	void CopyInformation();

public:
	afx_msg void OnDestroy();
public:
	afx_msg void OnNMReturn(NMHDR *pNMHDR, LRESULT *pResult);
public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
public:
	afx_msg void OnReload();
public:
	afx_msg void OnGobottom();
public:
	afx_msg void OnGotop();
public:
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnPaint();
protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
public:
	afx_msg void OnNMClick(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnAddBookmark();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
};


