#pragma once

#include "q2chwmListView.h"
#include "q2chwmCacheImageFile.h"

// Cq2chwmCacheView r[

class Cq2chwmCacheImageView : public Cq2chwmListView
{
//	DECLARE_DYNCREATE(Cq2chwmCacheView)
private:
	BOOL m_bo_multiselect;
	BOOL m_bo_create;

private:
	BOOL readDirectory(const char *chp_dir, int& in_index);
	BOOL addItem(int in_index, const char *chp_filename, const char *chp_date);

protected:
	void SortItems(int in_col, BOOL bo_asc);
	virtual BOOL GetItemText(LPTSTR wchp_text, int in_size, int in_row, int in_col);

public:
	Cq2chwmCacheImageView();           // IŎgp protected RXgN^
	virtual ~Cq2chwmCacheImageView();

	BOOL CreateList();
	void SetFont();
	void OnListClicked();
	void Delete();
	void Sort();
	void Search(const char *chp_word);
	BOOL AddItem(const char *chp_filename);
	BOOL UpdateItem(const char *chp_filename);
	Cq2chwmListItem *GetSelectedItem();
	Cq2chwmListItem *GetItem(int iRow);
	virtual void CopyInformation();

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual void OnInitialUpdate();
public:
	afx_msg void OnDestroy();
public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
public:
	afx_msg void OnDelete();
public:
	afx_msg void OnSortAname();
	afx_msg void OnUpdateSortAname(CCmdUI *pCmdUI);
	afx_msg void OnSortDate();
	afx_msg void OnUpdateSortDate(CCmdUI *pCmdUI);
	afx_msg void OnSortIndex();
	afx_msg void OnUpdateSortIndex(CCmdUI *pCmdUI);
	afx_msg void OnSortSearch();
	afx_msg void OnUpdateSortSearch(CCmdUI *pCmdUI);
	afx_msg void OnAdjustColumnWidth();
	afx_msg void OnMultiSelect();
	afx_msg void OnUpdateMultiSelect(CCmdUI *pCmdUI);
protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
};


