// q2chwmFind2chDialog.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmFind2chDialog.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"

// Cq2chwmFind2chDialog _CAO

IMPLEMENT_DYNAMIC(Cq2chwmFind2chDialog, CDialog)

Cq2chwmFind2chDialog::Cq2chwmFind2chDialog(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmFind2chDialog::IDD, pParent)
	, m_cstr_word(_T(""))
	, m_in_sort(0)
{
	m_in_sort = Cq2chwmConfig::GetInstance()->GetSortFind2ch();
}

Cq2chwmFind2chDialog::~Cq2chwmFind2chDialog()
{
}

void Cq2chwmFind2chDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_CBString(pDX, IDC_COMBO_SEARCH, m_cstr_word);
	DDX_CBIndex(pDX, IDC_COMBO_SORT, m_in_sort);
}


BEGIN_MESSAGE_MAP(Cq2chwmFind2chDialog, CDialog)
	ON_WM_SIZE()
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, &Cq2chwmFind2chDialog::OnBnClickedButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_FIND, &Cq2chwmFind2chDialog::OnBnClickedButtonFind)
END_MESSAGE_MAP()


// Cq2chwmFind2chDialog bZ[W nh

void Cq2chwmFind2chDialog::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (GetDlgItem(IDC_COMBO_SEARCH) != NULL &&
		::IsWindow(GetDlgItem(IDC_COMBO_SEARCH)->m_hWnd) != FALSE &&
		::IsWindow(m_cButtonClose.m_hWnd) == TRUE)
	{
		Cq2chwmLayoutManager cLayout(
			new Cq2chwmLayoutLine(GetDlgItem(IDC_COMBO_SEARCH), 3, GetDlgItem(IDC_COMBO_SORT), 2, &m_cButtonFind, 1, &m_cButtonClose, 1)
		);
		cLayout.Layout(cx, cy);
	}
}

void Cq2chwmFind2chDialog::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	UpdateData(TRUE);
	CString cstr_url = makeUrl();
	if (m_cstr_word.GetLength() > 0) {
		// init@C̃IvVۑ
		Cq2chwmConfig::GetInstance()->SetSortFind2ch(m_in_sort);
		CYoString str_word = A(m_cstr_word);
		CYoString str_url = A(cstr_url);
		GetParent()->SendMessage(WM_USER_EXECFIND2CH, (WPARAM)(const char*)str_url, (LPARAM)(const char*)str_word);
	}

	//CDialog::OnOK();
}

void Cq2chwmFind2chDialog::OnCancel()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetParent()->SendMessage(WM_USER_SHOWFIND2CHBAR, 0, (LPARAM)FALSE);

	//CDialog::OnCancel();
}

BOOL Cq2chwmFind2chDialog::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (pMsg->message == WM_KEYDOWN && pMsg->wParam == 0x0d) {
		if (GetFocus() == GetDlgItem(IDC_COMBO_SEARCH)) {
			OnOK();
			return TRUE;
		} else if (GetFocus() == GetDlgItem(IDC_BUTTON_CLOSE)) {
			OnCancel();
			return TRUE;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void Cq2chwmFind2chDialog::SetFocus()
{
	GetDlgItem(IDC_COMBO_SEARCH)->SetFocus();
}

CString Cq2chwmFind2chDialog::makeUrl()
{
	// eLXg
	CYoString str_enc_text = A(m_cstr_word);
	str_enc_text.ConvertKCodeEx(CYoString::SJISTOEUC);
	str_enc_text.UrlEncode();

	// 
	int in_num = 50;

	// \[g
	int in_sort = m_in_sort * 2;

	// \[g
	static char *chpa_sort_text[] = {
		"SCEND=A&SORT=NPOSTS",
		"SCEND=D&SORT=NPOSTS",		// gp
		"SCEND=A&SORT=CREATED",
		"SCEND=D&SORT=CREATED",		// gp
		"SCEND=A&SORT=MODIFIED",
		"SCEND=D&SORT=MODIFIED"		// gp
	};
	CYoString str_sort_text = chpa_sort_text[in_sort];

	// URL
	CYoString str_url;
	str_url.Format("http://find.2ch.net/index.php?TYPE=TITLE&STR=%s&COUNT=%d&%s", (const char*)str_enc_text, in_num, (const char*)str_sort_text);

	CString cstr_url;
	cstr_url = str_url;
	return cstr_url;
}

void Cq2chwmFind2chDialog::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (bShow == TRUE && GetDlgItem(IDC_COMBO_SEARCH)->IsWindowVisible() == TRUE) {
		GetDlgItem(IDC_COMBO_SEARCH)->SetFocus();
	}
}

BOOL Cq2chwmFind2chDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	// Zbg
	ReloadHistory();

	RECT r;
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_SEARCH);
	pCombo->GetWindowRect(&r);
	int in_buttonsize = r.bottom - r.top;
	int in_iconsize = in_buttonsize < 32 ? 16 : 32;
	if (m_cButtonFind.Create(IDI_ICON_FIND, in_iconsize, in_iconsize, CRect(0, 0, in_buttonsize, in_buttonsize), this, IDC_BUTTON_FIND) == FALSE ||
		m_cButtonClose.Create(IDI_ICON_CLOSE, in_iconsize, in_iconsize, CRect(0, 0, in_buttonsize, in_buttonsize), this, IDC_BUTTON_CLOSE) == FALSE)
	{
		return FALSE;
	}
	m_cButtonFind.ShowWindow(SW_SHOW);
	m_cButtonClose.ShowWindow(SW_SHOW);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmFind2chDialog::OnBnClickedButtonClose()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	OnCancel();
}

void Cq2chwmFind2chDialog::OnBnClickedButtonFind()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	OnOK();
}

void Cq2chwmFind2chDialog::ReloadHistory()
{
	CComboBox *pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_SEARCH);
	pCombo->ResetContent();
	for (int i = 0; i < Cq2chwmConfig::GetInstance()->GetHistorySearchWordCount(); i++) {
		CString cstr_value;
		cstr_value = Cq2chwmConfig::GetInstance()->GetHistorySearchWord(i);
		pCombo->InsertString(i, cstr_value);
		if (i == 0) pCombo->SetWindowText(cstr_value);
	}
}
