#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmCommon.h"

#include "YoFile.h"
#include "YoString.h"
#include "YoDataArray.h"
#include "YoRegex.h"
#include "YoHttpClient.h"
#include "q2chwmConfig.h"
#include "q2chwmImageViewUrlReplace.h"
#include "MainFrm.h"

/*!
 * \brief
 * Findn\bhŎgpf[^NX.
 * 
 * Find\bhłURL𒊏oĂImageViewURLReplace.dat̐K\Ń}b`OKvB
 * URL̐K\NXFind\bhŖ񐶐ƃptH[}X邽߁A
 * FindOpenŖ{NX𐶐AK\NX1񂾂悤ɂB.
 * 
 */
class Cq2chwmImageViewUrlReplaceFindData
{
private:
	BOOL m_bo_refererence;
	CYoRegex m_cRegex;
	CString m_cstr_url;

public:
	Cq2chwmImageViewUrlReplaceFindData(BOOL bo_refererence) : m_cRegex(_T("h?t?tps?://[!-~]+"), CYoRegex::UTF16LE, TRUE)
	{
		m_bo_refererence = bo_refererence;
	}
	CYoRegex& GetRegex(){ return m_cRegex; }
	BOOL GetReference(){ return m_bo_refererence; }
	const wchar_t* GetUrl(){ return m_cstr_url; }
	void SetUrl(const wchar_t *wchp_url){ m_cstr_url = wchp_url; }
};

/*!
 * \brief
 * ImageViewURLReplace.dat̃f[^NX.
 * 
 * ImageViewURLReplace.dat1sێB̃NXCYoPtrArrayɍsi[B.
 * 
 */
class Cq2chwmImageViewUrlReplaceData : public Cq2chwmImageViewUrlReplaceBase
{
private:
	CYoRegex *m_pRegexSearch;			// 1 1p^[Ƃ鐳K\NX
	CYoString m_str_pattern_search;
	CYoString m_str_variable;			// 2 ␳	
	CYoString m_str_referer;			// 3 t@[
	OPTION m_option;					// 4 IvV
	CYoString m_str_pattern_extract;	// 5 HTMLp^[(4 IvVEXTRACT̎)
	CYoString m_str_referer_option;		// 4 IvVCOOKIE/EXTRACT̎Ƀt@[ƂĎgURL

public:
	Cq2chwmImageViewUrlReplaceData(const char *chp_pattern_search, const char *chp_variable,
		const char *chp_referer, const char *chp_option = NULL, const char *chp_pattern_extract = NULL);
	virtual ~Cq2chwmImageViewUrlReplaceData();

	inline CYoRegex *GetRegexSearch(){ return m_pRegexSearch; }
	inline const char *GetVariable(){ return m_str_variable; }
	inline const char *GetReferer(){ return m_str_referer; }
	inline Cq2chwmImageViewUrlReplaceData::OPTION GetOption(){ return m_option; }
	inline const char *GetPatternExtract(){ return m_str_pattern_extract; }
	inline const char *GetRefererOption(){ return m_str_referer_option; }
};

/*!
 * \brief
 * Write brief comment for Cq2chwmImageViewUrlReplaceData here.
 * 
 * \param chp_pattern_search
 * ImageViewUrlReplace.dat̑1 摜̂߂̐K\p^[.
 * 
 * \param chp_variable
 * ImageViewUrlReplace.dat̑2 ␳.
 * 
 * \param chp_referer
 * ImageViewUrlReplace.dat̑3 t@[.
 * 
 * \param chp_option
 * ImageViewUrlReplace.dat̑4 IvV(VIEWER|COOKIE|EXTRACT).
 * 
 * \param chp_pattern_extract
 * ImageViewUrlReplace.dat̑5 IvVEXTRACT̂߂̐K\p^[.
 * 
 * 1̃p^[ŐK\NX𐶐B}b`OɂGetRegexSearch\bhgB.
 * 
 */
Cq2chwmImageViewUrlReplaceData::Cq2chwmImageViewUrlReplaceData(
	const char *chp_pattern_search,
	const char *chp_variable,
	const char *chp_referer,
	const char *chp_option,
	const char *chp_pattern_extract)
	: m_pRegexSearch(NULL)
{
	if (chp_pattern_search != NULL) {
		m_str_pattern_search = chp_pattern_search;
		m_str_pattern_search.Replace("http://", "h?t?tp://");
		CString cstr_pattern;
		cstr_pattern = m_str_pattern_search;
		m_pRegexSearch = new CYoRegex((const wchar_t*)cstr_pattern, CYoRegex::UTF16LE, TRUE);
	}
	m_str_variable = chp_variable;
	m_str_referer = chp_referer;
	m_str_pattern_extract = chp_pattern_extract;
	if (chp_option != NULL && strncmp(chp_option, "$COOKIE", 8) == 0) {
		m_option = COOKIE;
		const char *chp_tmp = strchr(chp_option, '=');
		if (chp_tmp != NULL) m_str_referer_option = chp_tmp + 1;
	} else if (chp_option != NULL && strncmp(chp_option, "$EXTRACT", 8) == 0) {
		m_option = EXTRACT;
		const char *chp_tmp = strchr(chp_option, '=');
		if (chp_tmp != NULL) m_str_referer_option = chp_tmp + 1;
	} else {
		m_option = VIEWER;
	}
}

/*!
 * \brief
 * fXgN^.
 * 
 * K\NXj.
 */
Cq2chwmImageViewUrlReplaceData::~Cq2chwmImageViewUrlReplaceData()
{
	if (m_pRegexSearch != NULL) delete m_pRegexSearch;
}

Cq2chwmImageViewUrlReplace::Cq2chwmImageViewUrlReplace()
{
}

Cq2chwmImageViewUrlReplace::~Cq2chwmImageViewUrlReplace()
{
	for (int i = 0; i < Count(); i++) {
		Cq2chwmImageViewUrlReplaceData *pData = GetData(i);
		delete pData;
	}
}

Cq2chwmImageViewUrlReplace *Cq2chwmImageViewUrlReplace::m_pInstance = NULL;
Cq2chwmImageViewUrlReplace *Cq2chwmImageViewUrlReplace::GetInstance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new Cq2chwmImageViewUrlReplace();
		m_pInstance->Create();
		atexit(Cq2chwmImageViewUrlReplace::Delete);
	}

	return m_pInstance;
}

/*!
 * \brief
 * ImageViewURLReplace.datǂݍ.
 * 
 * \returns
 * t@C̃I[vɎsꍇAFALSE.
 * 
 * \returns
 * IATRUE.
 * 
 * ImageViewURLReplace.datǂݍCq2chwmImageViewUrlReplaceDataNXɂCYoPtrArrayɊi[.
 * 
 * \remarks
 * CYoPtrArray̍Ōɂ́AʓIȉ摜URL}b`Cq2chwmImageViewUrlReplaceDatai[ĂB.
 * 
 */
BOOL Cq2chwmImageViewUrlReplace::Create()
{
	RemoveAll();

	//exeƓtH_ImageViewURLReplace.datJ
	wchar_t cha_file[MAX_PATH + 1];
	{
		wchar_t *chp_ptr;
		GetModuleFileName(NULL, cha_file, MAX_PATH);
		chp_ptr = wcsrchr(cha_file, _T('\\'));
		wcscpy(chp_ptr + 1, _T("ImageViewURLReplace.dat"));
	}

	CYoTextFile cFile(A(cha_file), CYoFile::READ);
	if (cFile.Open() == FALSE) {
		return	FALSE;
	}

	CYoString str_line;
	int in_index = 1;
	while (cFile.Eof() == FALSE) {
		// 1sǂݍ
		cFile.ReadLine(str_line);
		str_line.Trim();

		// sRgAEgŎn܂Ȃǂݔ΂
		if (str_line.Length() == 0 || str_line.StrnCmp(";", 1) == 0 || str_line.StrnCmp("'", 1) == 0 || str_line.StrnCmp("//", 2) == 0) {
			continue;
		}

		// ^uŋ؂ăe[u(CYoTable)Ɋi[
		CYoDataArray cArray = CYoDataArray::CreateStringArray(str_line, "\t");

		Add(new Cq2chwmImageViewUrlReplaceData(cArray.Get(0), cArray.Get(1), cArray.Get(2), cArray.Get(3), cArray.Get(4)));
	}
	cFile.Close();
	Add(new Cq2chwmImageViewUrlReplaceData("h?t?tps?://[!-~]+\\.(gif|jpg|jpeg|png|bmp)(?:$|[^!-~])", "$0", "$0"));

	return	TRUE;
}

void Cq2chwmImageViewUrlReplace::Delete()
{
	if (m_pInstance != NULL) {
		delete m_pInstance;
		m_pInstance = NULL;
	}
}

/*!
 * \brief
 * Jn.
 * 
 * \param bo_refererence
 * Find\bhŌ}b`ꍇURLFindGetUrlŎ擾ꍇATRUE.
 * 
 * \returns
 * nh.
 * 
 */
HANDLE Cq2chwmImageViewUrlReplace::FindOpen(
	BOOL bo_reference)
{
	Cq2chwmImageViewUrlReplaceFindData *pFind = new Cq2chwmImageViewUrlReplaceFindData(bo_reference);
	return (HANDLE)pFind;
}

/*!
 * \brief
 * I.
 * 
 * \param hFind
 * nh.
 * 
 */
void Cq2chwmImageViewUrlReplace::FindClose(
	HANDLE hFind)
{
	Cq2chwmImageViewUrlReplaceFindData *pFind = (Cq2chwmImageViewUrlReplaceFindData*)hFind;
	delete pFind;
}

/*!
 * \brief
 * Ƀ}b`URL擾.
 * 
 * \param hFind
 * nh.
 * 
 * \returns
 * URL̃|C^.
 * 
 * OFind\bhŃ}b`URLԂ.
 */
const wchar_t *Cq2chwmImageViewUrlReplace::FindGetUrl(
	HANDLE hFind)
{
	Cq2chwmImageViewUrlReplaceFindData *pFind = (Cq2chwmImageViewUrlReplaceFindData*)hFind;
	return pFind->GetUrl();
}

int Cq2chwmImageViewUrlReplace::Find(
	HANDLE hFind,
	const char *chp_text)
{
	CString cstr_text;
	cstr_text = chp_text;
	return Find(hFind, (const wchar_t*)cstr_text);
}

/*!
 * \brief
 * ImageViewURLReplace.datŒ`ꂽK\URL.
 * 
 * \param hFind
 * nh.
 * 
 * \param wchp_text
 * Ώە.
 * 
 * \returns
 * }b`ꍇAURL𔭌CfbNX.
 * 
 * \returns
 * }b`ȂꍇA-1.
 * 
 * wchp_textURLSĒoAImageViewURLReplace.datŒ`ꂽK\Ń}b`OB.
 * wchp_textURLłȂĂB}b`ꍇAFindGetUrlURL擾\B
 * 
 */
int Cq2chwmImageViewUrlReplace::Find(
	HANDLE hFind,
	const wchar_t *wchp_text)
{
	Cq2chwmImageViewUrlReplaceFindData *pFind = (Cq2chwmImageViewUrlReplaceFindData*)hFind;
	int in_url_ret = 0;
	while ((in_url_ret = pFind->GetRegex().Match(wchp_text + in_url_ret)) >= 0) {
		CString cstr_url((const wchar_t*)pFind->GetRegex().Get(0));
		for (int i = Count() - 1; i >= 0; i--) {
			//}b`Os
			Cq2chwmImageViewUrlReplaceData *pData = GetData(i);
			if (pFind->GetReference() == FALSE) {
				pData->GetRegexSearch()->SetReference(FALSE);
			}
			int in_ret = pData->GetRegexSearch()->Match((const wchar_t*)cstr_url);
			if (in_ret >= 0) {
				if (pFind->GetReference() == TRUE) {
					pFind->SetUrl(cstr_url);
				}
				pData->GetRegexSearch()->SetReference(TRUE);
				return in_url_ret + in_ret / 2;
			}
			pData->GetRegexSearch()->SetReference(TRUE);
		}
		in_url_ret += cstr_url.GetLength();
	}

	return -1;
}

/*!
 * \brief
 * 摜URL擾.
 * 
 * \param chp_url
 * URL.
 * 
 * \param cMatch
 * 摜擾pURLNX.
 * 
 * \returns
 * }b`ꍇA0ȏ̒l.
 * 
 * \returns
 * }b`ȂꍇA-1.
 * 
 * URLImageViewURLReplace.dat̐K\ŌA}b``ꂽ[ɏ]ĉ摜擾pURL𐶐.
 * 
 */
int Cq2chwmImageViewUrlReplace::Match(
	const char *chp_url,
	Cq2chwmImageViewUrlReplaceMatch &cMatch)
{
	CString cstr_url;
	cstr_url = chp_url;
	return Match(cstr_url, cMatch);
}

/*!
 * \brief
 * 摜URL擾.
 * 
 * \param chp_url
 * URL.
 * 
 * \param cMatch
 * 摜擾pURLNX.
 * 
 * \returns
 * }b`ꍇA0ȏ̒l.
 * 
 * \returns
 * }b`ȂꍇA-1.
 * 
 * URLImageViewURLReplace.dat̐K\ŌA}b``ꂽ[ɏ]ĉ摜擾pURL𐶐.
 * 
 */
int Cq2chwmImageViewUrlReplace::Match(
	const wchar_t *wchp_url,
	Cq2chwmImageViewUrlReplaceMatch &cMatch)
{
	// 擪ɈʓIȉ摜URL`̂ŁAI[}b`Os
	for( int i = 0; i < Count(); i++) {
		//}b`Os
		// [][␳][t@][IvV][IvV]
		Cq2chwmImageViewUrlReplaceData *pData = GetData(i);
		if (pData->GetRegexSearch()->Match(wchp_url) >= 0) {
			CYoString str_referer = pData->GetReferer();
			switch(pData->GetOption()) {
			case Cq2chwmImageViewUrlReplaceData::COOKIE:
				{
					// 4$COOKIE
					// lԖڂ̈$COOKIEw肷ƎOԖڂ̈(t@[)Cookie擾A
					// YĒuURL摜̎擾݂܂B 

					// HTMLURL[t@][]K\NX琶
					CYoString str_url_html;
					ImageViewUrlReplace_replace(str_url_html, pData->GetReferer(), pData->GetRegexSearch());

					// HTML擾
					CYoString str_html;
					CYoString str_cookie;
					int in_ret = HttpGet(str_html, str_cookie, str_url_html, pData->GetRefererOption());
					if (in_ret == ERR_NONE) {
						// [␳][]K\NXA[HTMLp^[]K\NX摜擾URL𐶐
						CYoString str_url;
						ImageViewUrlReplace_replace(str_url, pData->GetVariable(), pData->GetRegexSearch());
						cMatch.SetUrl(str_url);

						// t@ɂHTMLURLg
						cMatch.SetReferer(str_url_html);

						// 摜擾̃NbL[HTML擾̒lƂ
						cMatch.SetCookie(str_cookie);
					}
					break;
				}
			case Cq2chwmImageViewUrlReplaceData::EXTRACT:
				{
					// 4$EXTRACT
					// lԖڂ̈$EXTRACTAܔԖڂ̈ɎOԖڂ̈URLŎ擾html̒g
					// 摜{̂̉ϕ擾鐳K\ĂB
					// 摜擾URL͓Ԗڂ̈$EXTRACT1`$EXTRACT9ܔԖڂ̈œɒûɂȂ܂B
					// (摜擾ۂ͎OԖڂ̈URLCookie擾AYĉ摜̎擾݂܂)
					// 
					// ܔԖڂ̈Ŕo镶͐K\̌QƂɑΉĂ܂B
					// LbVꂽ́AԖڂ̈$EXTRACT1`$EXTRACT9Ŏgpł܂B
					// $EXTRACT1`$EXTRACT9͐K\̌Q$1`$9ɑΉ܂B
					// $EXTRACT$EXTRACT1w肵ƌȂ܂B
					// 
					// $COOKIE={URL}/$EXTRACT={URL}ŁA$COOKIE/$EXTRACT̈ڂ̎擾{URL}t@Ƃđ܂B 

					// HTMLɑ΂ă}b`Op^[[HTMLp^[][]K\NX琶
					CYoString str_pattern;
					ImageViewUrlReplace_replace(str_pattern, pData->GetPatternExtract(), pData->GetRegexSearch());

					// HTMLURL[t@][]K\NX琶
					CYoString str_url_html;
					ImageViewUrlReplace_replace(str_url_html, pData->GetReferer(), pData->GetRegexSearch());

					// HTML擾
					CYoString str_html;
					CYoString str_cookie;
					int in_ret = HttpGet(str_html, str_cookie, str_url_html, pData->GetRefererOption());
					if (in_ret == ERR_NONE) {
						// [HTMLp^[]Ŏ擾HTML}b`O
						CYoRegex cRegex(str_pattern);
						if (cRegex.Match(str_html) >= 0) {
							// [␳][]K\NXA[HTML]K\NX摜擾URL𐶐
							CYoString str_url;
							ImageViewUrlReplace_replace(str_url, pData->GetVariable(), pData->GetRegexSearch(), &cRegex);
							cMatch.SetUrl(str_url);

							// t@ɂHTMLURLg
							cMatch.SetReferer(str_url_html);

							// 摜擾̃NbL[HTML擾̒lƂ
							cMatch.SetCookie(str_cookie);
						} else {
							return -1;
						}
					} else {
						return -1;
					}
					break;
				}
			default:
				{
					CYoString str_url;
					// [␳][]K\NX摜擾URL𐶐
					ImageViewUrlReplace_replace(str_url, pData->GetVariable(), pData->GetRegexSearch());
					cMatch.SetUrl(str_url);
					// [t@][]K\NX烊t@URL𐶐
					ImageViewUrlReplace_replace(str_url, pData->GetReferer(), pData->GetRegexSearch());
					cMatch.SetReferer(str_url);
					break;
				}
			}
			return i;
		}
	}
	return	-1;
}

/*!
 * \brief
 * K\̒uƃ}b`OʂpĒus.
 * 
 * \param str_out
 * u㕶.
 * 
 * \param chp_variable
 * ($1`$9A܂$EXTRACT1`$EXTRACT9WJAstr_outɃRs[).
 * 
 * \param pRegexSearch
 * []URLɑ΂ă}b`OK\NX(chp_variable$1`$9̓WJpɎgp).
 * 
 * \param pRegexExtract
 * [HTML][t@]URLŎ擾HTMLɑ΂ă}b`OK\NX(chp_variable$EXTRACT1`$EXTRACT9̓WJpɎgp).
 * 
 * \returns
 * I0.
 * 
 * chp_variable$1`$9pRegexSearchgpĒuB
 * ܂A$EXTRACT1`$EXTRACT9pRegexExtractgpĒuB.
 * 
 */
int Cq2chwmImageViewUrlReplace::ImageViewUrlReplace_replace(
	CYoString &str_out,
	const char *chp_variable,
	const CYoRegex *pRegexSearch,
	const CYoRegex *pRegexExtract)
{
	if (*chp_variable == 0x00 || pRegexSearch == NULL) return 0;
	const char METACHAR = '$';

	str_out = "";
	const char *chp_tmp = chp_variable;
	while (*chp_tmp != 0x00) {
		if (*chp_tmp == METACHAR) {
			if (*(chp_tmp + 1) == '\0') {
				//$ŏIB
				str_out += METACHAR;
				break;
			} else if (*(chp_tmp + 1) == METACHAR) {
				//$$ == $
				str_out += METACHAR;
				chp_tmp += 2;
			} else if (isdigit(*(chp_tmp + 1)) != 0 || *(chp_tmp + 1) == '&') {
				//$ + [0-9]
				chp_tmp++;
				int in_num;
				if (*chp_tmp == '&') {
					// $&$0Ɠ
					in_num = 0;
					chp_tmp++;
				} else {
					char *chp_end;
					in_num = strtol(chp_tmp, &chp_end, 10);
					chp_tmp = chp_end;
				}

				// pK\QƎ擾
				CString cstr_var;
				cstr_var = (const wchar_t*)pRegexSearch->Get(in_num);
				str_out += A(cstr_var);
			} else if (pRegexExtract != NULL && strncmp(chp_tmp + 1, "EXTRACT", 7) == 0) {
				chp_tmp += 8;
				if (isdigit(*chp_tmp) != 0) {
					CYoString str_var;
					str_var = pRegexExtract->Get(*chp_tmp - '0');
					str_out += str_var;
					chp_tmp += 1;
				} else {
					// $EXTRACT1Ɠ
					CYoString str_var;
					str_var = pRegexExtract->Get(1);
					str_out += str_var;
				}
			} else {
				//$ + [^0-9]
				//[^0-9]̕ǉĂ܂B
				str_out.StrnCat(chp_tmp, 2);
				chp_tmp += 2;
			}
		} else {
			str_out += *chp_tmp;
			chp_tmp++;
		}
	}

	return 0;
}

// 
/*!
 * \brief
 * URL擾ANbL[HTML擾.
 * 
 * \param str_html
 * 擾HTMLSĊi[.
 * 
 * \param str_cookie
 * MNbL[i[.
 * 
 * \param str_url
 * URL.
 * 
 * \param str_referer
 * URL擾̃t@.
 * 
 * \returns
 * IERR_NONE.
 * 
 * URLt@gpĎ擾A擾HTMLstr_htmlɊi[B
 * NbL[擾ꍇ́ANbL[str_cookieɊi[B
 * 
 * \remarks
 * HTTPX|XR[h302̏ꍇ́ALocationwb_URL1񂾂擾.
 * 
 */
int Cq2chwmImageViewUrlReplace::HttpGet(
	CYoString &str_html,
	CYoString &str_cookie,
	const char *chp_url,
	const char *chp_referer)
{
	CYoHttpClient cHttp(chp_url);
	cHttp.SetReferer(chp_referer);

	cHttp.SetUserAgent(Cq2chwmConfig::GetInstance()->GetUserAgent());
	if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
		cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
		cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass());
	}
	cHttp.SetCallbackProc(CMainFrame::CallbackProc, AfxGetMainWnd());

	if (cHttp.Connect(TIMEOUT) == FALSE) {
		return ERR_HTTP_CONNECT;
	}

	if (cHttp.Get() == FALSE) {
		return ERR_HTTP_GET;
	}

	if (cHttp.GetResultCode() == 302) {
		// 302ȂLocation擾
		CYoString str_url = cHttp.GetResponseHeader("Location");
		if (str_url.Length() > 0) {
			cHttp.SetUrl(str_url);
			if (cHttp.Connect(TIMEOUT) == FALSE) {
				return ERR_HTTP_CONNECT;
			}

			if (cHttp.Get() == FALSE) {
				return ERR_HTTP_GET;
			}
		}
	}

	if (cHttp.GetResultCode() < 200 || cHttp.GetResultCode() >= 300) {
		return ERR_HTTP_GET;
	}

	str_cookie = cHttp.GetResponseHeader("Set-Cookie");
	CYoString str_length = cHttp.GetResponseHeader("Content-Length");
	int in_length = str_length.Atoi();
	int in_recv = 0;
	int in_ret;
	char cha_buff[RECV_BUFF];
	while ((in_ret = cHttp.Recv(cha_buff, sizeof(cha_buff) - 1)) > 0) {
		cha_buff[in_ret] = 0x00;
		str_html += cha_buff;
		in_recv += in_ret;
		AfxGetMainWnd()->SendMessage(WM_USER_SETPROGRESS, cHttp.GetRecvSize(), in_length);
	}

	if (in_ret == 0 && ((CMainFrame*)AfxGetMainWnd())->Canceled() == TRUE) {
		return ERR_CANCELED;
	} else if (in_ret == SOCKET_ERROR) {
		return ERR_HTTP_RECV;
	}

	return ERR_NONE;
}
