#include "stdafx.h"
#include "YoFile.h"
#include "q2chwmArticleFile.h"
#include "q2chwmConfig.h"

#define PAT_ARTICLE		"\\(\"([0-9]*)\" :seen ([^ ]+) :access-time \\(([0-9]+) ([0-9]+) ([0-9]+)\\)"
enum{
	IDX_ARTICLE_ID = 0,
	IDX_ARTICLE_SEEN,
	IDX_ARTICLE_TIME,
};

// ÓIoϐ̏
/*
CYoPtrArray *Cq2chwmArticleFile::m_parray_cache = NULL;
int Cq2chwmArticleFile::m_in_cachesize = 0;
*/

Cq2chwmArticleFile::Cq2chwmArticleFile()
{
	static CYoRegex cRegex(PAT_ARTICLE);
	m_pRegex = &cRegex;
}

Cq2chwmArticleFile::~Cq2chwmArticleFile()
{
}

const char *Cq2chwmArticleFile::GetId(
	int in_idx )
{
	return Get(in_idx, IDX_ARTICLE_ID);
}

int Cq2chwmArticleFile::GetSeen(
	const char *chp_id )
{
	int in_idx = Search(chp_id);
	if (in_idx == -1) {
		return -1;
	}
	char *chp_seen = Get(in_idx, IDX_ARTICLE_SEEN);
	if (strcmp(chp_seen, "nil") == 0 || strcmp(chp_seen, "0") == 0) {
		return -1;
	}

	return atoi(chp_seen);
}

BOOL Cq2chwmArticleFile::SetSeen(
	const char *chp_id,
	int in_seen,
	BOOL bl_time)
{
	CYoString str_seen;
	str_seen = in_seen;

	int in_idx = Search(chp_id);
	if (in_idx == -1) {
		// IDȂ猻ݎŒǉ
		CYoString str_time;
		str_time = (int)time( NULL );
		Add(chp_id, (const char*)str_seen, (const char*)str_time, NULL );
	}
	if (Update( in_idx, IDX_ARTICLE_SEEN, str_seen ) == FALSE) {
		return FALSE;
	}
	if (bl_time == TRUE) {
		// access-timeݎŃAbvf[g
		return SetTime(chp_id);
	}

	return TRUE;
}

int Cq2chwmArticleFile::GetTime(
	const char *chp_id)
{
	int in_idx = Search(chp_id);
	if (in_idx == -1) {
		return -1;
	}
	return atoi(Get(in_idx,IDX_ARTICLE_TIME));
}

BOOL Cq2chwmArticleFile::SetTime(
	const char *chp_id,
	int in_time )
{
	int in_idx = Search(chp_id);
	if (in_idx == -1) {
		return FALSE;
	}

	CYoString str_time;
	if (in_time == -1) {
		str_time = (int)time( NULL );
	} else {
		str_time = in_time;
	}

	return Update(in_idx, IDX_ARTICLE_TIME, (const char*)str_time);
}

BOOL Cq2chwmArticleFile::Create(
	const char *chp_url)
{
	m_str_filename = UrlToPath(chp_url);
	m_str_filename += "\\article-summary";
	CYoTextFile cFile(m_str_filename, CYoFile::READ);
	if (cFile.Open() == FALSE) {
		return FALSE;
	}

	RemoveAll();
	CYoString str_line;
	while (cFile.Eof() == FALSE) {
		cFile.ReadLine(str_line);
		const char *chp_line = str_line;

		int in_start = 0;
		while (m_pRegex->Match(chp_line, in_start) >= 0) {
			m_str_id    = m_pRegex->Get(1);
			m_in_seen   = strcmp(m_pRegex->Get(2), "nil") ? atoi(m_pRegex->Get(2)) : 0;

			// current-timȅ(high low mil)
			// ~ZJh͔Ή
			int in_high = atoi( m_pRegex->Get(3) );
			int in_low  = atoi( m_pRegex->Get(4) );
			m_in_time   = in_high << 16;
			m_in_time  |= in_low & 0xffff;

			// e[uɊi[
			CYoString str_seen;
			CYoString str_time;
			str_seen = m_in_seen;
			str_time = m_in_time;
			Add((const char*)m_str_id, (const char*)str_seen, (const char*)str_time, NULL);

			in_start = m_pRegex->GetEnd();
		}
	}
	cFile.Close();

	return TRUE;
}

int Cq2chwmArticleFile::Search(
	const char *chp_key)
{
	return CYoTable::Search(chp_key, IDX_ARTICLE_ID);
}

#define HEADER	"("
#define FOOTER	")"
#define FORMAT	"(\"%s\" :seen %d :access-time (%d %d %d))"
BOOL Cq2chwmArticleFile::Write()
{
	if (m_str_filename.Length() == 0) return FALSE;

	CFile cFile;
	CString cstr_filename;
	cstr_filename = m_str_filename;
	if (cFile.Open(cstr_filename, CFile::modeWrite|CFile::modeCreate) == FALSE) {
		return FALSE;
	}
	cFile.Write(HEADER, strlen(HEADER));

	for( int i = 0; i < Rows(); i++ ){
		const char *chp_id = GetId( i );
		int  in_seen = GetSeen( chp_id );
		int in_time  = GetTime( chp_id );
		unsigned short us_high = (in_time>>16) & 0xffff;
		unsigned short us_low  = (in_time    ) & 0xffff;
		CYoString str_fmt;

		str_fmt.Format(FORMAT, chp_id, in_seen, us_high, us_low, 0);
		cFile.Write((const char*)str_fmt, str_fmt.Length());
	}

	cFile.Write( FOOTER, strlen(FOOTER) );
	cFile.Close();
	return TRUE;
}

void Cq2chwmArticleFile::AddArticle(
	Cq2chwmArticleFile &cFile)
{
	for (int i = 0; i < cFile.Rows(); i++) {
		if (Search(cFile.Get(i, IDX_ARTICLE_ID)) < 0) {
			Add(cFile.Get(i, IDX_ARTICLE_ID), cFile.Get(i, IDX_ARTICLE_SEEN), cFile.Get(i, IDX_ARTICLE_TIME), NULL);
		}
	}
}
