#include "stdafx.h"
#include "YoRegex.h"
#include "q2chwmCommon.h"
#include "q2chwmBbsSubject.h"

Cq2chwmBbsSubjectManager::Cq2chwmBbsSubjectManager(
	const char *chp_url)
{
	CYoRegex cRegex;
	if (cRegex.Match("([^/.]+)\\.machibbs\\.com.*|([^/.]+)\\.machi\\.to.*", chp_url) >= 0) {
		m_pBbsSubject = new Cq2chwmBbsSubjectMachi();
	} else if (cRegex.Match("jbbs\\.livedoor\\.jp.*", chp_url) >= 0) {
		m_pBbsSubject = new Cq2chwmBbsSubjectLivedoor();
	} else {
		m_pBbsSubject = new Cq2chwmBbsSubject();
	}
}

Cq2chwmBbsSubjectManager::~Cq2chwmBbsSubjectManager()
{
	if (m_pBbsSubject != NULL) delete m_pBbsSubject;
}

Cq2chwmBbsSubject::Cq2chwmBbsSubject()
{
	m_chp_aid = NULL;
	m_chp_aname = NULL;
	m_chp_count = NULL;
	m_chp_bname = NULL;
	m_chp_burl = NULL;
}

Cq2chwmBbsSubject::~Cq2chwmBbsSubject()
{
}

/*!
 * \brief
 * subject.txt1sp[X.
 * chp_line͊eڂƂ\0ŋ؂(const char*łȂƂɒ)
 *
 * \param chp_line
 * subject.txt̍s.
 * 
 * \returns
 * I: ERR_NONE ُI: ERR_NONEȊO.
 * 
 */
BOOL Cq2chwmBbsSubject::Parse(
	char *chp_line)
{
	// K\gȂ(K\ł1/4炢̏xōς)
	{
		char *chp_aid;
		char *chp_aname;
		char *chp_count;
		char *chp_tmp;
		char *chp_tmp_terminate = NULL;

		// ID擾
		chp_aid = (char*)chp_line;
		chp_tmp = strchr(chp_line, '.');
		if (chp_tmp == NULL) return FALSE;
		*chp_tmp = 0x00;

		// Xbh擾
		chp_tmp++;
		chp_aname = strchr(chp_tmp, '>');
		if (chp_aname == NULL) return FALSE;
		chp_aname++;

		// Q˂錟gtH[}bg̏ꍇA()܂܂邱Ƃ邽߃XbhŌ<Ő؂
		chp_tmp_terminate = strchr(chp_aname, '<');
		if (chp_tmp_terminate != NULL) *chp_tmp_terminate = 0x00;

		chp_tmp = strrchr(chp_aname, '(');
		if (chp_tmp == NULL) return FALSE;
		*chp_tmp = 0x00;
		if (*(chp_tmp - 1) == ' ') *(chp_tmp - 1) = 0x00;

		// JEg擾
		chp_count = chp_tmp + 1;
		chp_tmp = strchr(chp_count, ')');
		if (chp_tmp == NULL) return FALSE;
		*chp_tmp = 0x00;

		if (chp_tmp_terminate != NULL) {
			chp_tmp = chp_tmp_terminate + 1;
		} else {
			chp_tmp++;
		}

		// oϐɃZbg
		SetArticleName(chp_aname);
		SetArticleId(chp_aid);
		SetCount(chp_count);

		if (*chp_tmp != 0x00) {
			// Q˂錟gtH[}bg
			char *chp_bname;
			char *chp_burl;

			// URL擾
			chp_burl = strchr(chp_tmp, '>');
			if (chp_burl == NULL) return FALSE;
			chp_burl++;
			chp_tmp = strchr(chp_burl, '<');
			if (chp_tmp == NULL) return FALSE;
			*chp_tmp = 0x00;

			// 擾
			chp_tmp++;
			chp_bname = strchr(chp_tmp, '>');
			if (chp_bname == NULL) return FALSE;
			chp_bname++;

			// ID擾
			{
				char *chp_sta = strstr(chp_burl, "://");
				if (chp_sta == NULL) return FALSE;
				chp_sta += 3;
				chp_sta = strchr(chp_sta, '/');
				if (chp_sta == NULL) return FALSE;
				chp_sta++;
				char *chp_end = strrchr(chp_sta, '/');
				if (chp_end == NULL) return FALSE;
				CYoString str_bid;
				str_bid.StrnCpy(chp_sta, chp_end - chp_sta);
				SetBoardId(str_bid);
			}

			// AURLoϐɃZbg
			SetBoardName(chp_bname);
			SetBoardUrl(chp_burl);
		}
	}

	/* K\
	{
		static CYoRegex cRegex("^(([0-9]+)\\..+)<>(.+) \\(([0-9]+)\\)", CYoRegex::SJIS);
		static CYoRegex cRegexEx("<>(.+?)<>(.+)$", CYoRegex::SJIS);
		if (cRegex.Match(cha_buff) >= 0) {
			CYoString str_tmp_aid = cRegex.Get(2);
			CYoString str_tmp_aname = cRegex.Get(3);
			str_tmp_aname.Trim();
			CYoString str_tmp_count = cRegex.Get(4);
			CYoString str_tmp_bname = str_bname;
			CYoString str_tmp_burl = str_burl;
			// ʏtH[}bg
			if (cRegexEx.Match(cha_buff, strlen(cRegex.Get(0))) >= 0) {
				// Q˂錟gtH[}bg
				str_tmp_bname = cRegexEx.Get(2);
				str_tmp_burl = cRegexEx.Get(1);
			}
			Cq2chwmSubjectItem *pItem = new Cq2chwmSubjectItem(in_index, str_tmp_aname, str_tmp_aid, str_tmp_bname, str_tmp_burl, str_tmp_count);
			Add(pItem);
		} else {
			// tH[}bgG[
			return ERR_FILE_FORMAT;
		}
	}
	*/
	return TRUE;
}

/*
 * [ID].cgi,[X^C]([JEg])
 */
BOOL Cq2chwmBbsSubjectMachi::Parse(
	char *chp_line)
{
	char *chp_aid;
	char *chp_aname;
	char *chp_count;
	char *chp_tmp;

	// ID擾
	chp_aid = chp_line;
	chp_tmp = strchr(chp_aid, '.');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// Xbh擾
	chp_tmp++;
	chp_tmp = strchr(chp_tmp, ',');
	if (chp_tmp == NULL) return FALSE;
	chp_tmp++;
	chp_aname = chp_tmp;
	chp_tmp = strrchr(chp_aname, '(');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// JEg擾
	chp_tmp++;
	chp_count = chp_tmp;
	chp_tmp = strrchr(chp_count, ')');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// oϐɃZbg
	SetArticleId(chp_aid);
	SetArticleName(chp_aname);
	SetCount(chp_count);

	return TRUE;
}

/*
 * [ID].cgi,[X^C]([JEg])
 */
BOOL Cq2chwmBbsSubjectLivedoor::Parse(
	char *chp_line)
{
	char *chp_aid;
	char *chp_aname;
	char *chp_count;
	char *chp_tmp;

	// ID擾
	chp_aid = chp_line;
	chp_tmp = strchr(chp_aid, '.');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// Xbh擾
	chp_tmp++;
	chp_tmp = strchr(chp_tmp, ',');
	if (chp_tmp == NULL) return FALSE;
	chp_tmp++;
	chp_aname = chp_tmp;
	chp_tmp = strrchr(chp_aname, '(');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// JEg擾
	chp_tmp++;
	chp_count = chp_tmp;
	chp_tmp = strrchr(chp_count, ')');
	if (chp_tmp == NULL) return FALSE;
	*chp_tmp = 0x00;

	// oϐɃZbg
	m_str_aname = chp_aname;
	m_str_aname.ConvertKCodeEx(CYoString::EUCTOSJIS);
	SetArticleId(chp_aid);
	SetArticleName(m_str_aname);
	SetCount(chp_count);

	return TRUE;
}
