#pragma once

#include "YoTable.h"

class Cq2chwmBoardFile : public CYoTable
{
protected:
	CYoString m_str_filename;

public:
	Cq2chwmBoardFile(const char *chp_filename = NULL);
	virtual ~Cq2chwmBoardFile();

	int CreateFromFile();
	int CreateFromHttp(const char *chp_url);
	inline const char *GetName(int in_row){ return Get(in_row, 0); }
	inline const char *GetUrl(int in_row){ return Get(in_row, 1); }
	inline const char *GetId(int in_row){ return Get(in_row, 2); }
	inline const char *GetFileName(){ return m_str_filename; }
	BOOL Exist();
	int Write();
	int SearchFromUrl(const char *chp_url);
	int SearchFromId(const char *chp_id);
	void AddBoard(const char *chp_name, const char *chp_url, const char *chp_id);
};

class Cq2chwmBoardFileEtc : public Cq2chwmBoardFile
{
public:
	Cq2chwmBoardFileEtc();
};

