// q2chwmCacheView.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmCacheView.h"
#include "q2chwmConfig.h"
#include "q2chwmDatFile.h"

// Cq2chwmCacheView

//IMPLEMENT_DYNCREATE(Cq2chwmCacheView, Cq2chwmListView)

Cq2chwmCacheView::Cq2chwmCacheView()
{

}

Cq2chwmCacheView::~Cq2chwmCacheView()
{
}

BEGIN_MESSAGE_MAP(Cq2chwmCacheView, Cq2chwmListView)
	ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_DELETE, &Cq2chwmCacheView::OnDelete)
	ON_COMMAND(ID_ADDBOOKMARK, &Cq2chwmCacheView::OnAddbookmark)
	ON_COMMAND(ID_SORT_ANAME, &Cq2chwmCacheView::OnSortAname)
	ON_UPDATE_COMMAND_UI(ID_SORT_ANAME, &Cq2chwmCacheView::OnUpdateSortAname)
	ON_COMMAND(ID_SORT_BNAME, &Cq2chwmCacheView::OnSortBname)
	ON_UPDATE_COMMAND_UI(ID_SORT_BNAME, &Cq2chwmCacheView::OnUpdateSortBname)
	ON_COMMAND(ID_SORT_DATE, &Cq2chwmCacheView::OnSortDate)
	ON_UPDATE_COMMAND_UI(ID_SORT_DATE, &Cq2chwmCacheView::OnUpdateSortDate)
	ON_COMMAND(ID_SORT_INDEX, &Cq2chwmCacheView::OnSortIndex)
	ON_UPDATE_COMMAND_UI(ID_SORT_INDEX, &Cq2chwmCacheView::OnUpdateSortIndex)
	ON_COMMAND(ID_SORT_SEARCH, &Cq2chwmCacheView::OnSortSearch)
	ON_UPDATE_COMMAND_UI(ID_SORT_SEARCH, &Cq2chwmCacheView::OnUpdateSortSearch)
	ON_WM_SHOWWINDOW()
END_MESSAGE_MAP()


// Cq2chwmCacheView ff

#ifdef _DEBUG
void Cq2chwmCacheView::AssertValid() const
{
	Cq2chwmListView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmCacheView::Dump(CDumpContext& dc) const
{
	Cq2chwmListView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmCacheView bZ[W nh
BOOL Cq2chwmCacheView::CreateList()
{
	// \[gԂۑ
	Cq2chwmConfig::GetInstance()->SetSortColumnCache(GetSortColumn());
	Cq2chwmConfig::GetInstance()->SetSortAscCache(GetSortAsc());

	m_cCacheFile.RemoveAll();
	m_cCacheFile.Create();
	GetListCtrl().SetItemCountEx(m_cCacheFile.Count());
	SortItems(Cq2chwmConfig::GetInstance()->GetSortColumnCache(),
		Cq2chwmConfig::GetInstance()->GetSortAscCache());
	GoTop();
	return TRUE;
}

void Cq2chwmCacheView::OnInitialUpdate()
{
	Cq2chwmListView::OnInitialUpdate();

	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetListCtrl().InsertColumn(0, _T("No"));
	GetListCtrl().InsertColumn(1, _T("Xbh"));
	GetListCtrl().InsertColumn(2, _T(""));
	GetListCtrl().InsertColumn(3, _T("XV"));
	if (Cq2chwmConfig::GetInstance()->GetColumnWidthCacheCount() == 0) {
		GetListCtrl().SetColumnWidth(0, 100);
		GetListCtrl().SetColumnWidth(1, 300);
		GetListCtrl().SetColumnWidth(2, 200);
		GetListCtrl().SetColumnWidth(3, 100);
	} else {
		GetListCtrl().SetColumnWidth(0, Cq2chwmConfig::GetInstance()->GetColumnWidthCache(0));
		GetListCtrl().SetColumnWidth(1, Cq2chwmConfig::GetInstance()->GetColumnWidthCache(1));
		GetListCtrl().SetColumnWidth(2, Cq2chwmConfig::GetInstance()->GetColumnWidthCache(2));
		GetListCtrl().SetColumnWidth(3, Cq2chwmConfig::GetInstance()->GetColumnWidthCache(3));
	}
	SetFont();
	SetSortColumn(Cq2chwmConfig::GetInstance()->GetSortColumnCache());
	SetSortAsc(Cq2chwmConfig::GetInstance()->GetSortAscCache());
}

void Cq2chwmCacheView::SetFont()
{
	Cq2chwmListView::SetFont(Cq2chwmConfig::GetInstance()->GetFontNameCache(), Cq2chwmConfig::GetInstance()->GetFontSizeCache());
}

void Cq2chwmCacheView::OnDestroy()
{
	CYoPtrArray cArray;
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(0));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(1));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(2));
	cArray.Add((const void*)GetListCtrl().GetColumnWidth(3));
	Cq2chwmConfig::GetInstance()->SetColumnWidthCache(cArray);
	Cq2chwmConfig::GetInstance()->SetSortColumnCache(GetSortColumn());
	Cq2chwmConfig::GetInstance()->SetSortAscCache(GetSortAsc());
	m_cCacheFile.RemoveAll();
	Cq2chwmListView::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
}

void Cq2chwmCacheView::OnListClicked()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return;
	Cq2chwmCacheItem *pItem = m_cCacheFile.GetItem((int)pos - 1);
	if (pItem == NULL) return;
	GetParent()->SendMessage(WM_USER_CACHECLICKED, 0, (LPARAM)pItem);
}

void Cq2chwmCacheView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if (nChar == Cq2chwmConfig::GetInstance()->GetKeyDelete()) {
		Delete();
		return;
	} else if (nChar == Cq2chwmConfig::GetInstance()->GetKeySort()) {
		Sort();
		return;
	} else if (nChar == Cq2chwmConfig::GetInstance()->GetKeyAddBookmark()) {
		AddBookmark();
		return;
	}

	Cq2chwmListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void Cq2chwmCacheView::AddBookmark()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return;
	if (::MessageBox(m_hWnd, _T("ubN}[Nɒǉ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		Cq2chwmCacheItem *pItem = m_cCacheFile.GetItem((int)pos - 1);
		if (pItem == NULL) return;
		Cq2chwmBookmarkItem cBookmarkItem(1, pItem->GetArticleName(), pItem->GetArticleId(), pItem->GetBoardName(), pItem->GetBoardId(), pItem->GetBoardUrl());
		GetParent()->SendMessage(WM_USER_ADDBOOKMARK, 0, (LPARAM)&cBookmarkItem);
		InvalidateRect(NULL);
		UpdateWindow();
	}
}

void Cq2chwmCacheView::Delete()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return;
	Cq2chwmCacheItem *pItem = m_cCacheFile.GetItem((int)pos - 1);
	if (pItem == NULL) return;
	if (::MessageBox(m_hWnd, _T("폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		if (Cq2chwmDatFile::Delete(pItem->GetBoardUrl(), pItem->GetArticleId()) == TRUE) {
			m_cCacheFile.Remove((int)pos - 1);
		}
		GetListCtrl().SetItemCountEx(m_cCacheFile.Count());
		InvalidateRect(NULL);
		UpdateWindow();
	}
}

void Cq2chwmCacheView::OnDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Delete();
}

void Cq2chwmCacheView::Sort()
{
	int in_col = GetSortColumn();
	if (in_col == Cq2chwmCacheFile::IDX_SEARCH) {
		in_col = Cq2chwmCacheFile::IDX_INDEX;
	} else {
		in_col++;
	}
	SortItems(in_col, TRUE);
}

void Cq2chwmCacheView::SortItems(
	int in_col,
	BOOL bo_asc)
{
	// \[gsƂ^Cgo[ς
	/*
	CString cstr_title = _T("LbV");
	switch (in_col) {
	case Cq2chwmCacheFile::IDX_INDEX:
		cstr_title += _T("[No]");
		break;
	case Cq2chwmCacheFile::IDX_ANAME:
		cstr_title += _T("[Xbh]");
		break;
	case Cq2chwmCacheFile::IDX_BNAME:
		cstr_title += _T("[]");
		break;
	case Cq2chwmCacheFile::IDX_DATE:
		cstr_title += _T("[XV]");
		break;
	case Cq2chwmCacheFile::IDX_SEARCH:
		cstr_title += _T("[]");
		break;
	};
	AfxGetMainWnd()->SetWindowText(cstr_title);
	*/

	m_cCacheFile.Sort(in_col, bo_asc);
	RedrawWindow();
	SetSortColumn(in_col);
	SetSortAsc(bo_asc);
}

void Cq2chwmCacheView::Search(
	const char *chp_word)
{
	CYoRegex cRegex(chp_word, CYoRegex::SJIS, TRUE);
	for (int i = 0; i < m_cCacheFile.Count(); i++) {
		Cq2chwmCacheItem *pItem = (Cq2chwmCacheItem*)m_cCacheFile.GetItem(i);
		if (cRegex.Match(pItem->GetArticleName()) >= 0) {
			pItem->SetSearch(TRUE);
		} else {
			pItem->SetSearch(FALSE);
		}
	}

	// []Ń\[g
	SortItems(Cq2chwmCacheFile::IDX_SEARCH, TRUE);
}

void Cq2chwmCacheView::OnAddbookmark()
{
	// TODO: ɃR}h nh R[hǉ܂B
	AddBookmark();
}

BOOL Cq2chwmCacheView::GetItemText(
	LPTSTR wchp_text,
	int in_size,
	int in_row,
	int in_col)
{
	Cq2chwmCacheItem *pItem = m_cCacheFile.GetItem(in_row);
	if (pItem == NULL) return FALSE;
	CString cstr_tmp;
	switch (in_col) {
	case Cq2chwmCacheFile::IDX_INDEX:
		cstr_tmp.Format(_T("%d"), pItem->GetIndex());
		break;
	case Cq2chwmCacheFile::IDX_ANAME:
		cstr_tmp = pItem->GetArticleName();
		break;
	case Cq2chwmCacheFile::IDX_BNAME:
		cstr_tmp = pItem->GetBoardName();
		break;
	case Cq2chwmCacheFile::IDX_DATE:
		cstr_tmp = pItem->GetDate();
		break;
	};
	_tcscpy_s(wchp_text, in_size, cstr_tmp);
	return TRUE;
}

Cq2chwmListItem *Cq2chwmCacheView::GetSelectedItem()
{
	POSITION pos = GetListCtrl().GetFirstSelectedItemPosition();
	if ((int)pos == -1) return NULL;
	return m_cCacheFile.GetItem((int)pos - 1);
}

Cq2chwmListItem *Cq2chwmCacheView::GetItem(
	int iRow)
{
	return m_cCacheFile.GetItem(iRow);
}

void Cq2chwmCacheView::OnSortAname()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmCacheFile::IDX_ANAME, TRUE);
}

void Cq2chwmCacheView::OnUpdateSortAname(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmCacheFile::IDX_ANAME);
}

void Cq2chwmCacheView::OnSortBname()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmCacheFile::IDX_BNAME, TRUE);
}

void Cq2chwmCacheView::OnUpdateSortBname(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmCacheFile::IDX_BNAME);
}

void Cq2chwmCacheView::OnSortDate()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmCacheFile::IDX_DATE, FALSE);
}

void Cq2chwmCacheView::OnUpdateSortDate(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmCacheFile::IDX_DATE);
}

void Cq2chwmCacheView::OnSortIndex()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmCacheFile::IDX_INDEX, TRUE);
}

void Cq2chwmCacheView::OnUpdateSortIndex(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmCacheFile::IDX_INDEX);
}

void Cq2chwmCacheView::OnSortSearch()
{
	// TODO: ɃR}h nh R[hǉ܂B
	SortItems(Cq2chwmCacheFile::IDX_SEARCH, TRUE);
}

void Cq2chwmCacheView::OnUpdateSortSearch(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(GetSortColumn() == Cq2chwmCacheFile::IDX_SEARCH);
}

void Cq2chwmCacheView::OnShowWindow(BOOL bShow, UINT nStatus)
{
	Cq2chwmListView::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (bShow == FALSE) {
		// LbV͖蒼Ȃ̂Ŕ\CxgŃ\[gۑĂ
		Cq2chwmConfig::GetInstance()->SetSortColumnCache(GetSortColumn());
		Cq2chwmConfig::GetInstance()->SetSortAscCache(GetSortAsc());
	}
}
