#include "stdafx.h"
#include "q2chwmConfig.h"
#include "YoConfig.h"

// VXe
#define DEF_ROOTDIR		"\\.navi2ch"
#define DEF_BOARDURL	"http://menu.2ch.net/bbsmenu.html"
#define DEF_BROWSER		"iexplore.exe"
#define DEF_THREADMAX	8
#define DEF_TABMAX		4
#define DEF_TABWIDTH	300
#define DEF_ONLINE		0
#define DEF_DEBUG		0

// tHg
#define DEF_FONTNAME	"lr oSVbN"
#define DEF_FONTSIZE	8

// fUC
#define DEF_COLOR_FORE			RGB(0x00, 0x00, 0x00)
#define DEF_COLOR_BACK			RGB(0xff, 0xff, 0xff)
#define DEF_COLOR_CACHE			RGB(0x99, 0x99, 0x99)
#define DEF_COLOR_NEW			RGB(0xff, 0xff, 0xff)
#define DEF_COLOR_ERROR			RGB(0x99, 0x99, 0x99)
#define DEF_COLOR_SEARCH		RGB(0x00, 0x00, 0xff)
#define DEF_COLOR_ACTIVE		RGB(0xff, 0x00, 0x00)
#define DEF_COLOR_FROM			RGB(0x00 ,0x80, 0x00)
#define DEF_COLOR_FROMWITHMAIL	RGB(0xff, 0x00, 0x00)
#define DEF_COLOR_FROMWITHSAGE	RGB(0x00, 0x00, 0xff)
#define DEF_COLOR_DATE			RGB(0x00, 0x00, 0x00)
#define DEF_COLOR_DATENEW		RGB(0xff, 0x00, 0x00)
#define DEF_COLOR_MESSAGE		RGB(0x66, 0x66, 0x66)
#define DEF_COLOR_LINK			RGB(0x00, 0x00, 0xff)
#define DEF_COLOR_ABONE			RGB(0xcc, 0xcc, 0xcc)

// L[
#define DEF_KEY_CANCEL			VK_ESCAPE
#define DEF_KEY_ONLINE			'T'
#define DEF_KEY_RELOAD			'R'
#define DEF_KEY_DELETE			'D'
#define DEF_KEY_SEARCH			'S'
#define DEF_KEY_TOP				'P'
#define DEF_KEY_BOTTOM			'N'
#define DEF_KEY_CLOSETAB		'Q'
#define DEF_KEY_NEXT			VK_RIGHT
#define DEF_KEY_PREV			VK_LEFT
#define DEF_KEY_NEXTLINK		VK_TAB
#define DEF_KEY_PREVLINK		0
#define DEF_KEY_MENU			VK_SPACE
#define DEF_KEY_NEXTTAB			'F'
#define DEF_KEY_PREVTAB			'B'
#define DEF_KEY_BACK			VK_BACK
#define DEF_KEY_ADDBOOKMARK		'A'
#define DEF_KEY_OPENBOOKMARK	'O'
#define DEF_KEY_SORT			VK_TAB
#define DEF_KEY_EDIT			'E'
#define DEF_KEY_EDITREPLY		'W'
#define DEF_KEY_FIND2CH			0
#define DEF_KEY_NEXTLINE		VK_DOWN
#define DEF_KEY_PREVLINE		VK_UP

// conft@Cǂݏ}N
#define WRITESTRING(name, value) CYoConfig::WriteString(m_str_filename, name, value);
#define WRITEINT(name, value) CYoConfig::WriteInt(m_str_filename, name, value);
#define WRITESTRINGARRAY(name, value) { \
	CYoConfig::RemoveEntry(m_str_filename, name); \
	CYoConfig::WriteStringArray(value, m_str_filename, name); \
}
#define WRITEINTARRAY(name, value) { \
	CYoConfig::RemoveEntry(m_str_filename, name); \
	CYoConfig::WriteIntArray(value, m_str_filename, name); \
}
#define READSTRING(var, name, value) { \
	var = CYoConfig::ReadString(m_str_filename, name); \
	if (var.Length() == 0) { \
		var = value; \
	} \
}
#define READINT(var, name, value) { \
	if (CYoConfig::ExistEntry(m_str_filename, name) == TRUE) { \
		var = CYoConfig::ReadInt(m_str_filename, name); \
	} else { \
		var = value; \
	} \
}
#define READSTRINGARRAY(var, name) CYoConfig::ReadStringArray(var, m_str_filename, name);
#define READINTARRAY(var, name) CYoConfig::ReadIntArray(var, m_str_filename, name);

Cq2chwmConfig::Cq2chwmConfig(
	const char *chp_filename)
{
	m_str_filename = chp_filename;

	// VXe
	READSTRING(RootDirectory, CONF_ROOTDIR, "");
	if (RootDirectory == "") {
		// ݒ莞init@CƓfBNg.navi2chfBNgƂ
		const char *chp_tmp = strrchr(chp_filename, '\\');
		if (chp_tmp != NULL) {
			RootDirectory.StrnCpy(chp_filename, chp_tmp - chp_filename);
		}
		RootDirectory += DEF_ROOTDIR;
	}
	// [gfBNg͗OIɏI['\'폜
	while (RootDirectory.Right(1) == "\\") {
		RootDirectory.Remove(RootDirectory.Length() - 1);
	}
	READSTRING(BoardUrl, CONF_BOARDURL, DEF_BOARDURL);
	READSTRING(Browser, CONF_BROWSER, DEF_BROWSER);
	READINT(ThreadMax, CONF_THREADMAX, DEF_THREADMAX);
	READINT(TabMax, CONF_TABMAX, DEF_TABMAX);
	READINT(TabWidth, CONF_TABWIDTH, DEF_TABWIDTH);
	READINT(Online, CONF_ONLINE, DEF_ONLINE);
	READINT(Debug, CONF_DEBUG, DEF_DEBUG);

	// tHg
	READSTRING(FontNameList, CONF_FONTNAME_LIST, DEF_FONTNAME);
	READSTRING(FontNameBoard, CONF_FONTNAME_BOARD, DEF_FONTNAME);
	READSTRING(FontNameMessage, CONF_FONTNAME_MESSAGE, DEF_FONTNAME);
	READSTRING(FontNameCache, CONF_FONTNAME_CACHE, DEF_FONTNAME);
	READSTRING(FontNameBookmark, CONF_FONTNAME_BOOKMARK, DEF_FONTNAME);
	READSTRING(FontNameTab, CONF_FONTNAME_TAB, DEF_FONTNAME);
	READSTRING(FontNameArticle, CONF_FONTNAME_ARTICLE, DEF_FONTNAME);
	READINT(FontSizeList, CONF_FONTSIZE_LIST, DEF_FONTSIZE);
	READINT(FontSizeBoard, CONF_FONTSIZE_BOARD, DEF_FONTSIZE);
	READINT(FontSizeMessage, CONF_FONTSIZE_MESSAGE, DEF_FONTSIZE);
	READINT(FontSizeCache, CONF_FONTSIZE_CACHE, DEF_FONTSIZE);
	READINT(FontSizeBookmark, CONF_FONTSIZE_BOOKMARK, DEF_FONTSIZE);
	READINT(FontSizeTab, CONF_FONTSIZE_TAB, DEF_FONTSIZE);
	READINT(FontSizeArticle, CONF_FONTSIZE_ARTICLE, DEF_FONTSIZE);

	// F
	READINT(ColorFore, CONF_COLOR_FORE, DEF_COLOR_FORE);
	READINT(ColorBack, CONF_COLOR_BACK, DEF_COLOR_BACK);
	READINT(ColorCache, CONF_COLOR_CACHE, DEF_COLOR_CACHE);
	READINT(ColorNew, CONF_COLOR_NEW, DEF_COLOR_NEW);
	READINT(ColorError, CONF_COLOR_ERROR, DEF_COLOR_ERROR);
	READINT(ColorSearch, CONF_COLOR_SEARCH, DEF_COLOR_SEARCH);
	READINT(ColorActive, CONF_COLOR_ACTIVE, DEF_COLOR_ACTIVE);
	READINT(ColorFrom, CONF_COLOR_FROM, DEF_COLOR_FROM);
	READINT(ColorFromWithMail, CONF_COLOR_FROMWITHMAIL, DEF_COLOR_FROMWITHMAIL);
	READINT(ColorFromWithSage, CONF_COLOR_FROMWITHSAGE, DEF_COLOR_FROMWITHSAGE);
	READINT(ColorDate, CONF_COLOR_DATE, DEF_COLOR_DATE);
	READINT(ColorDateNew, CONF_COLOR_DATENEW, DEF_COLOR_DATENEW);
	READINT(ColorMessage, CONF_COLOR_MESSAGE, DEF_COLOR_MESSAGE);
	READINT(ColorLink, CONF_COLOR_LINK, DEF_COLOR_LINK);
	READINT(ColorAbone, CONF_COLOR_ABONE, DEF_COLOR_ABONE);

	// lbg[N
	READSTRING(ProxyHost, CONF_PROXY_HOST, "");
	READINT(ProxyPort, CONF_PROXY_PORT, 8080);
	READSTRING(ProxyId, CONF_PROXY_ID, "");
	READSTRING(ProxyPass, CONF_PROXY_PASS, "");
	READSTRING(DoLibId, CONF_DOLIB_ID, "");
	READSTRING(DoLibPass, CONF_DOLIB_PASS, "");
	READINT(ProxyUse, CONF_PROXY_USE, 0);
	READINT(ProxyUseWrite, CONF_PROXY_USEWRITE, 0);
	READINT(Sage, CONF_SAGE, 1);

	// L[
	readKeyConf();

	// n
	READSTRINGARRAY(HistoryName, CONF_HISTORY_NAME);
	READSTRINGARRAY(HistoryMail, CONF_HISTORY_MAIL);
	READSTRINGARRAY(HistorySearchWord, CONF_HISTORY_SEARCHWORD);

	// J
	READINTARRAY(ColumnWidthSubject, CONF_COLUMNWIDTH_SUBJECT);
	READINTARRAY(ColumnWidthCache, CONF_COLUMNWIDTH_CACHE);
	READINTARRAY(ColumnWidthBookmark, CONF_COLUMNWIDTH_BOOKMARK);

	// \[g
	READINT(SortColumnBookmark, CONF_SORTCOLUMN_BOOKMARK, 0);
	READINT(SortColumnSubject, CONF_SORTCOLUMN_SUBJECT, 0);
	READINT(SortColumnCache, CONF_SORTCOLUMN_CACHE, 0);
	READINT(SortAscBookmark, CONF_SORTASC_BOOKMARK, 1);
	READINT(SortAscSubject, CONF_SORTASC_SUBJECT, TRUE);
	READINT(SortAscCache, CONF_SORTASC_CACHE, TRUE);
}

Cq2chwmConfig::~Cq2chwmConfig()
{
}

Cq2chwmConfig *Cq2chwmConfig::m_pInstance = NULL;
Cq2chwmConfig *Cq2chwmConfig::GetInstance()
{
	if (m_pInstance == NULL) {
		CWinApp *pApp = AfxGetApp();
		CYoString str_filename = A(pApp->m_pszProfileName);
		m_pInstance = new Cq2chwmConfig(str_filename);
		atexit(Cq2chwmConfig::Delete);
	}

	return m_pInstance;
}

void Cq2chwmConfig::Delete()
{
	if (m_pInstance != NULL) delete m_pInstance;
}

void Cq2chwmConfig::write(
	const char *chp_name,
	const char *chp_value)
{
	WRITESTRING(chp_name, chp_value);
}

void Cq2chwmConfig::write(
	const char *chp_name,
	int in_value)
{
	WRITEINT(chp_name, in_value);
}

void Cq2chwmConfig::write(
	const char *chp_name,
	CYoDataArray& cArray)
{
	WRITESTRINGARRAY(chp_name, cArray);
}

void Cq2chwmConfig::write(
	const char *chp_name,
	CYoPtrArray& cArray)
{
	WRITEINTARRAY(chp_name, cArray);
}

void Cq2chwmConfig::readKeyConf()
{
	READINT(KeyCancel, CONF_KEY_CANCEL, DEF_KEY_CANCEL);
	READINT(KeyOnline, CONF_KEY_ONLINE, DEF_KEY_ONLINE);
	READINT(KeyReload, CONF_KEY_RELOAD, DEF_KEY_RELOAD);
	READINT(KeyDelete, CONF_KEY_DELETE, DEF_KEY_DELETE);
	READINT(KeySearch, CONF_KEY_SEARCH, DEF_KEY_SEARCH);
	READINT(KeyTop, CONF_KEY_TOP, DEF_KEY_TOP);
	READINT(KeyBottom, CONF_KEY_BOTTOM, DEF_KEY_BOTTOM);
	READINT(KeyCloseTab, CONF_KEY_CLOSETAB, DEF_KEY_CLOSETAB);
	READINT(KeyNext, CONF_KEY_NEXT, DEF_KEY_NEXT);
	READINT(KeyPrev, CONF_KEY_PREV, DEF_KEY_PREV);
	READINT(KeyNextLink, CONF_KEY_NEXTLINK, DEF_KEY_NEXTLINK);
	READINT(KeyPrevLink, CONF_KEY_PREVLINK, DEF_KEY_PREVLINK);
	READINT(KeyMenu, CONF_KEY_MENU, DEF_KEY_MENU);
	READINT(KeyNextTab, CONF_KEY_NEXTTAB, DEF_KEY_NEXTTAB);
	READINT(KeyPrevTab, CONF_KEY_PREVTAB, DEF_KEY_PREVTAB);
	READINT(KeyBack, CONF_KEY_BACK, DEF_KEY_BACK);
	READINT(KeyOpenBookmark, CONF_KEY_OPENBOOKMARK, DEF_KEY_OPENBOOKMARK);
	READINT(KeyAddBookmark, CONF_KEY_ADDBOOKMARK, DEF_KEY_ADDBOOKMARK);
	READINT(KeySort, CONF_KEY_SORT, DEF_KEY_SORT);
	READINT(KeyEdit, CONF_KEY_SORT, DEF_KEY_EDIT);
	READINT(KeyEditReply, CONF_KEY_SORT, DEF_KEY_EDITREPLY);
	READINT(KeyFind2ch, CONF_KEY_FIND2CH, DEF_KEY_FIND2CH);
	READINT(KeyNextLine, CONF_KEY_NEXTLINE, DEF_KEY_NEXTLINE);
	READINT(KeyPrevLine, CONF_KEY_PREVLINE, DEF_KEY_PREVLINE);
}

void Cq2chwmConfig::SetConfigKey(
	const Cq2chwmConfigKey &cConfigKey)
{
	BOOL bo_write = FALSE;
	for (int i = 0; i < cConfigKey.Count(); i++) {
		if (cConfigKey.GetChanged(i) == TRUE) {
			WRITEINT(cConfigKey.GetConfName(i), cConfigKey.GetCode(i));
			bo_write = TRUE;
		}
	}
	if (bo_write == TRUE) readKeyConf();
}

const char *Cq2chwmConfigKey::GetCodeName(
	int in_index)
{
	static const char *chpa_codename[0xFF] = {
		"`",
		"VK_LBUTTON",
		"VK_RBUTTON",
		"VK_CANCEL",
		"VK_MBUTTON",
		"VK_XBUTTON1",
		"VK_XBUTTON2",
		"`",
		"BS",//"VK_BACK",
		"Tab",//"VK_TAB",
		"`",
		"`",
		"VK_CLEAR",
		"VK_RETURN",
		"`",
		"`",
		"VK_SHIFT",
		"VK_CONTROL",
		"VK_MENU",
		"Pause",//"VK_PAUSE",
		"VK_CAPITAL",
		"VK_KANA",
		"`",
		"VK_JUNJA",
		"VK_FINAL",
		"VK_KANJI",
		"`",
		"Esc",//"VK_ESCAPE",
		"VK_CONVERT",
		"VK_NONCONVERT",
		"VK_ACCEPT",
		"VK_MODECHANGE",
		"Xy[X",//"VK_SPACE",
		"PageUP",//"VK_PRIOR",
		"PageDown",//"VK_NEXT",
		"End",//"VK_END",
		"Home",//"VK_HOME",
		"",//"VK_LEFT",
		"",//"VK_UP",
		"",//"VK_RIGHT",
		"",//"VK_DOWN",
		"VK_SELECT",
		"VK_PRINT",
		"VK_EXECUTE",
		"VK_SNAPSHOT",
		"INS",//"VK_INSERT",
		"DEL",//"VK_DELETE",
		"VK_HELP",
		"0",
		"1",
		"2",
		"3",
		"4",
		"5",
		"6",
		"7",
		"8",
		"9",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"A",
		"B",
		"C",
		"D",
		"E",
		"F",
		"G",
		"H",
		"I",
		"J",
		"K",
		"L",
		"M",
		"N",
		"O",
		"P",
		"Q",
		"R",
		"S",
		"T",
		"U",
		"V",
		"W",
		"X",
		"Y",
		"Z",
		"VK_LWIN",
		"VK_RWIN",
		"VK_APPS",
		"`",
		"VK_SLEEP",
		"VK_NUMPAD0",
		"VK_NUMPAD1",
		"VK_NUMPAD2",
		"VK_NUMPAD3",
		"VK_NUMPAD4",
		"VK_NUMPAD5",
		"VK_NUMPAD6",
		"VK_NUMPAD7",
		"VK_NUMPAD8",
		"VK_NUMPAD9",
		"VK_MULTIPLY",
		"VK_ADD",
		"VK_SEPARATOR",
		"VK_SUBTRACT",
		"VK_DECIMAL",
		"VK_DIVIDE",
		"VK_F1",
		"VK_F2",
		"VK_F3",
		"VK_F4",
		"VK_F5",
		"VK_F6",
		"VK_F7",
		"VK_F8",
		"VK_F9",
		"VK_F10",
		"VK_F11",
		"VK_F12",
		"VK_F13",
		"VK_F14",
		"VK_F15",
		"VK_F16",
		"VK_F17",
		"VK_F18",
		"VK_F19",
		"VK_F20",
		"VK_F21",
		"VK_F22",
		"VK_F23",
		"VK_F24",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"VK_NUMLOCK",
		"VK_SCROLL",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"VK_LSHIFT",
		"VK_RSHIFT",
		"VK_LCONTROL",
		"VK_RCONTROL",
		"VK_LMENU",
		"VK_RMENU",
		"VK_BROWSER_BACK",
		"VK_BROWSER_FORWARD",
		"VK_BROWSER_REFRESH",
		"VK_BROWSER_STOP",
		"VK_BROWSER_SEARCH",
		"VK_BROWSER_FAVORITES",
		"VK_BROWSER_HOME",
		"VK_VOLUME_MUTE",
		"VK_VOLUME_DOWN",
		"VK_VOLUME_UP",
		"VK_MEDIA_NEXT_TRACK",
		"VK_MEDIA_PREV_TRACK",
		"VK_MEDIA_STOP",
		"VK_MEDIA_PLAY_PAUSE",
		"VK_LAUNCH_MAIL",
		"VK_LAUNCH_MEDIA_SELECT",
		"VK_LAUNCH_APP1",
		"VK_LAUNCH_APP2",
		"`",
		"`",
		":",//"VK_OEM_1",
		";",//"VK_OEM_PLUS",
		",",//"VK_OEM_COMMA",
		"-",//"VK_OEM_MINUS",
		".",//"VK_OEM_PERIOD",
		"/",//"VK_OEM_2",
		"@",//"VK_OEM_3",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"[",//"VK_OEM_4",
		"\\",//"VK_OEM_5",
		"]",//"VK_OEM_6",
		"^",//"VK_OEM_7",
		"VK_OEM_8",
		"`",
		"`",
		"VK_OEM_102",
		"`",
		"`",
		"p/Sp",//"VK_PROCESSKEY",
		"`",
		"VK_PACKET",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"`",
		"VK_ATTN",
		"VK_CRSEL",
		"VK_EXSEL",
		"VK_EREOF",
		"VK_PLAY",
		"VK_ZOOM",
		"VK_NONAME",
		"VK_PA1",
		"VK_OEM_CLEAR",
	};
	unsigned char uc_code = (unsigned char)GetCode(in_index);
	if (uc_code == 0) return chpa_codename[0];
	return chpa_codename[uc_code];
}
