// q2chwmDatView.cpp : t@C
//

#include "stdafx.h"
#include "YoFile.h"
#include "YoTime.h"
#include "MainFrm.h"
#include "q2chwm.h"
#include "q2chwmDatView.h"
#include "q2chwmDatFile.h"
#include "q2chwmBbsManager.h"
#include "q2chwmConfig.h"
#include "q2chwmDatCtrl.h"
#include "q2chwmMessageDialog.h"

// Cq2chwmDatView

IMPLEMENT_DYNCREATE(Cq2chwmDatView, CView)

Cq2chwmDatView::Cq2chwmDatView()
{
	m_pFont = NULL;
	m_pMessageDialog = NULL;
}

Cq2chwmDatView::~Cq2chwmDatView()
{
	if (m_pFont != NULL) delete m_pFont;
	if (m_pMessageDialog != NULL) delete m_pMessageDialog;
}

BEGIN_MESSAGE_MAP(Cq2chwmDatView, CView)
	ON_WM_SIZE()
//	ON_MESSAGE(WM_USER_CUSTOM, OnCustomMessage)
	ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_RELOAD, &Cq2chwmDatView::OnReload)
	ON_MESSAGE(WM_USER_TABCLICKED, OnTabClicked)
	ON_MESSAGE(WM_USER_NEDITMSG, OnNeditMsg)
	ON_COMMAND(ID_EDIT, &Cq2chwmDatView::OnEdit)
	ON_COMMAND(ID_REPLY, &Cq2chwmDatView::OnReply)
	ON_COMMAND(ID_GOTOP, &Cq2chwmDatView::OnGotop)
	ON_COMMAND(ID_GOBOTTOM, &Cq2chwmDatView::OnGobottom)
	ON_COMMAND(ID_CLOSETAB, &Cq2chwmDatView::OnClosetab)
	ON_COMMAND(ID_NEXTTAB, &Cq2chwmDatView::OnNexttab)
	ON_COMMAND(ID_PREVTAB, &Cq2chwmDatView::OnPrevtab)
	ON_COMMAND(ID_ADDBOOKMARK, &Cq2chwmDatView::OnAddbookmark)
	ON_COMMAND(ID_DELETE, &Cq2chwmDatView::OnDelete)
	ON_COMMAND(ID_LINK_BACK, &Cq2chwmDatView::OnLinkBack)
	ON_COMMAND(ID_LINK_NEXT, &Cq2chwmDatView::OnLinkNext)
	ON_COMMAND(ID_LINK_PREV, &Cq2chwmDatView::OnLinkPrev)
	ON_WM_SHOWWINDOW()
END_MESSAGE_MAP()


// Cq2chwmDatView `

void Cq2chwmDatView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: `R[hɒǉĂB
}


// Cq2chwmDatView ff

#ifdef _DEBUG
void Cq2chwmDatView::AssertValid() const
{
	CView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmDatView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif
#endif //_DEBUG


// Cq2chwmDatView bZ[W nh

void Cq2chwmDatView::OnInitialUpdate()
{
	CView::OnInitialUpdate();

	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	m_cTab.Create(WS_BORDER|TCS_FIXEDWIDTH|TCS_BUTTONS|TCS_FLATBUTTONS, CRect(0, 0, 0, 0), this, 0);
	m_cTab.ShowWindow(SW_SHOW);
	//m_cTab.SetPadding(CSize(4, 4));
	SetFont();
}

void Cq2chwmDatView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (cx == 0) return;
	CYoTime cTime;
	if (m_cTab.m_hWnd != NULL) {
		if (m_cTab.GetItemCount() > 0) {
			resizeCtrl();
		} else {
			m_cTab.ShowWindow(SW_HIDE);
		}
	}
	PRINTLOG("done %d(msec)", cTime.Elapsed());
}

Cq2chwmDatCtrl *Cq2chwmDatView::searchCtrl(
	const char *chp_url,
	const char *chp_id,
	int& in_index)
{
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		if (strcmp(chp_url, pCtrl->GetBoardUrl()) == 0 && strcmp(chp_id, pCtrl->GetArticleId()) == 0) {
			in_index = i;
			return pCtrl;
		}
	}
	return NULL;
}

void Cq2chwmDatView::hideCtrl()
{
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		pCtrl->ShowWindow(SW_HIDE);
	}
}

void Cq2chwmDatView::resizeCtrl()
{
	RECT st_rect;
	RECT st_rect_client;
	RECT st_rect_tab;
	int in_index = m_cTab.GetItemCount() - 1;

	GetParent()->GetWindowRect(&st_rect);
	GetClientRect(&st_rect_client);
	m_cTab.GetItemRect(in_index, &st_rect_tab);
	m_cTab.MoveWindow(0, 0, st_rect.right - st_rect.left, st_rect_tab.bottom);
	m_cTab.ShowWindow(SW_SHOW);

	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	pCtrl->MoveWindow(0, st_rect_tab.bottom, st_rect.right - st_rect.left, st_rect_client.bottom - st_rect_tab.bottom);
	/*
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		pCtrl->MoveWindow(0, st_rect_tab.bottom, st_rect.right - st_rect.left, st_rect_client.bottom - st_rect_tab.bottom);
	}
	*/
}

long Cq2chwmDatView::OnCustomMessage(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmMessage *pMessage = (Cq2chwmMessage*)lParam;
	// DatCtrl̗LɊւ炸Ȃ΂Ȃ
	switch (pMessage->GetType()) {
		case Cq2chwmMessage::TYPE_OPENFILE:
		{
			break;
		}
		case Cq2chwmMessage::TYPE_CLOSEFILE:
		{
			// LZȂt@Ct߂
			if (((CMainFrame*)AfxGetMainWnd())->Canceled() == TRUE) {
				CleanFileTime(pMessage->GetFileName());
			}

			int in_index;
			if (searchCtrl(pMessage->GetBoardUrl(), pMessage->GetArticleId(), in_index) == NULL) {
				// YXbhJĂȂƂ͂infot@CXVĂ
				Cq2chwmCloseFileMessage *pCloseFileMessage = (Cq2chwmCloseFileMessage*)pMessage;
				if (pCloseFileMessage->GetWriteSize() > 0) {
					// VtOI
					Cq2chwmInfoFile cInfo;
					cInfo.Create(pCloseFileMessage->GetBoardUrl(), pCloseFileMessage->GetArticleId());
					cInfo.SetCount(Cq2chwmDatFile::Count(pCloseFileMessage->GetFileName()));
					cInfo.SetNew(TRUE);
					cInfo.Write();
				}
			}
			break;
		}
		case Cq2chwmMessage::TYPE_WRITEFILE:
			break;
		case Cq2chwmMessage::TYPE_RELOADFILE:
			break;
		case Cq2chwmMessage::TYPE_CLOSETAB:
			break;
		case Cq2chwmMessage::TYPE_READURL:
			if (IsRunning() == TRUE) {
				Cq2chwmReadUrlMessage *pReadUrlMessage = (Cq2chwmReadUrlMessage*)pMessage;
				AfxGetMainWnd()->SendMessage(WM_USER_SETPROGRESS, pReadUrlMessage->GetRecvSize(), pReadUrlMessage->GetRecvMaxSize());
			}
			break;
	};

#ifdef _DEBUG
	CString cstr_url;
	CString cstr_id;
	cstr_url = pMessage->GetBoardUrl();
	cstr_id = pMessage->GetArticleId();
	TRACE(_T("Cq2chwmDatView::OnCustomMessage: type(%d) url(%s) id(%s)\n"), pMessage->GetType(), cstr_url, cstr_id);
#endif

	int in_index;
	Cq2chwmDatCtrl *pCtrl = searchCtrl(pMessage->GetBoardUrl(), pMessage->GetArticleId(), in_index);
	if (pCtrl != NULL) {
		pCtrl->OnCustomMessage(pMessage);
	}

	return 0;
}

BOOL Cq2chwmDatView::CreateFromFile(
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_burl,
	const char *chp_bid)
{
	hideCtrl();
	if (chp_aname == NULL || chp_aid == NULL || chp_bname == NULL || chp_burl == NULL || chp_bid == NULL) return FALSE;

	// łɊJĂ邩`FbN
	{
		int in_index;
		Cq2chwmDatCtrl *pCtrl = searchCtrl(chp_burl, chp_aid, in_index);
		if (pCtrl != NULL) {
			m_cTab.SetCurSel(in_index);
			pCtrl->ShowWindow(SW_SHOW);

			// IC[hȂ玩IɃ[h
			if (Cq2chwmConfig::GetInstance()->GetOnline() == TRUE) {
				OnReload();
			}

			return TRUE;
		}
	}

	// ^uő吔Ȃ1^u폜
	if (m_cTab.GetItemCount() == Cq2chwmConfig::GetInstance()->GetTabMax()) {
		CloseTab(0);
	}

	// ^uǉ
	CString cstr_aname;
	cstr_aname = chp_aname;
	int in_index = m_cTab.InsertItem(m_cTab.GetItemCount(), cstr_aname);
	if (in_index == -1) return FALSE;
	m_cTab.SetCurSel(in_index);

	Cq2chwmDatCtrl *pCtrl = new Cq2chwmDatCtrl(this, GetParent());
	TCITEM st_item;
	st_item.mask = TCIF_PARAM;
	st_item.lParam = (LPARAM)pCtrl;
	m_cTab.SetItem(in_index, &st_item);
	SetFont();
	resizeCtrl();
	int in_ret = pCtrl->Create(chp_aname, chp_aid, chp_bname, chp_burl, chp_bid);
	if (in_ret != ERR_NONE) {
		ErrorMessageBox(in_ret);
		return FALSE;
	}

	// NŊJꍇ́Achp_name
	if (*chp_aname == 0x00) {
		CString cstr_aname;
		cstr_aname = pCtrl->GetArticleName();
		const wchar_t *wchp_aname = cstr_aname;
		TCITEM st_item;
		st_item.mask = TCIF_TEXT;
		st_item.pszText = (wchar_t*)wchp_aname;
		st_item.cchTextMax = cstr_aname.GetLength();
		m_cTab.SetItem(in_index, &st_item);

		RECT lpRect;
		GetClientRect(&lpRect);
		m_cTab.MoveWindow(&lpRect, TRUE);
		setWindowText(A(cstr_aname));
	} else {
		setWindowText(chp_aname);
	}
	OnTabClicked(0, 0);

	return TRUE;
}

void Cq2chwmDatView::CloseTab(
	int in_index)
{
	if (in_index >= m_cTab.GetItemCount()) return;

	// ^uƃRg[폜
	{
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(in_index, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		CYoString str_filename = pCtrl->GetFileName();
		delete pCtrl;
		m_cTab.DeleteItem(in_index);
		GetParent()->SendMessage(WM_USER_UPDATEBOOKMARK, 0, (LPARAM)(const char*)str_filename);
	}

	if (in_index == 0) {
		m_cTab.SetCurSel(0);
	} else {
		m_cTab.SetCurSel(in_index - 1);
	}

	// Jg^uɊ֘AtRg[\
	OnTabClicked(0, 0);
	::InvalidateRect(m_hWnd, NULL, TRUE);
}

void Cq2chwmDatView::NextTab()
{
	if (m_cTab.GetItemCount() < 2) return;
	int in_cur = m_cTab.GetCurSel() + 1;
	if (in_cur == m_cTab.GetItemCount()) {
		in_cur = 0;
	}
	m_cTab.SetCurSel(in_cur);
	OnTabClicked(0, 0);
	::InvalidateRect(m_hWnd, NULL, TRUE);
}

void Cq2chwmDatView::PrevTab()
{
	if (m_cTab.GetItemCount() < 2) return;
	int in_cur = m_cTab.GetCurSel() - 1;
	if (in_cur < 0) {
		in_cur = m_cTab.GetItemCount() - 1;
	}
	m_cTab.SetCurSel(in_cur);
	OnTabClicked(0, 0);
	::InvalidateRect(m_hWnd, NULL, TRUE);
}

void Cq2chwmDatView::OnDestroy()
{
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		delete pCtrl;
	}

	CView::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
}

void Cq2chwmDatView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE(_T("Cq2chwmDatView::OnKeyDown: %02x(%d)\n"), nChar, nChar);
	if (nChar == Cq2chwmConfig::GetInstance()->GetKeyCancel()) {
		GetParent()->SendMessage(WM_USER_CANCEL, 0, 0);
	} else if (nChar == Cq2chwmConfig::GetInstance()->GetKeyCloseTab()) {
		CloseTab(m_cTab.GetCurSel());
		return;
	} else if (nChar == Cq2chwmConfig::GetInstance()->GetKeyNextTab()) {
		NextTab();
		return;
	} else if (nChar == Cq2chwmConfig::GetInstance()->GetKeyPrevTab()) {
		PrevTab();
		return;
	} else if (nChar == Cq2chwmConfig::GetInstance()->GetKeyAddBookmark()) {
		AddBookmark();
		return;
	} else if (nChar == Cq2chwmConfig::GetInstance()->GetKeyReload()) {
		OnReload();
		return;
	} else if (nChar == Cq2chwmConfig::GetInstance()->GetKeyDelete()) {
		Delete();
		return;
	} else if (nChar == Cq2chwmConfig::GetInstance()->GetKeyEdit()) {
		OnEdit();
		return;
	} else if (nChar == Cq2chwmConfig::GetInstance()->GetKeyEditReply()) {
		OnReply();
		return;
	} else {
		Cq2chwmDatCtrl *pCtrl = currentCtrl();
		if (pCtrl != NULL) {
			pCtrl->OnKeyDown(nChar, nRepCnt, nFlags);
			return;
		}
	};

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

Cq2chwmDatCtrl *Cq2chwmDatView::currentCtrl()
{
	int in_cur = m_cTab.GetCurSel();
	TCITEM st_item;
	st_item.mask = TCIF_PARAM;
	m_cTab.GetItem(in_cur, &st_item);
	return (Cq2chwmDatCtrl*)st_item.lParam;
}

void Cq2chwmDatView::OnReload()
{
	// TODO: ɃR}h nh R[hǉ܂B
	TRACE(_T("Cq2chwmDatView::OnReload\n"));
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		int in_ret = pCtrl->CreateFromHttp();
		if (in_ret != ERR_NONE) {
			const char *chp_err = pCtrl->GetErrorMessage();
			if (strlen(chp_err) == 0) {
				ErrorMessageBox(in_ret);
			} else {
				ErrorMessageBox(chp_err);
			}
		}
	}
}

long Cq2chwmDatView::OnTabClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		hideCtrl();
		pCtrl->ShowWindow(SW_SHOW);
		setWindowText(pCtrl->GetArticleName());
		resizeCtrl();
	} else {
		setWindowText("");
	}

	return 0;
}

long Cq2chwmDatView::OnNeditMsg(
	WPARAM wParam,
	LPARAM lParam)
{
	NEDITMSG *msg = (NEDITMSG*)lParam;
	switch (msg->msg) {
	case WM_KEYDOWN:
		OnKeyDown(static_cast<UINT>(msg->wParam), LOWORD(msg->lParam), HIWORD(msg->lParam));
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

void Cq2chwmDatView::SetFont()
{
	// ^ũtHgݒ
	CString cstr_name;
	cstr_name = Cq2chwmConfig::GetInstance()->GetFontNameTab();
	if (m_pFont != NULL) delete m_pFont;
	m_pFont = new CFont;
	m_pFont->CreatePointFont(Cq2chwmConfig::GetInstance()->GetFontSizeTab() * 10, cstr_name);
	m_cTab.SetFont(m_pFont);
	RECT st_rect_tab;
	m_cTab.GetItemRect(0, &st_rect_tab);
	CSize cSize(Cq2chwmConfig::GetInstance()->GetTabWidth(), st_rect_tab.bottom - st_rect_tab.top);
	m_cTab.SetItemSize(cSize);

	// ArticlẽtHgύXꂽCq2chwmEditCtrl::ClearCacheĂ΂Ȃ΂ȂȂ
	if (m_str_font_name != Cq2chwmConfig::GetInstance()->GetFontNameArticle() ||
		m_in_font_size != Cq2chwmConfig::GetInstance()->GetFontSizeArticle())
	{
		Cq2chwmEditCtrl::ClearCache();
	}
	m_str_font_name = Cq2chwmConfig::GetInstance()->GetFontNameArticle();
	m_in_font_size = Cq2chwmConfig::GetInstance()->GetFontSizeArticle();

	// r[̃tHgݒ
	for (int i = 0; i < m_cTab.GetItemCount(); i++) {
		TCITEM st_item;
		st_item.mask = TCIF_PARAM;
		m_cTab.GetItem(i, &st_item);
		Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
		pCtrl->SetFont(m_str_font_name, m_in_font_size);
		pCtrl->SetColorFore(Cq2chwmConfig::GetInstance()->GetColorFore());
		pCtrl->SetColorBack(Cq2chwmConfig::GetInstance()->GetColorBack());
		pCtrl->SetColorFrom(Cq2chwmConfig::GetInstance()->GetColorFrom());
		pCtrl->SetColorFromWithMail(Cq2chwmConfig::GetInstance()->GetColorFromWithMail());
		pCtrl->SetColorFromWithSage(Cq2chwmConfig::GetInstance()->GetColorFromWithSage());
		pCtrl->SetColorNew(Cq2chwmConfig::GetInstance()->GetColorDateNew());
		pCtrl->SetColorDate(Cq2chwmConfig::GetInstance()->GetColorDate());
		pCtrl->SetColorLink(Cq2chwmConfig::GetInstance()->GetColorLink());
		pCtrl->SetColorAbone(Cq2chwmConfig::GetInstance()->GetColorAbone());
		pCtrl->SetColorMessage(Cq2chwmConfig::GetInstance()->GetColorMessage());
		/*
		COLORREF color[] = {
			RGB(  0,  0,  0),	// TXT
			RGB(  0,  0,  0),	// CMT
			RGB(  0,  0,  0),	// KWD
			RGB(  0,  0,  0),	// //
			RGB(  0,  0,  0),	// CTL
			RGB(255,255,255),	// BG
			Cq2chwmConfig::GetInstance()->GetColorFrom(),
			Cq2chwmConfig::GetInstance()->GetColorFromWithMail(),
			Cq2chwmConfig::GetInstance()->GetColorFromWithSage(),
			Cq2chwmConfig::GetInstance()->GetColorDateNew(),
			Cq2chwmConfig::GetInstance()->GetColorDate(),
			Cq2chwmConfig::GetInstance()->GetColorLink(),
			Cq2chwmConfig::GetInstance()->GetColorAbone(),
			Cq2chwmConfig::GetInstance()->GetColorMessage(),
		};
		pCtrl->SetColor(color);
		*/
	}
}

void Cq2chwmDatView::AddBookmark()
{
	if (::MessageBox(m_hWnd, _T("ubN}[Nɒǉ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		Cq2chwmDatCtrl *pCtrl = currentCtrl();
		if (pCtrl != NULL) {
			pCtrl->Write();
			Cq2chwmBookmarkItem cBookmarkItem(1, pCtrl->GetArticleName(), pCtrl->GetArticleId(), pCtrl->GetBoardName(), pCtrl->GetBoardId(), pCtrl->GetBoardUrl());
			GetParent()->SendMessage(WM_USER_ADDBOOKMARK, 0, (LPARAM)&cBookmarkItem);
		}
	}
}

void Cq2chwmDatView::Delete()
{
	if (::MessageBox(m_hWnd, _T("̃Xbh폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		Cq2chwmDatCtrl *pCtrl = currentCtrl();
		if (pCtrl != NULL) {
			if (Cq2chwmDatFile::Delete(pCtrl->GetBoardUrl(), pCtrl->GetArticleId()) == TRUE) {
				pCtrl->Delete();
				CloseTab(m_cTab.GetCurSel());
			}
		}
	}
}

void Cq2chwmDatView::OnEdit()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		if (m_pMessageDialog == NULL ||
			strcmp(m_pMessageDialog->GetBoardUrl(), pCtrl->GetBoardUrl()) != 0 ||
			strcmp(m_pMessageDialog->GetArticleId(), pCtrl->GetArticleId()) != 0)
		{
			// Xbhς蒼
			if (m_pMessageDialog != NULL) delete m_pMessageDialog;
			m_pMessageDialog = new Cq2chwmMessageDialog(pCtrl->GetArticleName(), pCtrl->GetBoardUrl(), pCtrl->GetArticleId());
		}

		m_pMessageDialog->SetName(pCtrl->GetName());
		m_pMessageDialog->SetMail(pCtrl->GetMail());
		if (m_pMessageDialog->DoModal() == IDOK) {
			pCtrl->SetName(m_pMessageDialog->GetName());
			pCtrl->SetMail(m_pMessageDialog->GetMail());
			pCtrl->Write();
			Cq2chwmConfig::GetInstance()->AddHistoryName(m_pMessageDialog->GetName());
			if (strcmp(m_pMessageDialog->GetMail(), "sage") != 0) {
				// sage͗ɓȂ
				Cq2chwmConfig::GetInstance()->AddHistoryMail(m_pMessageDialog->GetMail());
			}
			OnReload();
		}
	}
}

void Cq2chwmDatView::GoTop()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->OnKeyDown(Cq2chwmConfig::GetInstance()->GetKeyTop(), 0, 0);
	}
}

void Cq2chwmDatView::GoBottom()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->OnKeyDown(Cq2chwmConfig::GetInstance()->GetKeyBottom(), 0, 0);
	}
}

void Cq2chwmDatView::OnReply()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		// bZ[WZbg
		CYoString str_text;
		str_text.Format(">>%d\r\n", pCtrl->GetCurrentMessageNumber());
		{
			CYoString str_message;
			pCtrl->GetCurrentMessageText(str_message);
			str_message.Trim();
			str_message.Replace("\r\n", "\r\n>");
			str_message = ">" + str_message;
			str_text += str_message;
		}

		if (m_pMessageDialog == NULL ||
			strcmp(m_pMessageDialog->GetBoardUrl(), pCtrl->GetBoardUrl()) != 0 ||
			strcmp(m_pMessageDialog->GetArticleId(), pCtrl->GetArticleId()) != 0)
		{
			// Xbhς蒼
			if (m_pMessageDialog != NULL) delete m_pMessageDialog;
			m_pMessageDialog = new Cq2chwmMessageDialog(pCtrl->GetArticleName(), pCtrl->GetBoardUrl(), pCtrl->GetArticleId());
		}

		m_pMessageDialog->SetName(pCtrl->GetName());
		m_pMessageDialog->SetMail(pCtrl->GetMail());
		m_pMessageDialog->SetMessage(str_text);
		if (m_pMessageDialog->DoModal() == IDOK) {
			pCtrl->SetName(m_pMessageDialog->GetName());
			pCtrl->SetMail(m_pMessageDialog->GetMail());
			pCtrl->Write();
			Cq2chwmConfig::GetInstance()->AddHistoryName(m_pMessageDialog->GetName());
			if (strcmp(m_pMessageDialog->GetMail(), "sage") != 0) {
				// sage͗ɓȂ
				Cq2chwmConfig::GetInstance()->AddHistoryMail(m_pMessageDialog->GetMail());
			}
			OnReload();
		}
	}
}

void Cq2chwmDatView::OnGotop()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GoTop();
}

void Cq2chwmDatView::OnGobottom()
{
	// TODO: ɃR}h nh R[hǉ܂B
	GoBottom();
}

void Cq2chwmDatView::OnClosetab()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CloseTab(m_cTab.GetCurSel());
}

void Cq2chwmDatView::OnNexttab()
{
	// TODO: ɃR}h nh R[hǉ܂B
	NextTab();
}

void Cq2chwmDatView::OnPrevtab()
{
	// TODO: ɃR}h nh R[hǉ܂B
	PrevTab();
}

void Cq2chwmDatView::OnAddbookmark()
{
	// TODO: ɃR}h nh R[hǉ܂B
	AddBookmark();
}

void Cq2chwmDatView::OnDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Delete();
}

BOOL Cq2chwmDatView::IsRunning()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		return pCtrl->IsRunning();
	}
	return FALSE;
}

void Cq2chwmDatView::SearchNext(
	const char *chp_word)
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->SearchNext(chp_word);
	}
}

void Cq2chwmDatView::SearchPrev(
	const char *chp_word)
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->SearchPrev(chp_word);
	}
}

void Cq2chwmDatView::Copy()
{
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->Copy();
	}
}

BOOL Cq2chwmDatView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	cs.style &= ~WS_BORDER;
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	return CView::PreCreateWindow(cs);
}

void Cq2chwmDatView::setWindowText(
	const char *chp_text)
{
	CString cstr_text;
	cstr_text = chp_text;
	AfxGetMainWnd()->SetWindowText(cstr_text);
}

void Cq2chwmDatView::OnLinkBack()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->JumpBack();
	}
}

void Cq2chwmDatView::OnLinkNext()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->JumpNextLink();
	}
}

void Cq2chwmDatView::OnLinkPrev()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmDatCtrl *pCtrl = currentCtrl();
	if (pCtrl != NULL) {
		pCtrl->JumpPrevLink();
	}
}

void Cq2chwmDatView::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CView::OnShowWindow(bShow, nStatus);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (bShow == FALSE) {
		for (int i = 0; i < m_cTab.GetItemCount(); i++) {
			TCITEM st_item;
			st_item.mask = TCIF_PARAM;
			m_cTab.GetItem(i, &st_item);
			Cq2chwmDatCtrl *pCtrl = (Cq2chwmDatCtrl*)st_item.lParam;
			pCtrl->Write();
			GetParent()->SendMessage(WM_USER_UPDATEBOOKMARK, 0, (LPARAM)pCtrl->GetFileName());
		}
	} else {
		Cq2chwmDatCtrl *pCtrl = currentCtrl();
		if (pCtrl != NULL) {
			setWindowText(pCtrl->GetArticleName());
		}
	}
}
