// MainFrm.cpp : CMainFrame NX̎
//

#include "stdafx.h"
#include "YoTime.h"
#include "q2chwm.h"
#include "MainFrm.h"
#include "q2chwmConfig.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#ifdef WIN32_PLATFORM_PSPC
#define TOOLBAR_HEIGHT 24
#include <connmgr.h>
#include <connmgr_proxy.h>
#endif // WIN32_PLATFORM_PSPC

const DWORD dwAdornmentFlags = 0; // [I] {^

// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_SIZE()

	ON_MESSAGE(WM_USER_OPENURL, OnOpenUrl)
	ON_MESSAGE(WM_USER_BOARDCLICKED, OnBoardClicked)
	ON_MESSAGE(WM_USER_SUBJECTCLICKED, OnSubjectClicked)
	ON_MESSAGE(WM_USER_BOOKMARKCLICKED, OnBookmarkClicked)
	ON_MESSAGE(WM_USER_CACHECLICKED, OnCacheClicked)
	ON_MESSAGE(WM_USER_CANCEL, OnCancel)
	ON_MESSAGE(WM_USER_OPENBOOKMARK, OnOpenBookmark)
	ON_MESSAGE(WM_USER_OPENFIND2CH, OnOpenFind2ch)
	ON_MESSAGE(WM_USER_OPENCACHE, OnOpenCache)
	ON_MESSAGE(WM_USER_ADDBOOKMARK, OnAddBookmark)
	ON_MESSAGE(WM_USER_CUSTOM, OnCustomMessage)
	ON_MESSAGE(WM_USER_SHOWSTATUSBAR, OnShowStatusBar)
	ON_MESSAGE(WM_USER_SHOWSEARCHBAR, OnShowSearchBar)
	ON_MESSAGE(WM_USER_SHOWFIND2CHBAR, OnShowFind2chBar)
	ON_MESSAGE(WM_USER_EXECSEARCH, OnExecSearch)
	ON_MESSAGE(WM_USER_EXECFIND2CH, OnExecFind2ch)
	ON_MESSAGE(WM_USER_POPUPMENU, OnPopupMenu)
	ON_MESSAGE(WM_USER_UPDATEBOOKMARK, OnUpdateBookmark)
	ON_MESSAGE(WM_USER_NEXTARTICLE, OnNextArticle)
	ON_MESSAGE(WM_USER_SETPROGRESS, OnSetProgress)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_CANCEL, &CMainFrame::OnCancel)
	ON_COMMAND(ID_SEARCH, &CMainFrame::OnSearch)
	ON_COMMAND(ID_FIND2CH, &CMainFrame::OnFind2ch)
	ON_COMMAND(ID_EXIT, &CMainFrame::OnExit)
	ON_COMMAND(ID_CONNECT, &CMainFrame::OnConnect)
	ON_COMMAND(ID_DISCONNECT, &CMainFrame::OnDisconnect)
	ON_COMMAND(ID_COPY, &CMainFrame::OnCopy)
END_MESSAGE_MAP()


// CMainFrame RXgNV/fXgNV

CMainFrame::CMainFrame()
{
	// TODO: oR[hɒǉĂB
	m_bo_canceled = FALSE;
	m_hConnection = NULL;
	m_dw_threadid = ::GetCurrentThreadId();
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// Xe[^Xo[ǂ
	m_cStatus.Create(IDD_DIALOG_STATUS, this);
	m_cSearch.Create(IDD_DIALOG_SEARCH, this);
	m_cFind2ch.Create(IDD_DIALOG_FIND2CH, this);
	ShowStatusBar(FALSE);
	ShowSearchBar(FALSE);
	ShowFind2chBar(FALSE);

#ifdef WIN32_PLATFORM_PSPC
	if (!m_wndCommandBar.Create(this) ||
	    !m_wndCommandBar.InsertMenuBar(IDR_MAINFRAME) ||
	    !m_wndCommandBar.AddAdornments(dwAdornmentFlags)/* ||
	    !m_wndCommandBar.LoadToolBar(IDR_MAINFRAME)*/)
	{
		TRACE0("CommandBar ̍쐬Ɏs܂\n");
		return -1;      // 쐬ł܂łB
	}

	m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() | CBRS_SIZE_FIXED);

	// Ȃłȏ׍HȂƃEBhETCY肱Ȃ
	RECT rcBar;
	m_wndCommandBar.GetWindowRect(&rcBar);
	RECT rcThis;
	GetWindowRect(&rcThis);
	MoveWindow(rcThis.left, rcThis.top, rcThis.right - rcThis.left, (rcThis.bottom - rcThis.top) - ((rcBar.bottom - rcBar.top) / 2));
#endif // WIN32_PLATFORM_PSPC

	// NMODE_BOARD
	AddHistory(MODE_BOARD);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if (!CFrameWnd::PreCreateWindow(cs))
		return FALSE;
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB
#ifndef WIN32_PLATFORM_PSPC
	cs.cx = 320;
	cs.cy = 240;
	cs.cx = 480;
	cs.cy = 640;
#endif
	cs.style &= ~FWS_ADDTOTITLE;
	cs.style &= ~FWS_PREFIXTITLE;
	return TRUE;
}

// CMainFrame ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}
#endif //_DEBUG

#define BAR_HEIGHT	(46)
// CMainFrame bZ[W nh
void CMainFrame::OnSize(UINT nType, int cx, int cy)
{
	CFrameWnd::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	CView *pView = GetActiveView();
	if (m_cStatus.m_hWnd != NULL && m_cStatus.IsWindowVisible() == TRUE) {
		m_cStatus.MoveWindow(0, cy - BAR_HEIGHT, cx, BAR_HEIGHT);
		if (pView != NULL) {
			pView->MoveWindow(0, 0, cx, cy - BAR_HEIGHT);
		}
	} else if (m_cSearch.m_hWnd != NULL && m_cSearch.IsWindowVisible() == TRUE) {
		m_cSearch.MoveWindow(0, cy - BAR_HEIGHT, cx, BAR_HEIGHT);
		if (pView != NULL) {
			pView->MoveWindow(0, 0, cx, cy - BAR_HEIGHT);
		}
	} else if (m_cFind2ch.m_hWnd != NULL && m_cFind2ch.IsWindowVisible() == TRUE) {
		m_cFind2ch.MoveWindow(0, cy - BAR_HEIGHT, cx, BAR_HEIGHT);
		if (pView != NULL) {
			pView->MoveWindow(0, 0, cx, cy - BAR_HEIGHT);
		}
	} else {
		if (pView != NULL) {
			pView->MoveWindow(0, 0, cx, cy);
		}
	}
}

BOOL CMainFrame::Connect()
{
#ifdef WIN32_PLATFORM_PSPC
	GUID gNetwork;
	ConnMgrMapURL(_T("http://ultrapop.jp"), &gNetwork, 0);
	CONNMGR_CONNECTIONINFO ConnInfo = {0};
	ConnInfo.cbSize = sizeof(ConnInfo);
	ConnInfo.dwParams = CONNMGR_PARAM_GUIDDESTNET;
	//ConnInfo.dwFlags = GetProxy() ? CONNMGR_FLAG_PROXY_HTTP: 0;
	ConnInfo.dwPriority = CONNMGR_PRIORITY_USERINTERACTIVE;
	ConnInfo.guidDestNet = gNetwork;

	HRESULT hr = ConnMgrEstablishConnection(&ConnInfo, &m_hConnection);
	if (FAILED(hr)) {
		return FALSE;
	} else {
		BOOL bStop = FALSE;
		int in_timeout = 0;
		while (bStop == FALSE && Canceled() == FALSE) {
			DWORD dwResult = WaitForSingleObject(m_hConnection, 1000);
			if (dwResult == WAIT_OBJECT_0) {
				DWORD dwStatus;
				HRESULT hr = ConnMgrConnectionStatus(m_hConnection, &dwStatus);
				if( SUCCEEDED(hr) && (dwStatus == CONNMGR_STATUS_CONNECTED)) {
					bStop = TRUE;
				} else {
					MessageLoop();
				}
			} else {
				MessageLoop();
			}
			in_timeout++;
			if (in_timeout > TIMEOUT) return FALSE;
		}
	}
#endif
	return TRUE;
}

BOOL CMainFrame::Disconnect()
{
#ifdef WIN32_PLATFORM_PSPC
	HRESULT hr = ConnMgrReleaseConnection(m_hConnection, FALSE);
	if (FAILED(hr)) {
		return FALSE;
	}
#endif
	return TRUE;
}

BOOL CMainFrame::IsConnected()
{
#ifdef WIN32_PLATFORM_PSPC
	GUID gNetwork;
	ConnMgrMapURL(_T("http://ultrapop.jp"), &gNetwork, 0);
	BOOL bRet = FALSE;
	HANDLE hConn = NULL;
	CONNMGR_CONNECTIONINFO ci = {0};
	ci.cbSize = sizeof(ci);
	ci.dwParams = CONNMGR_PARAM_GUIDDESTNET|CONNMGR_PARAM_MAXCONNLATENCY;
	//ci.dwFlags = bProxy?CONNMGR_FLAG_PROXY_HTTP:0;
	ci.ulMaxConnLatency = 4000;         // 4 second
	ci.bDisabled = TRUE;
	ci.dwPriority = CONNMGR_PRIORITY_USERINTERACTIVE;
	ci.guidDestNet = gNetwork;

	HRESULT hr = ConnMgrEstablishConnection(&ci, &hConn);
	if (SUCCEEDED(hr)) {
		DWORD dwResult = WaitForSingleObject(hConn, 400);
		switch (dwResult) {
		case WAIT_OBJECT_0:
			DWORD dwStatus;
			hr = ConnMgrConnectionStatus(hConn, &dwStatus);
			if( SUCCEEDED(hr) && (dwStatus == CONNMGR_STATUS_CONNECTED || dwStatus == CONNMGR_STATUS_CONNECTIONDISABLED)) {
				bRet = TRUE;
			} else{
				bRet = FALSE;
			}
			break;
		case WAIT_TIMEOUT:
			bRet = FALSE;
		}
		ConnMgrReleaseConnection(hConn, FALSE);
	}
	return bRet;
#else
	return TRUE;
#endif
}

BOOL CMainFrame::CallbackProc(
	CYoSocketMessage &cMsg,
	void *vop_user)
{
	CMainFrame *pMainWnd = (CMainFrame*)vop_user;
	if (pMainWnd->Canceled() == TRUE) {
		cMsg.SetCancel(TRUE);
	} else {
		if (cMsg.GetMessage() == CYoSocketMessage::CONNECT_BEFORE) {
			// ڑ
			static CYoMutex cMutex;
			cMutex.Lock();
			if (pMainWnd->IsConnected() == FALSE) {
				// ڑȂ̂Őڑ
				if (pMainWnd->Connect() == FALSE) {
					cMsg.SetCancel(TRUE);
				}
			}
			cMutex.Unlock();
		}

		if (pMainWnd->m_dw_threadid == ::GetCurrentThreadId()) {
			MessageLoop();
		}
	}

	return TRUE;
}

void CMainFrame::ShowStatusBar(
	BOOL bo_flg)
{
	m_cStatus.SetMessage("");
	m_cStatus.SetProgress(0, 0);
	m_cStatus.ShowWindow(bo_flg == TRUE ? SW_SHOW : SW_HIDE);
	RECT r;
	GetClientRect(&r);
	OnSize(SIZE_RESTORED, r.right - r.left, r.bottom - r.top);
	if (bo_flg == TRUE) m_bo_canceled = FALSE;
}

void CMainFrame::ShowFind2chBar(
	BOOL bo_flg)
{
	m_cFind2ch.ShowWindow(bo_flg == TRUE ? SW_SHOW : SW_HIDE);
	if (bo_flg == TRUE) {
		m_cFind2ch.SetFocus();
	} else if (GetActiveView() != NULL) {
		GetActiveView()->SetFocus();
	}
	RECT r;
	GetClientRect(&r);
	OnSize(SIZE_RESTORED, r.right - r.left, r.bottom - r.top);
}

void CMainFrame::ShowSearchBar(
	BOOL bo_flg)
{
	switch ((int)m_cModeArray.Get(m_cModeArray.Count() - 1)) {
	case MODE_SUBJECT:
	case MODE_BOOKMARK:
	case MODE_CACHE:
		m_cSearch.SetUpDownButton(FALSE);
		break;
	default:
		m_cSearch.SetUpDownButton(TRUE);
	}

	m_cSearch.ShowWindow(bo_flg == TRUE ? SW_SHOW : SW_HIDE);
	if (bo_flg == TRUE) {
		m_cSearch.SetFocus();
	} else if (GetActiveView() != NULL) {
		GetActiveView()->SetFocus();
	}
	RECT r;
	GetClientRect(&r);
	OnSize(SIZE_RESTORED, r.right - r.left, r.bottom - r.top);
}

long CMainFrame::OnSetProgress(
	WPARAM wParam,
	LPARAM lParam)
{
	SetProgress(NULL, wParam, lParam);
	return 0;
}

void CMainFrame::SetProgress(
	const char *chp_message,
	int in_recv,
	int in_recv_all)
{
	if (chp_message == NULL || *chp_message == 0x00) {
		CYoString str_message;
		str_message.Format("%d/%d", in_recv, in_recv_all);
		m_cStatus.SetMessage(str_message);
		TRACE(_T("%s\n"), W(str_message));
	} else {
		m_cStatus.SetMessage(chp_message);
	}
	m_cStatus.SetProgress(in_recv, in_recv_all);
}

long CMainFrame::OnBoardClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	AddHistory(MODE_SUBJECT);
	((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->ResetSearchState();
	((Cq2chwmApp*)AfxGetApp())->ShowSubjectView();
	Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->CreateFromFile(pItem->GetBoardName(), pItem->GetBoardUrl(), pItem->GetBoardId());
	return 0;
}

long CMainFrame::OnSubjectClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	AddHistory(MODE_DAT);
	((Cq2chwmApp*)AfxGetApp())->ShowDatView();
	Cq2chwmListItem *pItem = (Cq2chwmListItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile(pItem->GetArticleName(), pItem->GetArticleId(),
		pItem->GetBoardName(), pItem->GetBoardUrl(), pItem->GetBoardId());
	return 0;
}

long CMainFrame::OnBookmarkClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	AddHistory(MODE_DAT);
	((Cq2chwmApp*)AfxGetApp())->ShowDatView();
	Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile(pItem->GetArticleName(), pItem->GetArticleId(),
		pItem->GetBoardName(), pItem->GetBoardUrl(), pItem->GetBoardId());
	return 0;
}

long CMainFrame::OnCacheClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	AddHistory(MODE_DAT);
	((Cq2chwmApp*)AfxGetApp())->ShowDatView();
	Cq2chwmCacheItem *pItem = (Cq2chwmCacheItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile(pItem->GetArticleName(), pItem->GetArticleId(),
		pItem->GetBoardName(), pItem->GetBoardUrl(), pItem->GetBoardId());
	return 0;
}

long CMainFrame::OnNextArticle(
	WPARAM wParam,
	LPARAM lParam)
{
	if ((int)m_cModeArray.Get(m_cModeArray.Count() - 2) == MODE_BOOKMARK) {
		// ̐VubN}[NJ
		Cq2chwmBookmarkItem *pItem = ((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->GetNextItem();
		if (pItem != NULL) {
			if (::MessageBox(m_hWnd, _T("̐VubN}[NJ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
				OnBookmarkClicked(0, (LPARAM)pItem);
			}
		}
	}
	return 0;
}

long CMainFrame::OnCancel(
	WPARAM wParam,
	LPARAM lParam)
{
	// LZ`FbN
	switch ((int)m_cModeArray.Get(m_cModeArray.Count() - 1)) {
		case MODE_BOARD:
			if (((Cq2chwmApp*)AfxGetApp())->GetBoardView()->IsRunning() == FALSE) {
				break;
			} else if (::MessageBox(m_hWnd, _T("LZ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
				m_bo_canceled = TRUE;
			}
			return 0;
		case MODE_SUBJECT:
			if (((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->IsRunning() == FALSE) {
				break;
			} else if (::MessageBox(m_hWnd, _T("LZ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
				m_bo_canceled = TRUE;
			}
			return 0;
		case MODE_DAT:
			if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->IsRunning() == FALSE) {
				break;
			} else if (::MessageBox(m_hWnd, _T("LZ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
				m_bo_canceled = TRUE;
			}
			return 0;
		case MODE_BOOKMARK:
			if (((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->IsRunning() == FALSE) {
				break;
			} else if (::MessageBox(m_hWnd, _T("LZ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
				m_bo_canceled = TRUE;
			}
			return 0;
	};

	// ʑJ
	if (m_cModeArray.Count() > 1) {
		m_cModeArray.Remove(m_cModeArray.Count() - 1);
		switch ((int)m_cModeArray.Get(m_cModeArray.Count() - 1)) {
			case MODE_BOARD:
				((Cq2chwmApp*)AfxGetApp())->ShowBoardView();
				break;
			case MODE_SUBJECT:
				((Cq2chwmApp*)AfxGetApp())->ShowSubjectView();
				break;
			case MODE_DAT:
				((Cq2chwmApp*)AfxGetApp())->ShowDatView();
				((Cq2chwmApp*)AfxGetApp())->GetDatView()->SetWindowText();
				break;
			case MODE_BOOKMARK:
				((Cq2chwmApp*)AfxGetApp())->ShowBookmarkView();
				break;
			case MODE_CACHE:
				((Cq2chwmApp*)AfxGetApp())->ShowCacheView();
				break;
		};
	}

	return 0;
}

long CMainFrame::OnOpenBookmark(
	WPARAM wParam,
	LPARAM lParam)
{
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->ResetSearchState();
	((Cq2chwmApp*)AfxGetApp())->ShowBookmarkView();
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->CreateFromFile();
	AddHistory(MODE_BOOKMARK);
	return 0;
}

long CMainFrame::OnOpenFind2ch(
	WPARAM wParam,
	LPARAM lParam)
{
	((Cq2chwmApp*)AfxGetApp())->ShowSubjectView();
	AddHistory(MODE_SUBJECT);
	((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->CreateFromFile("Q˂錟", "http://.tmp/find.2ch.net/", "find.2ch.net");
	return 0;
}

long CMainFrame::OnOpenCache(
	WPARAM wParam,
	LPARAM lParam)
{
	((Cq2chwmApp*)AfxGetApp())->GetCacheView()->ResetSearchState();
	((Cq2chwmApp*)AfxGetApp())->ShowCacheView();
	AddHistory(MODE_CACHE);
	// LbVCq2chwmApp::ShowCacheViewō쐬
	//((Cq2chwmApp*)AfxGetApp())->GetCacheView()->CreateList();
	return 0;
}

long CMainFrame::OnAddBookmark(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->AddBookmark(pItem->GetArticleName(), pItem->GetArticleId(),
		pItem->GetBoardName(), pItem->GetBoardId(), pItem->GetBoardUrl());
	return 0;
}

void CMainFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE(_T("CMainFrame::OnKeyDown\n"));
	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

long CMainFrame::OnCustomMessage(
	WPARAM wParam,
	LPARAM lParam)
{
	((Cq2chwmApp*)AfxGetApp())->GetDatView()->OnCustomMessage(wParam, lParam);
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->OnCustomMessage(wParam, lParam);
	Cq2chwmMessage *pMessage= (Cq2chwmMessage*)lParam;
	delete pMessage;
	return 0;
}

void CMainFrame::OnCancel()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnCancel(0, 0);
}

long CMainFrame::OnShowStatusBar(
	WPARAM wParam,
	LPARAM lParam)
{
	ShowStatusBar((BOOL)lParam);
	return 0;
}

long CMainFrame::OnShowSearchBar(
	WPARAM wParam,
	LPARAM lParam)
{
	ShowSearchBar((BOOL)lParam);
	return 0;
}

long CMainFrame::OnShowFind2chBar(
	WPARAM wParam,
	LPARAM lParam)
{
	ShowFind2chBar((BOOL)lParam);
	return 0;
}

long CMainFrame::OnExecFind2ch(
	WPARAM wParam,
	LPARAM lParam)
{
	CString cstr_url = (const wchar_t*)wParam;
	CString cstr_word = (const wchar_t*)lParam;
	CYoString str_word = A(cstr_word);
	CYoString str_url = A(cstr_url);
	Cq2chwmConfig::GetInstance()->AddHistorySearchWord(str_word);

	// Board[h
	AddHistory(MODE_SUBJECT);
	((Cq2chwmApp*)AfxGetApp())->ShowSubjectView();
	ShowFind2chBar(FALSE);
	ShowStatusBar(TRUE);
	((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->CreateFromFindUrl(str_url);
	ShowStatusBar(FALSE);

	return 0;
}

long CMainFrame::OnPopupMenu(
	WPARAM wParam,
	LPARAM lParam)
{
	RECT rect;
	GetWindowRect(&rect);
	CMenu cMenu;
	cMenu.LoadMenuW(IDR_MAINFRAME);
	cMenu.GetSubMenu(0)->TrackPopupMenu(TPM_LEFTALIGN, rect.left, rect.top, this);
//	GetMenu()->GetSubMenu(0)->TrackPopupMenu(TPM_LEFTALIGN, rect.left, rect.top, this);
	return 0;
}

long CMainFrame::OnUpdateBookmark(
	WPARAM wParam,
	LPARAM lParam)
{
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->UpdateItem((const char*)lParam);
	return 0;
}

long CMainFrame::OnExecSearch(
	WPARAM wParam,
	LPARAM lParam)
{
	CYoString str_word = A((const wchar_t*)lParam);
	Cq2chwmConfig::GetInstance()->AddHistorySearchWord(str_word);

	// ݃ANeBuȃr[Ɍ
	switch ((int)m_cModeArray.Get(m_cModeArray.Count() - 1)) {
		case MODE_BOARD:
			if (wParam == FALSE) {
				((Cq2chwmApp*)AfxGetApp())->GetBoardView()->SearchNext(str_word);
			} else {
				((Cq2chwmApp*)AfxGetApp())->GetBoardView()->SearchPrev(str_word);
			}
			break;
		case MODE_SUBJECT:
			((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->Search(str_word);
			ShowSearchBar(FALSE);
			((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->SetFocus();
			break;
		case MODE_DAT:
			if (wParam == FALSE) {
				((Cq2chwmApp*)AfxGetApp())->GetDatView()->SearchNext(str_word);
			} else {
				((Cq2chwmApp*)AfxGetApp())->GetDatView()->SearchPrev(str_word);
			}
			break;
		case MODE_BOOKMARK:
			((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->Search(str_word);
			ShowSearchBar(FALSE);
			((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->SetFocus();
			break;
		case MODE_CACHE:
			((Cq2chwmApp*)AfxGetApp())->GetCacheView()->Search(str_word);
			ShowSearchBar(FALSE);
			((Cq2chwmApp*)AfxGetApp())->GetCacheView()->SetFocus();
			break;
	};
	return 0;
}

void CMainFrame::OnSearch()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowFind2chBar(FALSE);
	ShowSearchBar(TRUE);
}

void CMainFrame::OnFind2ch()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowSearchBar(FALSE);
	ShowFind2chBar(TRUE);
}

void CMainFrame::OnExit()
{
	// TODO: ɃR}h nh R[hǉ܂B
	PostMessage(WM_CLOSE);
}

void CMainFrame::OnConnect()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (IsConnected() == FALSE) {
		Connect();
	}
}

void CMainFrame::OnDisconnect()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (IsConnected() == TRUE) {
		Disconnect();
	}
}

void CMainFrame::OnCopy()
{
	// ݃ANeBuȃr[Ɍ
	switch ((int)m_cModeArray.Get(m_cModeArray.Count() - 1)) {
		case MODE_BOARD:
			((Cq2chwmApp*)AfxGetApp())->GetBoardView()->Copy();
			break;
		case MODE_SUBJECT:
			((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->Copy();
			break;
		case MODE_DAT:
			((Cq2chwmApp*)AfxGetApp())->GetDatView()->Copy();
			break;
		case MODE_BOOKMARK:
			((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->Copy();
			break;
		case MODE_CACHE:
			((Cq2chwmApp*)AfxGetApp())->GetCacheView()->Copy();
			break;
	};
}

void CMainFrame::AddHistory(
	MODE mode)
{
	if (m_cModeArray.Count() == 0 || (int)m_cModeArray.Get(m_cModeArray.Count() - 1) != (int)mode) {
		m_cModeArray.Add((int)mode);
	}
}

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (pMsg->message == WM_KEYDOWN) {
		// r[ɈˑȂL[oCh
		TRACE(_T("CMainFrame::PreTranslateMessage: WM_KEYDOWN(%d)\n"), pMsg->wParam);
		if (Cq2chwmConfig::GetInstance()->IsKeyFind2ch(pMsg->wParam)) {
			SendMessage(WM_COMMAND, ID_FIND2CH, 0);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyMenu(pMsg->wParam)) {
			SendMessage(WM_USER_POPUPMENU);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeySearch(pMsg->wParam)) {
			SendMessage(WM_USER_SHOWSEARCHBAR, 0, (LPARAM)TRUE);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyOnline(pMsg->wParam)) {
			Cq2chwmConfig::GetInstance()->SetOnline(!Cq2chwmConfig::GetInstance()->GetOnline());
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyOpenBookmark(pMsg->wParam)) {
			SendMessage(WM_USER_OPENBOOKMARK, 0, 0);
			return TRUE;
		}
	}
	return CFrameWnd::PreTranslateMessage(pMsg);
}

long CMainFrame::OnOpenUrl(
	WPARAM wParam,
	LPARAM lParam)
{
	const char *chp_url = (const char*)lParam;
	CYoRegex cRegexSubject("([^./]+\\.(2ch\\.net|bbspink\\.com)/([^./]+))");
	CYoRegex cRegex("[h]*ttp://([^./]+\\.[^./]+\\.[^./]+)/test/read\\.cgi/([a-zA-Z0-9]+)/([0-9]+)[/]*([0-9]*)");
	CYoRegex cRegexKako("[h]*ttp://([^./]+\\.[^./]+\\.[^./]+)/([a-zA-Z0-9]+)/kako/[0-9]+/[0-9]+/([0-9]+)\\.(html|dat.gz)");
	CYoRegex cRegexMachiBbs("[h]*ttp://([^./]+\\.[^./]+\\.[^./]+)/bbs/read\\.(pl|cgi)\\?BBS=([a-zA-Z0-9]+)&KEY=([0-9]+)");
	CYoRegex cRegexJBbs("[h]*ttp://([^./]+\\.[^./]+\\.[^./]+/[^./]+)/bbs/read\\.(pl|cgi)\\?BBS=([a-zA-Z0-9]+)&KEY=([0-9]+)");
	CYoRegex cRegexJBbs2("[h]*ttp://([^./]+\\.[^./]+\\.[^./]+)/bbs/read\\.(pl|cgi)\\/([a-zA-Z0-9]+)/([0-9]+)/([0-9]+)[/]?([0-9]*)");
	CYoRegex cRegexJBbs3("[h]*ttp://([^./]+\\.[^./]+\\.[^./]+)/test/read\\.(pl|cgi)\\?bbs=([a-zA-Z0-9]+)&key=([0-9]+)");
	CYoRegex cRegexLiveSoccer("[h]*ttp://([^./]+\\.[^./]+\\.[^./]+)/test/read\\.(pl|cgi)\\?bbs=([a-zA-Z0-9]+)&key=([0-9]+)");
	CYoRegex cRegexLiveSoccerExt1("[h]*ttp://([^./]+\\.[^./]+\\.[^./]+\\.[^./]+/[^./]+/)test/read\\.(pl|cgi)\\?bbs=([a-zA-Z0-9]+)&key=([0-9]+)");
	CYoRegex cRegexLiveSoccerExt2("[h]*ttp://([^./]+\\.[^./]+\\.[^./]+\\.[^./]+/[^./]+/)test/read\\.(pl|cgi)/([a-zA-Z0-9]+)/([0-9]+)");
	CYoRegex cRegexImage("[h]*ttp://.+\\.(gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG)$");
	if (cRegex.Match(chp_url) >= 0) {
		// Q˂
		CYoString str_host = cRegex.Get(1);
		CYoString str_bid = cRegex.Get(2);
		CYoString str_aid = cRegex.Get(3);
		CYoString str_no = cRegex.Get(4);
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid);
		//CQ2chDatViewManager::GetInstance()->Curr()->JumpMessageNo( (const char *)str_no );
	} else if(cRegexKako.Match(chp_url) >= 0) {
		// Q˂(ߋ)
		CYoString str_host = cRegexKako.Get(1);
		CYoString str_bid = cRegexKako.Get(2);
		CYoString str_aid = cRegexKako.Get(3);
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid);
	} else if(cRegexMachiBbs.Match(chp_url) >= 0) {
		// ܂BBS
		CYoString str_host = cRegexMachiBbs.Get(1);
		CYoString str_bid = cRegexMachiBbs.Get(3);
		CYoString str_aid = cRegexMachiBbs.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart("START=([0-9]+)");
		if (cRegexStart.Match(chp_url) >= 0) {
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid);
//			CQ2chDatViewManager::GetInstance()->Curr()->JumpMessageNo( (const char *)str_no );
	} else if (cRegexJBbs.Match(chp_url) >= 0) {
		// JBBS
		CYoString str_host = cRegexJBbs.Get(1);
		CYoString str_bid = cRegexJBbs.Get(3);
		CYoString str_aid = cRegexJBbs.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart("START=([0-9]+)");
		if (cRegexStart.Match(chp_url) >= 0) {
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid);
		if (str_no.Length() > 0) {
//			CQ2chDatViewManager::GetInstance()->Curr()->JumpMessageNo( (const char *)str_no );
		}
	} else if(cRegexJBbs2.Match(chp_url) >= 0) {
		// JBBS(PATH_INFO)
		CYoString str_host = cRegexJBbs2.Get(1);
		CYoString str_cat = cRegexJBbs2.Get(3); //̃JeS[
		CYoString str_bid = cRegexJBbs2.Get(4);
		CYoString str_aid = cRegexJBbs2.Get(5);
		CYoString str_no = cRegexJBbs2.Get(6);
		str_no = str_no.Atoi();
		CYoString str_burl;
		str_burl.Format("http://%s/%s/%s/", (const char*)str_host, (const char *)str_cat, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid);
//		CQ2chDatViewManager::GetInstance()->Curr()->JumpMessageNo( (const char *)str_no );
	} else if(cRegexJBbs3.Match(chp_url) >= 0) {
		// JBBS
		CYoString str_host = cRegexJBbs3.Get(1);
		CYoString str_bid = cRegexJBbs3.Get(3);
		CYoString str_aid = cRegexJBbs3.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart("START=([0-9]+)");
		if (cRegexStart.Match(chp_url) >= 0) {
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid);
		if (str_no.Length() > 0) {
//			CQ2chDatViewManager::GetInstance()->Curr()->JumpMessageNo( (const char *)str_no );
		}
	} else if (cRegexLiveSoccer.Match( chp_url ) >= 0) {
		// TbJ[
		CYoString str_host = cRegexLiveSoccer.Get(1);
		CYoString str_bid = cRegexLiveSoccer.Get(3);
		CYoString str_aid = cRegexLiveSoccer.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart("START=([0-9]+)");
		if (cRegexStart.Match(chp_url) >= 0) {
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid);
		if (str_no.Length() > 0) {
//			CQ2chDatViewManager::GetInstance()->Curr()->JumpMessageNo( (const char *)str_no );
		}
	} else if (cRegexLiveSoccerExt1.Match( chp_url ) >= 0) {
		// TbJ[ URLp^[1
		CYoString str_host = cRegexLiveSoccerExt1.Get(1);
		CYoString str_bid = cRegexLiveSoccerExt1.Get(3);
		CYoString str_aid = cRegexLiveSoccerExt1.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart( "START=([0-9]+)" );
		if( cRegexStart.Match(chp_url) >= 0 ){
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format( "http://%s/%s/", (const char*)str_host, (const char*)str_bid );
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid);
		if (str_no.Length() > 0) {
//			CQ2chDatViewManager::GetInstance()->Curr()->JumpMessageNo( (const char *)str_no );
		}
	} else if (cRegexLiveSoccerExt2.Match( chp_url ) >= 0) {
		// TbJ[ URLp^[2
		CYoString str_host = cRegexLiveSoccerExt2.Get(1);
		CYoString str_bid = cRegexLiveSoccerExt2.Get(3);
		CYoString str_aid = cRegexLiveSoccerExt2.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart("START=([0-9]+)");
		if (cRegexStart.Match(chp_url) >= 0) {
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid);
		if( str_no.Length() > 0 ){
//			CQ2chDatViewManager::GetInstance()->Curr()->JumpMessageNo( (const char *)str_no );
		}
	} else if (cRegexSubject.Match(chp_url) >= 0) {
		// Subject[h (ex. http://wwwww.2ch.net/news4vip/)
		CYoString str_burl;
		str_burl.Format("http://%s/", cRegexSubject.Get(1));
		CYoString str_bid = cRegexSubject.Get(3);
		CYoString str_bname;
		int in_index = ((Cq2chwmApp*)AfxGetApp())->GetBoardView()->SearchFromId(str_bid);
		if (in_index >= 0) {
			str_bname = ((Cq2chwmApp*)AfxGetApp())->GetBoardView()->GetBoardName(in_index);
		}
		((Cq2chwmApp*)AfxGetApp())->ShowSubjectView();
		((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->CreateFromFile(str_bname, str_burl, str_bid);
	} else {
		if (strlen(Cq2chwmConfig::GetInstance()->GetBrowser()) == 0) {
			ErrorMessageBox(ERR_CONF_BROWSER);
			return 0;
		}
		CString cstr_url;
		if (*chp_url == 't') {
			cstr_url = chp_url;
			cstr_url = _T("h") + cstr_url;
		} else {
			cstr_url = chp_url;
		}

		PROCESS_INFORMATION pi;
		CString cstr_image;
		cstr_image = Cq2chwmConfig::GetInstance()->GetBrowser();
		BOOL bo_ret;
#ifdef WIN32_PLATFORM_PSPC
		bo_ret = ::CreateProcess(cstr_image, cstr_url, NULL, NULL, FALSE, 0, NULL, NULL, NULL, &pi);
#else
		STARTUPINFO si;
		ZeroMemory(&si, sizeof(si));
		si.cb = sizeof(si);
		LPWSTR wchp_cmd = cstr_url.GetBuffer(cstr_url.GetLength() + 1);
		bo_ret = ::CreateProcess(cstr_image, wchp_cmd, NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi);
		cstr_url.ReleaseBuffer();
#endif
		if (bo_ret == FALSE) {
			::MessageBox(m_hWnd, _T("uEŰNɎs܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
		}
	}
	return 0;
}
