#include "stdafx.h"
#include "q2chwmBbsLivedoor.h"
#include "q2chwmInfoFile.h"

//! Ύ擾NX
/*!
 * 
 * \param pParent 
 * \param chp_dir 
 * \param chp_id 
 * \param chp_url 
 */
Cq2chwmBbsLivedoor::Cq2chwmBbsLivedoor(
	CWnd *pParent,
	const char *chp_id,
	const char *chp_url) : Cq2chwmBbs(pParent, chp_id, chp_url)
{
}

//! GETNGXg̃`FbN
/*!
 * ΂HTTPX|Xwb_`FbN
 * \return int 
 */
int Cq2chwmBbsLivedoor::OpenUrlCheck()
{
	// HTTPX|Xwb_ERROR: 炵(see. http://blog.livedoor.jp/bbsnews/archives/50283526.html)
	CYoString str_error = m_cHttp.GetResponseHeader("ERROR");
	if (str_error.Length() > 0) {
		if (str_error == "BBS NOT FOUND") {
			return ERR_JBBS_BBS_NOT_FOUND;
		} else if (str_error == "KEY NOT FOUND") {
			return ERR_JBBS_KEY_NOT_FOUND;
		} else if (str_error == "THREAD NOT FOUND") {
			return ERR_JBBS_THREAD_NOT_FOUND;
		} else if (str_error == "STORAGE IN") {
			return ERR_JBBS_STORAGE_IN;
		} else {
			return ERR_JBBS_SYSTEM;
		}
	}

	return ERR_NONE;
}

//! URL`FbN
/*!
 * http://jbbs.livedoor.jp/auto/374/
 * \return BOOL 
 */
BOOL Cq2chwmBbsLivedoor::MatchUrl()
{
	CYoRegex cRegex("http://jbbs\\.livedoor\\.jp/([^/?]+)/([^/?]+)", TRUE);
	return cRegex.Match(GetBoardUrl()) >= 0 ? TRUE : FALSE;
}

//! URL
/*!
 * http://jbbs.livedoor.jp/auto/374/
 * 
 * http://jbbs.livedoor.jp/bbs/rawmode.cgi/auto/374/1028678126/100-n
 * \return CYoString 
 */
CYoString Cq2chwmBbsLivedoor::GetUrl()
{
	CYoString str_url;

	// URLJeSAXbh擾
	CYoString str_category;
	CYoString str_board;
	{
		CYoRegex cRegex("http://jbbs\\.livedoor\\.jp/([^/?]+)/([^/?]+)");
		if (cRegex.Match(GetBoardUrl()) >= 0) {
			str_category = cRegex.Get(1); // JeS
			str_board = cRegex.Get(2); // X
		} else {
			// MatchUrlŃ}b`Ă邩炱͂Ȃ͂
			return CYoString();
		}
	}

	// 擾ς݃X擾
	int in_count = Cq2chwmInfoFile::Count(GetBoardUrl(), GetArticleId());
	if (in_count == -1) {
		// DATt@CȂ
		str_url.Format("http://jbbs.livedoor.jp/bbs/rawmode.cgi/%s/%s/%s/%d-",
					   (const char*)str_category, (const char*)str_board, GetArticleId(), 1);
	} else {
		str_url.Format("http://jbbs.livedoor.jp/bbs/rawmode.cgi/%s/%s/%s/%d-n",
					   (const char*)str_category, (const char*)str_board, GetArticleId(), in_count+1);
	}

	return str_url;
}

//! HTTPNCAg̃IvVݒ
/*!
 * ΂͓ɕKvȂ
 * \return int 
 */
int Cq2chwmBbsLivedoor::ModifyHttp()
{
	return ERR_NONE;
}

//! DATt@CݑÕtH[}bgϊ
/*!
 * JBBS`2ch`փtH[}bgϊ
 * [Xԍ(0)]<>[O(1)]<>[[(2)]<>[t(3)]<>[Rg(4)]<>[Xbh(5)]<>[ID(6)]
 * 
 * [O]<>[[]<>[t] ID:[ID]<>[Rg]<>[Xbh^Cg]
 * \param str_buff 
 * \return int 
 */
int Cq2chwmBbsLivedoor::WriteFileConvert(
	CYoString &str_buff)
{
	// 2chdat`ɕϊ
	CYoString str_convert;
	char *chp_sta = str_buff;
	char *chp_end;
	while ((chp_end = strchr(chp_sta, '\n'))) {
		// JBBS`: [Xԍ(0)]<>[O(1)]<>[[(2)]<>[t(3)]<>[Rg(4)]<>[Xbh(5)]<>[ID(6)]
		*chp_end = 0x00;
		CYoDataArray cArray = CYoDataArray::CreateStringArray(chp_sta, "<>");
		*chp_end = '\n';
		if (cArray.Count() != 7) {
			return ERR_FILE_CONVERT;
		}
		CYoString str_name = (char*)cArray.Get(1);
		CYoString str_mail = (char*)cArray.Get(2);
		CYoString str_date = (char*)cArray.Get(3);
		CYoString str_comment = (char*)cArray.Get(4);
		CYoString str_bname = (char*)cArray.Get(5);
		CYoString str_id = (char*)cArray.Get(6);
		// 2ch`: [O]<>[[]<>[t] ID:[ID]<>[Rg]<>[Xbh^Cg]
		str_convert.FormatAdd("%s<>%s<>%s ID: %s<>%s<>%s\n",
						  (const char*)str_name, (const char*)str_mail, (const char *)str_date,
						  (const char*)str_id, (char*)str_comment, (char*)str_bname);
		chp_sta = chp_end + 1;
	}
	str_convert.ConvertKCodeEx(CYoString::EUCTOSJIS);
	str_buff = str_convert;

	return ERR_NONE;
}
