#include "stdafx.h"
#include "q2chwmBbsMachi.h"
#include "q2chwmInfoFile.h"

//! ܂BBS擾NX
/*!
 * 
 * \param pParent 
 * \param chp_dir 
 * \param chp_id 
 * \param chp_url 
 */
Cq2chwmBbsMachi::Cq2chwmBbsMachi(
	CWnd *pParent,
	const char *chp_id,
	const char *chp_url) : Cq2chwmBbs(pParent, chp_id, chp_url)
{
	m_in_line = 0;
}

//! GETNGXg̃`FbN
/*!
 * ܂BBS̓`FbN̕KvȂ
 * \return int 
 */
int Cq2chwmBbsMachi::OpenUrlCheck()
{
	return ERR_NONE;
}

//! URL
/*!
 * http://kinki.machibbs.com/kinki
 * \return BOOL 
 */
BOOL Cq2chwmBbsMachi::MatchUrl()
{
	CYoRegex cRegex("http://(.+\\.machibbs\\.com)/([^/?]+)|http://(.+\\.machi\\.to)/([^/?]+)", TRUE);
	return cRegex.Match(GetBoardUrl()) >= 0 ? TRUE : FALSE;
}

//! URL
/*!
 * http://kinki.machibbs.com/kinki
 * 
 * http://kinki.machibbs.com/bbs/read.pl?BBS=kinki&KEY=1047798597&NOFIRST=TRUE&START=50
 * \return CYoString 
 */
CYoString Cq2chwmBbsMachi::GetUrl()
{
	CYoString str_url;

	// URLgݗ
	CYoRegex cRegex("http://(.+\\.machibbs\\.com)/([^/?]+)|http://(.+\\.machi\\.to)/([^/?]+)");
	CYoString str_bbs;
	CYoString str_host;
	if (cRegex.Match(GetBoardUrl()) >= 0 ) {
		if (strlen(cRegex.Get(1)) > 0) {
			str_host = cRegex.Get(1);
			str_bbs = cRegex.Get(2);
		} else {
			str_host = cRegex.Get(3);
			str_bbs = cRegex.Get(4);
		}
	} else {
		return CYoString();
	}

	// 擾ς݃X擾
	int in_count = Cq2chwmInfoFile::Count(GetBoardUrl(), GetArticleId());
	if (in_count == -1) {
		str_url.Format("http://%s/bbs/read.pl?BBS=%s&KEY=%s&NOFIRST=FALSE&START=%d", 
					   (const char*)str_host, (const char*)str_bbs, GetArticleId(), 1);
		m_in_line = 1;
	} else {
		str_url.Format("http://%s/bbs/read.pl?BBS=%s&KEY=%s&NOFIRST=TRUE&START=%d", 
					   (const char*)str_host, (const char*)str_bbs, GetArticleId(), in_count+1);
		m_in_line = in_count + 1;
	}

	return str_url;
}

//! HTTPNCAg̃IvVݒ
/*!
 * ܂BBS͓ɕKvȂ
 * \return int 
 */
int Cq2chwmBbsMachi::ModifyHttp()
{
	return ERR_NONE;
}

//! DATt@CݑÕtH[}bgϊ
/*!
 * ܂BBS擾HTML2ch`ɕϊ
 * \param str_buff 
 * \return int 
 */
#define TITLE_START		"<title>"
#define TITLE_END		"</title>"
#define MESSAGE1_START		"<dt>"
#define MESSAGE2_START		" ]"
int Cq2chwmBbsMachi::WriteFileConvert(
	CYoString &str_buff)
{
	CYoString str_convert;
	CYoString str_tmp;
	char *chp_sta = str_buff;
	char *chp_end;
	while ((chp_end = strchr(chp_sta, '\n')) != NULL) {
		*chp_end = 0x00;
		if (*(chp_sta+strlen(chp_sta)-1) == '\r') *(chp_sta+strlen(chp_sta)-1) = 0x00;

		// Xbh擾<title>Xbh</title>
		if (strncmp(chp_sta, TITLE_START, strlen(TITLE_START)) == 0) {
			char *chp_tsta = chp_sta + strlen(TITLE_START);
			char *chp_tend = strrchr(chp_tsta, '<');
			if (chp_tend == NULL) {
				return ERR_FILE_CONVERT;
			}
			m_str_title.StrnCpy(chp_tsta, chp_tend-chp_tsta);
		}

		// bZ[W(1sŊꍇ2s1X̏ꍇ)
		if (strncmp(chp_sta, MESSAGE1_START, strlen(MESSAGE1_START)) == 0 ||
			strncmp(chp_sta, MESSAGE2_START, strlen(MESSAGE2_START)) == 0)
		{
			// O
			{
				str_tmp = "([0-9]+) OF<[^>]+><b>(.+)<\\/b>";
				str_tmp.ConvertKCodeEx(CYoString::EUCTOSJIS);
				CYoRegex cRegexName(str_tmp, CYoRegex::SJIS, TRUE);
				if (cRegexName.Match(chp_sta) >= 0) {
					if (m_str_name.Length() > 0) {
						// RgEĂȂ̂ɖO邱ƂɂȂ̂ŃG[
						return ERR_FILE_CONVERT;
					}
					m_str_no = cRegexName.Get(1);
					m_str_name = cRegexName.Get(2);
					deleteTag(m_str_name);
					m_str_name.Trim();
				}
			}

			// [
			{
				CYoRegex cRegexMail("mailto:([^\"]*)\"", CYoRegex::SJIS, TRUE);
				if (cRegexMail.Match(chp_sta) >= 0) {
					m_str_mail = cRegexMail.Get(1);
					m_str_mail.Trim();
				}
			}

			// t
			{
				str_tmp = "eF ([^<]+)<";
				str_tmp.ConvertKCodeEx(CYoString::EUCTOSJIS);
				CYoRegex cRegexDate(str_tmp, CYoRegex::SJIS, TRUE);
				if (cRegexDate.Match(chp_sta) >= 0) {
					m_str_date = cRegexDate.Get(1);
					m_str_date.Trim();
				}
			}

			// zXg(n)
			{
				CYoRegex cRegexHost("\\[ ([^<]+)$", CYoRegex::SJIS, TRUE);
				if (cRegexHost.Match(chp_sta) >= 0) {
					m_str_host = cRegexHost.Get(1);
					m_str_host.Trim();
					m_str_host.Format(" [%s]", (const char*)m_str_host);
				}
			}

			// Rg
			{
				CYoRegex cRegexComment("<br><dd>(.*)<br><br>$", CYoRegex::SJIS, TRUE);
				if (cRegexComment.Match(chp_sta) >= 0) {
					m_str_comment = cRegexComment.Get(1);
					m_str_comment.Trim();
				}
			}
		}

		// RgŖOtȂȂzOƂƂŃG[
		if (m_str_comment.Length() > 0 && (m_str_name.Length() == 0 || m_str_date.Length() == 0)) {
			return ERR_FILE_CONVERT;
		}

		// S2ch`
		if (m_str_name.Length() > 0 && m_str_date.Length() > 0 && m_str_comment.Length() > 0) {
			// ԍł镪𖄂߂
			while( m_in_line < atoi(m_str_no) ){
				CYoString str_blank = "<><><><>\n";
				str_blank.ConvertKCodeEx(CYoString::EUCTOSJIS);
				str_convert += str_blank;
				m_in_line++;
			}

			if (m_in_line == 1) {
				// ^Cgt
				str_convert.FormatAdd("%s<>%s<>%s%s<>%s<>%s\n", (const char*)m_str_name, (const char*)m_str_mail,
									  (const char*)m_str_date, (const char*)m_str_host, (const char*)m_str_comment, (const char*)m_str_title);
			} else {
				// ^CgȂ
				str_convert.FormatAdd("%s<>%s<>%s%s<>%s<>\n", (const char*)m_str_name, (const char*)m_str_mail,
									  (const char*)m_str_date, (const char*)m_str_host, (const char*)m_str_comment);
			}

			// Zbg
			m_str_name = "";
			m_str_mail = "";
			m_str_date = "";
			m_str_host = "";
			m_str_comment = "";
			m_in_line++;
		}

		chp_sta = chp_end + 1; 
	}

	str_buff = str_convert;

	return ERR_NONE;
}

//! ^O폜
/*!
 * <...>폜
 * \param chp_html 
 * \return void 
 */
void Cq2chwmBbsMachi::deleteTag(
	char *chp_html)
{
	char *chp_sta = chp_html;
	char *chp_end;

	while ((chp_sta = strchr(chp_sta, '<')) != NULL) {
		chp_end = strchr(chp_sta, '>');
		if (chp_end == NULL) break;
		memmove(chp_sta, chp_end+1, strlen(chp_end+1)+1);
	}
}
