#pragma once

#include "YoString.h"
#include "YoTable.h"
#include "YoRegex.h"

//! NG[ht@CǗNX
/*!
 * 
 */
class Cq2chwmNgFile : public CYoTable
{
private:
	CYoRegex m_cRegex;
	static Cq2chwmNgFile *m_pInstance;

	Cq2chwmNgFile();
	static void Delete();

public:
	~Cq2chwmNgFile();

	BOOL Create();
	static Cq2chwmNgFile *GetInstance();
	CYoString GetPattern(const char *chp_url, const char *chp_id);
	inline const char *GetUrl(int in_index){ return Get(in_index, 0); }
	inline const char *GetNg(int in_index){ return Get(in_index, 1); }
	inline void AddNg(const char *chp_url, const char *chp_ng){ Add(chp_url, chp_ng, NULL); }
	inline void InsertNg(const char *chp_url, const char *chp_ng){ Insert(0, chp_url, chp_ng, NULL); }
	BOOL Write();
};
