#pragma once

#include "YoPtrArray.h"
#include "q2chwmBookmarkFile.h"
#include "q2chwmBookmarkItem.h"
#include "q2chwmListView.h"

// Cq2chwmBookmarkView r[

class Cq2chwmBookmarkView : public Cq2chwmListView
{
//	DECLARE_DYNCREATE(Cq2chwmBookmarkView)

private:
	CYoPtrArray m_cArrayThread;
	BOOL m_bo_running;
	BOOL m_bo_create;
	CWinThread *m_pThread;

private:
	void createList();
	void clearList();

	//static DWORD WINAPI ThreadProc(LPVOID lpParameter);
	static UINT __cdecl ThreadProc(LPVOID lpParameter);
	static UINT __cdecl ThreadReloadProc(LPVOID lpParameter);
	void waitThread(BOOL bo_all);

protected:
	void OnListClicked();
//	int Compare(Cq2chwmListItem *pItem1, Cq2chwmListItem *pItem2, int in_col, BOOL bo_asc);
	void SortItems(int in_col, BOOL bo_asc);
	virtual BOOL GetItemText(LPTSTR wchp_text, int in_size, int in_row, int in_col);

public:
	BOOL CreateFromFile();
	void SetFont();
	BOOL AddBookmark(const char *chp_aname, const char *chp_aid,
		const char *chp_bname, const char *chp_burl, const char *chp_bid);
	void UpdateItem(const char *chp_filename);
	afx_msg long OnCustomMessage(WPARAM wParam, LPARAM lParam);
	void Sort();
	void Search(const char *chp_word);
	Cq2chwmListItem *GetSelectedItem();
	Cq2chwmListItem *GetItem(int iRow);
	Cq2chwmListItem *GetItem(const char *chp_filename);
	inline BOOL IsRunning(){ return m_bo_running; }
	Cq2chwmBookmarkItem *GetNextItem(const char *chp_filename);

public:
	Cq2chwmBookmarkView();           // IŎgp protected RXgN^
	virtual ~Cq2chwmBookmarkView();

public:
//	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual void OnInitialUpdate();
public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
public:
	afx_msg void OnDestroy();
public:
	afx_msg void OnReload();
	afx_msg void OnDelete();
	afx_msg void OnSortArticleId();
	afx_msg void OnUpdateSortArticleId(CCmdUI *pCmdUI);
	afx_msg void OnSortArticleName();
	afx_msg void OnUpdateSortArticleName(CCmdUI *pCmdUI);
	afx_msg void OnSortBoardName();
	afx_msg void OnUpdateSortBoardName(CCmdUI *pCmdUI);
	afx_msg void OnSortCount();
	afx_msg void OnUpdateSortCount(CCmdUI *pCmdUI);
	afx_msg void OnSortIndex();
	afx_msg void OnUpdateSortIndex(CCmdUI *pCmdUI);
	afx_msg void OnSortNew();
	afx_msg void OnUpdateSortNew(CCmdUI *pCmdUI);
	afx_msg void OnSortSearch();
	afx_msg void OnUpdateSortSearch(CCmdUI *pCmdUI);
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnAdjustColumnWidth();
};


