// q2chwm.cpp : AvP[ṼNX`܂B
//

#include "stdafx.h"
#include "q2chwm.h"
#include "MainFrm.h"

#include "q2chwmCommon.h"
#include "q2chwmDoc.h"
#include "q2chwmView.h"
#include "q2chwmConfig.h"
#include "q2chwmBbsManager.h"
#include "q2chwmConfigDialog.h"

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
#else
#include <locale.h>
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// Cq2chwmApp

BEGIN_MESSAGE_MAP(Cq2chwmApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, &Cq2chwmApp::OnAppAbout)
	ON_COMMAND(ID_FILE_NEW, &CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, &CWinApp::OnFileOpen)
	ON_COMMAND(ID_CONFIG, &Cq2chwmApp::OnConfig)
	ON_COMMAND(ID_VIEW_ARTICLE, &Cq2chwmApp::OnViewArticle)
	ON_COMMAND(ID_VIEW_BOARD, &Cq2chwmApp::OnViewBoard)
	ON_COMMAND(ID_VIEW_BOOKMARK, &Cq2chwmApp::OnViewBookmark)
	ON_COMMAND(ID_VIEW_CACHE, &Cq2chwmApp::OnViewCache)
	ON_COMMAND(ID_VIEW_IMAGE, &Cq2chwmApp::OnViewImage)
	ON_COMMAND(ID_VIEW_SUBJECT, &Cq2chwmApp::OnViewSubject)
	ON_COMMAND(ID_ONLINE, &Cq2chwmApp::OnOnline)
	ON_UPDATE_COMMAND_UI(ID_ONLINE, &Cq2chwmApp::OnUpdateOnline)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ARTICLE, &Cq2chwmApp::OnUpdateViewArticle)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BOARD, &Cq2chwmApp::OnUpdateViewBoard)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BOOKMARK, &Cq2chwmApp::OnUpdateViewBookmark)
	ON_UPDATE_COMMAND_UI(ID_VIEW_IMAGE, &Cq2chwmApp::OnUpdateViewImage)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CACHE, &Cq2chwmApp::OnUpdateViewCache)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SUBJECT, &Cq2chwmApp::OnUpdateViewSubject)
	ON_COMMAND(ID_VIEW_CURRENTSUBJECT, &Cq2chwmApp::OnViewCurrentSubject)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CURRENTSUBJECT, &Cq2chwmApp::OnUpdateViewCurrentSubject)
	ON_COMMAND(ID_SEARCH_RELATEDSUBJECT, &Cq2chwmApp::OnSearchRelatedSubject)
	ON_UPDATE_COMMAND_UI(ID_SEARCH_RELATEDSUBJECT, &Cq2chwmApp::OnUpdateSearchRelatedSubject)
	ON_UPDATE_COMMAND_UI(ID_CONFIG, &Cq2chwmApp::OnUpdateConfig)
	ON_UPDATE_COMMAND_UI(ID_EXIT, &Cq2chwmApp::OnUpdateExit)
END_MESSAGE_MAP()



// Cq2chwmApp RXgNV
Cq2chwmApp::Cq2chwmApp()
	: CWinApp()
{
	// TODO: ̈ʒuɍ\zpR[hǉĂB
	//  InitInstance ̏dvȏׂċLqĂB
}


// B Cq2chwmApp IuWFNgłB
Cq2chwmApp theApp;

// Cq2chwmApp 

BOOL Cq2chwmApp::InitInstance()
{
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	// CAPEDIT  SIPPREF ̂悤 Pocket PC ̓ʂȃRg[ɂ́AAvP[V
    //  SHInitExtraControls xĂяoKv܂B
    SHInitExtraControls();
#else
	// TRACEœ{ꂪʂ悤ɂ
	_tsetlocale ( LC_ALL, _T("") );
#endif // WIN32_PLATFORM_PSPC || WIN32_PLATFORM_WFSP

	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// init@Cgp
	{
		wchar_t cha_inifile[MAX_PATH + 1];
		wchar_t *chp_ptr;
		CWinApp *pApp = AfxGetApp();

		GetModuleFileName(NULL, cha_inifile, MAX_PATH);
		chp_ptr = wcsrchr(cha_inifile, '.');
		if (chp_ptr == NULL) return FALSE;
		_tcscpy_s(chp_ptr, _tcslen(chp_ptr)+1, _T(".ini"));
		free((void*)pApp->m_pszProfileName);
		pApp->m_pszProfileName = _tcsdup(cha_inifile);	
	}

		// fobOݒ
	{
		wchar_t cha_dir[MAX_PATH + 1];
		wchar_t *chp_ptr;
		CWinApp *pApp = AfxGetApp();
		GetModuleFileName(NULL, cha_dir, MAX_PATH);
		chp_ptr = wcsrchr(cha_dir, '\\');
		if (chp_ptr != NULL) {
			*chp_ptr = 0x00;
			if (Cq2chwmConfig::GetInstance()->GetDebug() == TRUE) {
				CYoString str_dir = A(cha_dir);
				CYoObject::SetLogdir(str_dir);
				CYoObject::SetModule(APP_NAME);
				CYoObject::SetLoglevel(LEVEL_DEBUG);
			} else {
				CYoObject::SetLogdir("");
				CYoObject::SetModule("");
				CYoObject::SetLoglevel("");
			}
		}
	}

	// [gfBNg쐬
	{
		// SD̃}EgOĂꍇɃ[gfBNgɍ쐬Ă܂Ɩʓ|Ȃ̂
		// efBNg̑݃`FbN
		CYoString str_dir_parent = Cq2chwmConfig::GetInstance()->GetRootDirectory();
		char *chp_tmp = (char*)strrchr((const char*)str_dir_parent, '\\');
		if (chp_tmp == NULL) {
			// GUIݒ肵Ă΂͂肦Ȃ͂
			::MessageBox(NULL, _T("[gfBNgsł\n")_T(APP_NAME)_T("I܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
			return FALSE;
		}
		*chp_tmp = 0x00;
		if (ExistFile(str_dir_parent) == FALSE) {
			CString cstr_dir;
			cstr_dir = W(Cq2chwmConfig::GetInstance()->GetRootDirectory());
			CString cstr_message;
			cstr_message.Format(_T("[gfBNg쐬܂H"), cstr_dir);
			if (::MessageBox(NULL, cstr_message, _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDNO) {
				::MessageBox(NULL, _T(APP_NAME)_T("I܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
				return FALSE;
			}
		}
		// ܂łSă[gfBNg쐬ł
		if (MakeDirectory(Cq2chwmConfig::GetInstance()->GetRootDirectory()) == FALSE) {
			::MessageBox(NULL, _T("[gfBNg̍쐬Ɏs܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
			return FALSE;
		}
	}

	// W
	// ̋@\g킸ɁAŏIIȎs\t@C̃TCYkꍇ́A
	// ȉAsvȏ[`
	// 폜ĂB
	
	// ݒ肪i[Ă郌WXg L[ύX܂B
	// TODO: ̕AЖ܂͑gDȂǂ́A
	// K؂ȕɕύXĂB
	SetRegistryKey(_T("q2chwm, Navigator for 2ch for WindowsMobile"));
	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(Cq2chwmDoc),
		RUNTIME_CLASS(CMainFrame),       // C SDI t[ EBhE
		RUNTIME_CLASS(Cq2chwmView));
	if (!pDocTemplate)
		return FALSE;
	AddDocTemplate(pDocTemplate);

	// DDEAfile open ȂǕW̃VF R}h̃R}hC͂܂B
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// R}h CŎw肳ꂽfBXpb` R}hłBAvP[V
	// /RegServerA/RegisterA/Unregserver ܂ /Unregister ŋNꂽꍇAFALSE Ԃ܂B
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// C EBhEꂽ̂ŁA\ƍXVs܂
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	// r[쐬
	CDocument* pCurrentDoc = ((CFrameWnd*)m_pMainWnd)->GetActiveDocument();
	CCreateContext newContext;
	newContext.m_pNewViewClass = NULL;
	newContext.m_pNewDocTemplate = NULL;
	newContext.m_pLastView = NULL;
	newContext.m_pCurrentFrame = NULL;
	newContext.m_pCurrentDoc = pCurrentDoc;
    CRect rect(0, 0, 0, 0);

//	_CrtSetBreakAlloc(2109);
	// r[쐬
	m_pBoardView = new Cq2chwmBoardView;
	m_pBoardView->Create(NULL, NULL, (AFX_WS_DEFAULT_VIEW & ~WS_VISIBLE), rect, m_pMainWnd, AFX_IDW_PANE_FIRST + 1, &newContext);
	m_pBoardView->OnInitialUpdate();
	m_pSubjectView = new Cq2chwmSubjectView;
	m_pSubjectView->Create(NULL, NULL, (AFX_WS_DEFAULT_VIEW & ~WS_VISIBLE), rect, m_pMainWnd, AFX_IDW_PANE_FIRST + 2, &newContext);
	m_pSubjectView->OnInitialUpdate();
	m_pDatView = new Cq2chwmDatView;
	m_pDatView->Create(NULL, NULL, (AFX_WS_DEFAULT_VIEW & ~WS_VISIBLE), rect, m_pMainWnd, AFX_IDW_PANE_FIRST + 3, &newContext);
	m_pDatView->OnInitialUpdate();
	m_pCacheTabView = new Cq2chwmTabView;
	m_pCacheTabView->Create(NULL, NULL, (AFX_WS_DEFAULT_VIEW & ~WS_VISIBLE), rect, m_pMainWnd, AFX_IDW_PANE_FIRST + 4, &newContext);
	m_pCacheTabView->OnInitialUpdate();
	m_pCacheImageView = new Cq2chwmCacheImageView;
	m_pCacheImageView->Create(NULL, NULL, (AFX_WS_DEFAULT_VIEW & ~WS_VISIBLE), rect, m_pCacheTabView, AFX_IDW_PANE_FIRST + 5, &newContext);
	m_pCacheImageView->OnInitialUpdate();
	m_pCacheView = new Cq2chwmCacheView;
	m_pCacheView->Create(NULL, NULL, (AFX_WS_DEFAULT_VIEW & ~WS_VISIBLE), rect, m_pCacheTabView, AFX_IDW_PANE_FIRST + 6, &newContext);
	m_pCacheView->OnInitialUpdate();
	m_pBookmarkTabView = new Cq2chwmTabView;
	m_pBookmarkTabView->Create(NULL, NULL, (AFX_WS_DEFAULT_VIEW & ~WS_VISIBLE), rect, m_pMainWnd, AFX_IDW_PANE_FIRST + 7, &newContext);
	m_pBookmarkTabView->OnInitialUpdate();
	m_pBookmarkView = new Cq2chwmBookmarkView;
	m_pBookmarkView->Create(NULL, NULL, (AFX_WS_DEFAULT_VIEW & ~WS_VISIBLE), rect, m_pBookmarkTabView, AFX_IDW_PANE_FIRST + 8, &newContext);
	m_pBookmarkView->OnInitialUpdate();
	m_pBookmarkBoardView = new Cq2chwmBookmarkBoardView;
	m_pBookmarkBoardView->Create(NULL, NULL, (AFX_WS_DEFAULT_VIEW & ~WS_VISIBLE), rect, m_pBookmarkTabView, AFX_IDW_PANE_FIRST + 9, &newContext);
	m_pBookmarkBoardView->OnInitialUpdate();
	m_pImageView = new Cq2chwmImageView;
	m_pImageView->Create(NULL, NULL, (AFX_WS_DEFAULT_VIEW & ~WS_VISIBLE), rect, m_pMainWnd, AFX_IDW_PANE_FIRST + 10, &newContext);
	m_pImageView->OnInitialUpdate();

	// LbVr[̃^uɃr[ǉ
	m_pCacheTabView->AddView(m_pCacheView, "Xbh");
	m_pCacheTabView->AddView(m_pCacheImageView, "摜");

	// ubN}[Nr[̃^uɃr[ǉ
	m_pBookmarkTabView->AddView(m_pBookmarkView, "Xbh");
	m_pBookmarkTabView->AddView(m_pBookmarkBoardView, "̑");

	// j[쐬
	/*
	m_cSubjectMenu.LoadMenu(IDR_MENU_SORT_SUBJECT);
	m_cBookmarkMenu.LoadMenu(IDR_MENU_SORT_BOOKMARK);
	m_cCacheMenu.LoadMenu(IDR_MENU_SORT_CACHE);
	*/

	// N͔ꗗ or ubN}[N
	if(Cq2chwmConfig::GetInstance()->GetBookmarkWhenStarting() == TRUE){		//	JnɃubN}[N
		ShowBookmarkView();
		((CMainFrame*)AfxGetMainWnd())->AddHistory(CMainFrame::MODE_BOOKMARK);
	} else {
		ShowBoardView();
	}

	// nEditEBhEo^
	Cq2chwmEditCtrl::Regist(AfxGetApp()->m_hInstance);

	return TRUE;
}

Cq2chwmApp::~Cq2chwmApp()
{
}

#define IDX_MENU_SORT	3
#define STR_MENU_SORT	_T("\[g")
void Cq2chwmApp::removeSortMenu()
{
	CString cstr_menu;
	AfxGetMainWnd()->GetMenu()->GetSubMenu(1)->GetMenuString(IDX_MENU_SORT, cstr_menu, MF_BYPOSITION);
	if (cstr_menu == STR_MENU_SORT) {
		AfxGetMainWnd()->GetMenu()->GetSubMenu(1)->RemoveMenu(IDX_MENU_SORT, MF_BYPOSITION);
	}
}

void Cq2chwmApp::insertSortMenu(
	CMenu &cMenu)
{
	BOOL bo_ret = AfxGetMainWnd()->GetMenu()->GetSubMenu(1)->InsertMenu(IDX_MENU_SORT, MF_BYPOSITION|MF_POPUP|MF_STRING,
		(UINT_PTR)cMenu.GetSubMenu(0)->m_hMenu, STR_MENU_SORT);
	TRACE(_T("%d\n"), ::GetLastError());
	AfxGetMainWnd()->DrawMenuBar();
}

void Cq2chwmApp::ShowBoardView()
{
	// ^CgύX
	CString cstr_title;
	cstr_title = _T(APP_NAME)_T("/")_T(APP_VERSION);
	AfxGetMainWnd()->SetWindowText(cstr_title);

	CView* pActiveView = ((CFrameWnd*)m_pMainWnd)->GetActiveView();
	if (pActiveView == NULL || pActiveView == m_pBoardView) return;
	//removeSortMenu();
	changeView(pActiveView, m_pBoardView);
}

void Cq2chwmApp::ShowSubjectView()
{
	CView* pActiveView = ((CFrameWnd*)m_pMainWnd)->GetActiveView();
	if (pActiveView == NULL || pActiveView == m_pSubjectView) return;
	//removeSortMenu();
	//insertSortMenu(m_cSubjectMenu);
	changeView(pActiveView, m_pSubjectView);
}

void Cq2chwmApp::ShowDatView()
{
	CView* pActiveView = ((CFrameWnd*)m_pMainWnd)->GetActiveView();
	if (pActiveView == NULL || pActiveView == m_pDatView) return;
	//removeSortMenu();
	changeView(pActiveView, m_pDatView);
}

void Cq2chwmApp::ShowCacheView()
{
	AfxGetMainWnd()->SetWindowText(_T("LbV"));
	CView* pActiveView = ((CFrameWnd*)m_pMainWnd)->GetActiveView();
	if (pActiveView == NULL || pActiveView == m_pCacheTabView) return;
	//removeSortMenu();
	//insertSortMenu(m_cCacheMenu);
	changeView(pActiveView, m_pCacheTabView);
	m_pCacheView->CreateList();
	m_pCacheImageView->CreateList();
}

void Cq2chwmApp::ShowImageView()
{
	AfxGetMainWnd()->SetWindowText(_T("摜"));
	CView* pActiveView = ((CFrameWnd*)m_pMainWnd)->GetActiveView();
	if (pActiveView == NULL || pActiveView == m_pImageView) return;
	changeView(pActiveView, m_pImageView);
}

void Cq2chwmApp::ShowBookmarkView()
{
	AfxGetMainWnd()->SetWindowText(_T("ubN}[N"));
	CView* pActiveView = ((CFrameWnd*)m_pMainWnd)->GetActiveView();
	if (pActiveView == NULL || pActiveView == m_pBookmarkTabView) return;
	//removeSortMenu();
	//insertSortMenu(m_cBookmarkMenu);
	changeView(pActiveView, m_pBookmarkTabView);
	m_pBookmarkView->CreateFromFile();
	m_pBookmarkBoardView->CreateFromFile();
}

void Cq2chwmApp::changeView(
	CView *pActiveView,
	CView *pNewView)
{
	UINT temp = ::GetWindowLong(pActiveView->m_hWnd, GWL_ID);
	::SetWindowLong(pActiveView->m_hWnd, GWL_ID, ::GetWindowLong(pNewView->m_hWnd, GWL_ID));
	::SetWindowLong(pNewView->m_hWnd, GWL_ID, temp);

    // Display and update the new current view - hide the old one    
	pActiveView->ShowWindow(SW_HIDE);
	pActiveView->SendMessage(WM_SHOWWINDOW, FALSE);
	pNewView->ShowWindow(SW_SHOW);
	pNewView->SendMessage(WM_SHOWWINDOW, TRUE);
	((CFrameWnd*)m_pMainWnd)->SetActiveView(pNewView);
	((CFrameWnd*)m_pMainWnd)->RecalcLayout();
	//pNewView->Invalidate();
}

// AvP[Ṽo[WɎg CAboutDlg _CAO
#include "q2chwmColorSelector.h"
class CAboutDlg : public CDialog
{
// FI{^eXg
private:
	Cq2chwmColorSelector m_cColorButton;

public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
#ifdef _DEVICE_RESOLUTION_AWARE
	afx_msg void OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/);
#endif
	virtual BOOL OnInitDialog();
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	return TRUE;	// tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
			// O: OCX vpeB y[W FALSE ԂȂ΂Ȃ܂
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
#ifdef _DEVICE_RESOLUTION_AWARE
	ON_WM_SIZE()
#endif
END_MESSAGE_MAP()

#ifdef _DEVICE_RESOLUTION_AWARE
void CAboutDlg::OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/)
{
	DRA::RelayoutDialog(
		AfxGetInstanceHandle(), 
		this->m_hWnd, 
		DRA::GetDisplayMode() != DRA::Portrait ? MAKEINTRESOURCE(IDD_ABOUTBOX_WIDE) : MAKEINTRESOURCE(IDD_ABOUTBOX));
}
#endif

// _CAOs邽߂̃AvP[V R}h
void Cq2chwmApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

void Cq2chwmApp::OnConfig()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CYoString str_dir_old = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	Cq2chwmConfigDialog cDialog;

	// URLƃXbhURLǉ
	CYoString str_burl = m_pDatView->GetCurrentBoardUrl();
	CYoString str_aurl = str_burl + m_pDatView->GetCurrentArticleId();
	cDialog.AddUrl(str_burl);
	cDialog.AddUrl(str_aurl);

	// JgbZ[WsƂɒǉ
	CYoDataArray cArray = CYoDataArray::CreateStringArray(m_pDatView->GetCurrentMessageText(), "\r\n");
	for (int i = 0; i < cArray.Count(); i++) {
		cDialog.AddText(cArray.Get(i));
	}

	// EBhE^Cg
	CString cstr_title;
	AfxGetMainWnd()->GetWindowText(cstr_title);
	AfxGetMainWnd()->SetWindowText(_T("q2chwmݒ"));
	if (cDialog.DoModal() == IDOK) {
		if (str_dir_old != Cq2chwmConfig::GetInstance()->GetRootDirectory()) {
			::AfxGetMainWnd()->MessageBox(_T("[gfBNgɕύX܂\nq2chI܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
			AfxGetMainWnd()->PostMessage(WM_CLOSE);
			return;
		}
		m_pBoardView->ReloadEtc();
		m_pBoardView->SetFont();
		m_pBoardView->SetColor();
		m_pSubjectView->SetFont();
		m_pDatView->SetFont();
		m_pBookmarkView->SetFont();
		m_pBookmarkBoardView->Reload();
		m_pBookmarkBoardView->SetFont();
		m_pBookmarkTabView->SetFont();
		m_pCacheView->SetFont();
		m_pCacheImageView->SetFont();
		m_pCacheTabView->SetFont();
	}
	AfxGetMainWnd()->SetWindowText(cstr_title);
}

void Cq2chwmApp::OnViewArticle()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowDatView();
	((CMainFrame*)AfxGetMainWnd())->AddHistory(CMainFrame::MODE_DAT);
	GetDatView()->SetWindowText();
}

void Cq2chwmApp::OnViewBoard()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowBoardView();
	((CMainFrame*)AfxGetMainWnd())->AddHistory(CMainFrame::MODE_BOARD);
}

void Cq2chwmApp::OnViewBookmark()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowBookmarkView();
	((CMainFrame*)AfxGetMainWnd())->AddHistory(CMainFrame::MODE_BOOKMARK);
}

void Cq2chwmApp::OnViewCache()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowCacheView();
	((CMainFrame*)AfxGetMainWnd())->AddHistory(CMainFrame::MODE_CACHE);
}

void Cq2chwmApp::OnViewImage()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowImageView();
	((CMainFrame*)AfxGetMainWnd())->AddHistory(CMainFrame::MODE_IMAGE);
}

void Cq2chwmApp::OnViewSubject()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowSubjectView();
	((CMainFrame*)AfxGetMainWnd())->AddHistory(CMainFrame::MODE_SUBJECT);
}

void Cq2chwmApp::OnOnline()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Cq2chwmConfig::GetInstance()->SetOnline(!Cq2chwmConfig::GetInstance()->GetOnline());
}

void Cq2chwmApp::OnUpdateOnline(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(Cq2chwmConfig::GetInstance()->GetOnline() == TRUE);
}

void Cq2chwmApp::OnUpdateViewArticle(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_pDatView->GetTabCount() > 0);
	pCmdUI->SetCheck(((CFrameWnd*)AfxGetMainWnd())->GetActiveView() == m_pDatView);
}

void Cq2chwmApp::OnUpdateViewBoard(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(((CFrameWnd*)AfxGetMainWnd())->GetActiveView() == m_pBoardView);
}

void Cq2chwmApp::OnUpdateViewBookmark(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(((CFrameWnd*)AfxGetMainWnd())->GetActiveView() == m_pBookmarkTabView);
}

void Cq2chwmApp::OnUpdateViewImage(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(((CFrameWnd*)AfxGetMainWnd())->GetActiveView() == m_pImageView);
}

void Cq2chwmApp::OnUpdateViewCache(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(((CFrameWnd*)AfxGetMainWnd())->GetActiveView() == m_pCacheTabView);
}

void Cq2chwmApp::OnUpdateViewSubject(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(((CFrameWnd*)AfxGetMainWnd())->GetActiveView() == m_pSubjectView);
	pCmdUI->Enable(strlen(m_pSubjectView->GetBoardUrl()) > 0);
}

void Cq2chwmApp::OnViewCurrentSubject()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (((CFrameWnd*)m_pMainWnd)->GetActiveView() != m_pDatView) return;
	GetSubjectView()->ResetSearchState();
	ShowSubjectView();
	GetSubjectView()->CreateFromFile(m_pDatView->GetCurrentBoardName(), m_pDatView->GetCurrentBoardUrl(), m_pDatView->GetCurrentBoardId());
	((CMainFrame*)AfxGetMainWnd())->AddHistory(CMainFrame::MODE_SUBJECT);
}

void Cq2chwmApp::OnUpdateViewCurrentSubject(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(((CFrameWnd*)m_pMainWnd)->GetActiveView() == m_pDatView);
}

void Cq2chwmApp::OnSearchRelatedSubject()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CYoString str_subject;
	if (((CFrameWnd*)m_pMainWnd)->GetActiveView() == m_pDatView) {
		OnViewCurrentSubject();
		str_subject = m_pDatView->GetCurrentArticleName();
	} else if (((CFrameWnd*)m_pMainWnd)->GetActiveView() == m_pSubjectView) {
		Cq2chwmListItem *pItem = m_pSubjectView->GetSelectedItem();
		if (pItem == NULL) {
			::MessageBox(m_pMainWnd->m_hWnd, _T("XbhIĉ"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
			return;
		}
		str_subject = pItem->GetArticleName();
	} else {
		return;
	}
	PRINTLOG("%s", (const char*)str_subject);

	// SJIS2oCgڂɓL܂܂邽EUCɕϊ
	str_subject.ConvertKCodeEx(CYoString::SJISTOEUC);

	// [h
	if (::MessageBox(m_pMainWnd->m_hWnd, _T("XbhꗗŐV܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		if (m_pSubjectView->Reload() == FALSE) return;
	}

	// RgAEg
	char *chpa_regkeys[] = {
		"\\", ".", "+", "*", "^", "$", "|", "?"
	};
	for (unsigned int i = 0; i < sizeof(chpa_regkeys) / sizeof(chpa_regkeys[0]); i++) {
		CYoString str_after = "\\";
		str_after += chpa_regkeys[i];
		str_subject.Replace(chpa_regkeys[i], str_after);
	}

	// ŏ(Tu^CgIȁyhogez݂Ȃ̂܂邲ƍ폜)
	char *chpa_keys[][2] = {
		{"y", "z"},
		{"[", "]"},
// ͋Ɏg邱Ƃ悤		{"u", "v"},
		{"<", ">"},
		{"q", "r"},
		{"s", "t"},
		{"w", "x"},
		{"{", "}"},
		{"(", ")"},
	};
	for (unsigned int i = 0; i < sizeof(chpa_keys) / sizeof(chpa_keys[0]); i++) {
		int in_sta;
		int in_end;
		CYoString str_sta = chpa_keys[i][0];
		str_sta.ConvertKCodeEx(CYoString::SJISTOEUC);
		while((in_sta = str_subject.Find(str_sta)) >= 0) {
			CYoString str_end = chpa_keys[i][1];
			str_end.ConvertKCodeEx(CYoString::SJISTOEUC);
			in_end = str_subject.Find(str_end, in_sta + strlen(chpa_keys[i][0]));
			if (in_end < 0) break;
			in_end += strlen(str_end);
			if (in_end - in_sta == str_subject.Length()) break;
			str_subject.Remove(in_sta, in_end - in_sta);
			str_subject.Insert(in_sta, ".*");
		}
	}

	// .*ɒu
	char *chpa_nums[] = {
		"0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
		"O", "P", "Q", "R", "S", "T", "U", "V", "W", "X",
		"\", "", "", "O", "l", "", "Z", "", "", "",
		"", "", "", "Q", "", "E", " ", "@",
		"Part", "part", "PART", "o", "", "o`qs", "", "",
	};
	for (unsigned int i = 0; i < sizeof(chpa_nums) / sizeof(chpa_nums[0]); i++) {
		CYoString str_tmp = chpa_nums[i];
		str_tmp.ConvertKCodeEx(CYoString::SJISTOEUC);
		str_subject.Replace(str_tmp, ".*");
	}

	// A.*܂Ƃ߂
	while (str_subject.Find(".*.*") >= 0) {
		str_subject.Replace(".*.*", ".*");
	}

	str_subject.ConvertKCodeEx(CYoString::EUCTOSJIS);
	PRINTLOG("%s", (const char*)str_subject);
	m_pSubjectView->Search(str_subject);
}

void Cq2chwmApp::OnUpdateSearchRelatedSubject(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(((CFrameWnd*)m_pMainWnd)->GetActiveView() == m_pDatView ||
		((CFrameWnd*)m_pMainWnd)->GetActiveView() == m_pSubjectView);
}

void Cq2chwmApp::PopupViewMenu()
{
	CMenu cMenu;
	cMenu.LoadMenu(IDR_MENU_VIEW);
	cMenu.GetSubMenu(0)->TrackPopupMenuEx(TPM_LEFTALIGN, 0, 0, AfxGetMainWnd(), NULL);
}

void Cq2chwmApp::OnUpdateConfig(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_pBookmarkView->IsRunning() == FALSE);
}

void Cq2chwmApp::OnUpdateExit(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_pBookmarkView->IsRunning() == FALSE);
}
