#pragma once

#ifdef WIN32
#include "afxcview.h"
#endif
#include "q2chwmCommon.h"
#include "YoCommon.h"
#include "YoHttpClient.h"
#ifdef _WIN32_WCE
#include <imaging.h>
#else
#include <atlimage.h>
#endif

// Cq2chwmImageView r[

class Cq2chwmImageView : public CScrollView
{
	DECLARE_DYNCREATE(Cq2chwmImageView)

private:
	HBITMAP m_hBitmap;
#ifdef _WIN32_WCE
#else
	CImage *m_pImage;
#endif
	CWnd *m_pParent;
	CSize m_sizeImage;
	CString m_cstr_error;
	CYoString m_str_url;
	CYoString m_str_filename;
	BOOL m_bo_fit;
	BOOL m_bo_running;

private:
	BOOL httpGet(const char *chp_url);
	BOOL setSize();
	static CRect getAdjustRect(const CSize sizeImage, const CSize sizeHint);
	void setErrorMessage(const char *chp_func, DWORD dwLine, DWORD dwError, LPCTSTR lpszFormat, ...);
	CSize getViewSize();

public:
	Cq2chwmImageView();           // IŎgp protected RXgN^
	virtual ~Cq2chwmImageView();
	BOOL SetUrl(const char *chp_url, BOOL bo_force = FALSE);
	const char *GetFileName(){ return m_str_filename; }
	BOOL IsRunning(){ return m_bo_running; }

#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

protected:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
public:
	virtual void OnInitialUpdate();     // \z 1 
public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnReload();
	afx_msg void OnDelete();
	afx_msg void OnUpdateDelete(CCmdUI *pCmdUI);
};
