#pragma once

#include "YoPtrArray.h"
#include "q2chwmCommon.h"
#include "q2chwmCacheImageItem.h"

class Cq2chwmCacheImageFile : public CYoPtrArray
{
public:
	enum {
		IDX_INDEX = 0,
		IDX_NAME,
		IDX_DATE,
		IDX_SEARCH
	};

private:
	static int compAsc(const void *vop_user, const void *a, const void *b);
	static int compDesc(const void *vop_user, const void *a, const void *b);

private:
	BOOL readDirectory(const char *chp_dir, int& in_index);
	BOOL addItem(int in_index, const char *chp_filename, const char *chp_date);

public:
	Cq2chwmCacheImageFile();
	~Cq2chwmCacheImageFile();

	Cq2chwmCacheImageItem *GetItem(int in_index){ return (Cq2chwmCacheImageItem*)Get(in_index); }

	int Create();
	void RemoveAll();
	void Sort(int in_col, BOOL bo_asc);
	void RemoveItem(int in_index);
	int SearchItem(const char *chp_filename);
	BOOL UpdateItem(int in_row);
	BOOL AddItem(const char *chp_filename);
};
